/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.editor.gui.popup;

import com.tom.cpl.gui.IGui;
import com.tom.cpl.gui.elements.Button;
import com.tom.cpl.gui.elements.ConfirmPopup;
import com.tom.cpl.gui.elements.FileChooserPopup;
import com.tom.cpl.gui.elements.Label;
import com.tom.cpl.gui.elements.MessagePopup;
import com.tom.cpl.gui.elements.PopupPanel;
import com.tom.cpl.gui.elements.Spinner;
import com.tom.cpl.gui.elements.Tooltip;
import com.tom.cpl.math.Box;
import com.tom.cpm.shared.editor.ETextures;
import com.tom.cpm.shared.editor.Editor;
import com.tom.cpm.shared.editor.gui.EditorGui;
import com.tom.cpm.shared.editor.gui.popup.NewSkinPopup;

public class SkinSettingsPopup
extends PopupPanel {
    private static boolean shownWarning = false;

    public static void showPopup(EditorGui e) {
        Editor editor = e.getEditor();
        ETextures tex = editor.getTextureProvider();
        if (tex != null && tex.isEditable()) {
            e.openPopup(new SkinSettingsPopup(e.getGui(), e));
        }
    }

    private SkinSettingsPopup(IGui gui, EditorGui e) {
        super(gui);
        Editor editor = e.getEditor();
        ETextures tex = editor.getTextureProvider();
        Button openSkinBtn = new Button(gui, gui.i18nFormat("button.cpm.openSkin", new Object[0]), () -> {
            FileChooserPopup fc = new FileChooserPopup(editor.frame);
            fc.setTitle(gui.i18nFormat("label.cpm.loadSkin", new Object[0]));
            fc.setFileDescText(gui.i18nFormat("label.cpm.file_png", new Object[0]));
            fc.setFilter(new FileChooserPopup.FileFilter("png"));
            fc.setAccept(e::loadSkin);
            fc.setButtonText(gui.i18nFormat("button.cpm.ok", new Object[0]));
            e.openPopup(fc);
            this.close();
        });
        openSkinBtn.setBounds(new Box(5, 5, 60, 20));
        this.addElement(openSkinBtn);
        Button saveSkin = new Button(gui, gui.i18nFormat("button.cpm.saveSkin", new Object[0]), () -> {
            if (gui.isShiftDown() || tex.file == null) {
                FileChooserPopup fc = new FileChooserPopup(editor.frame);
                fc.setTitle(gui.i18nFormat("label.cpm.saveSkin", new Object[0]));
                fc.setFileDescText(gui.i18nFormat("label.cpm.file_png", new Object[0]));
                fc.setFilter(new FileChooserPopup.FileFilter("png"));
                fc.setSaveDialog(true);
                fc.setExtAdder(f -> f + ".png");
                fc.setButtonText(gui.i18nFormat("button.cpm.ok", new Object[0]));
                fc.setAccept(editor::saveSkin);
                e.openPopup(fc);
            } else {
                editor.saveSkin(tex.file);
            }
            this.close();
        });
        saveSkin.setBounds(new Box(75, 5, 60, 20));
        this.addElement(saveSkin);
        Button newSkin = new Button(gui, gui.i18nFormat("button.cpm.newSkin", new Object[0]), () -> {
            this.close();
            e.openPopup(new NewSkinPopup(gui, editor));
        });
        newSkin.setBounds(new Box(145, 5, 60, 20));
        this.addElement(newSkin);
        Button delSkin = new Button(gui, gui.i18nFormat("button.cpm.delSkin", new Object[0]), () -> {
            boolean edited = tex.isEdited();
            if (edited) {
                e.openPopup(new ConfirmPopup(e, gui.i18nFormat("label.cpm.delSkin", new Object[0]), () -> editor.action("delTexture").updateValueOp(tex, tex.getImage(), tex.copyDefaultImg(), ETextures::setImage).updateValueOp(tex, tex.isEdited(), false, ETextures::setEdited).onAction(() -> {
                    editor.reloadSkin();
                    editor.restitchTextures();
                    editor.updateGui();
                }).execute(), null));
            }
        });
        delSkin.setBounds(new Box(5, 30, 60, 20));
        this.addElement(delSkin);
        Label lblT = new Label(gui, gui.i18nFormat("label.cpm.sheetSize", new Object[0]));
        lblT.setBounds(new Box(5, 80, 80, 18));
        lblT.setTooltip(new Tooltip(e, gui.i18nFormat("tooltip.cpm.texture_sheet", new Object[0])));
        this.addElement(lblT);
        Label lblTW = new Label(gui, gui.i18nFormat("label.cpm.width", new Object[0]));
        lblTW.setBounds(new Box(5, 90, 40, 18));
        Label lblTH = new Label(gui, gui.i18nFormat("label.cpm.height", new Object[0]));
        lblTH.setBounds(new Box(75, 90, 40, 18));
        Spinner spinnerTW = new Spinner(gui);
        Spinner spinnerTH = new Spinner(gui);
        spinnerTW.setBounds(new Box(5, 100, 65, 18));
        spinnerTH.setBounds(new Box(75, 100, 65, 18));
        spinnerTW.setDp(0);
        spinnerTH.setDp(0);
        this.addElement(spinnerTW);
        this.addElement(spinnerTH);
        this.addElement(lblTW);
        this.addElement(lblTH);
        Runnable r = () -> {
            if (editor.hasVanillaParts() && !shownWarning) {
                shownWarning = true;
                e.openPopup(new MessagePopup(e, gui.i18nFormat("label.cpm.warning", new Object[0]), gui.i18nFormat("label.cpm.skin_has_vanilla_parts", new Object[0])));
            } else {
                editor.setTexSize((int)spinnerTW.getValue(), (int)spinnerTH.getValue());
            }
        };
        spinnerTW.addChangeListener(r);
        spinnerTH.addChangeListener(r);
        spinnerTW.setValue(tex.provider.size.x);
        spinnerTH.setValue(tex.provider.size.y);
        this.setBounds(new Box(0, 0, 210, 140));
    }

    @Override
    public String getTitle() {
        return this.gui.i18nFormat("button.cpm.skinSettings", new Object[0]);
    }
}

