/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.editor.gui.popup;

import com.tom.cpl.gui.elements.Button;
import com.tom.cpl.gui.elements.PopupPanel;
import com.tom.cpl.math.Box;
import com.tom.cpl.math.MatrixStack;
import com.tom.cpl.math.Vec2i;
import com.tom.cpl.render.VBuffers;
import com.tom.cpl.util.Image;
import com.tom.cpm.shared.definition.ModelDefinition;
import com.tom.cpm.shared.editor.ETextures;
import com.tom.cpm.shared.editor.Editor;
import com.tom.cpm.shared.editor.gui.EditorGui;
import com.tom.cpm.shared.editor.util.ModelDescription;
import com.tom.cpm.shared.gui.ViewportCamera;
import com.tom.cpm.shared.gui.panel.ViewportPanelBase3d;
import com.tom.cpm.shared.model.PartRoot;
import com.tom.cpm.shared.model.RootModelElement;
import com.tom.cpm.shared.model.SkinType;
import com.tom.cpm.shared.model.TextureSheetType;
import com.tom.cpm.shared.model.render.VanillaModelPart;
import com.tom.cpm.shared.skin.TextureProvider;
import java.util.function.Consumer;

public class ScreenshotPopup
extends PopupPanel {
    public ScreenshotPopup(EditorGui eg, Consumer<Image> setter, Runnable onClosed) {
        super(eg.getGui());
        Editor e = eg.getEditor();
        ViewportCamera cam = e.description != null ? e.description.camera : new ViewportCamera();
        DisplayPanel camPanel = new DisplayPanel(eg, cam);
        e.displayViewport.accept(false);
        this.setOnClosed(() -> {
            e.displayViewport.accept(true);
            onClosed.run();
        });
        camPanel.setBounds(new Box(12, 10, 256, 256));
        this.addElement(camPanel);
        Button take = new Button(this.gui, this.gui.i18nFormat("button.cpm.takeScreenshot", new Object[0]), () -> {
            if (e.description == null) {
                e.description = new ModelDescription();
            }
            e.description.camera = cam;
            e.description.icon = camPanel.takeScreenshot(new Vec2i(256, 256));
            setter.accept(e.description.icon);
            e.markDirty();
            this.close();
        });
        take.setBounds(new Box(90, 270, 100, 20));
        this.addElement(take);
        this.setBounds(new Box(0, 0, 280, 300));
    }

    @Override
    public String getTitle() {
        return this.gui.i18nFormat("label.cpm.screenshotPopup", new Object[0]);
    }

    private static class DisplayPanel
    extends ViewportPanelBase3d {
        private Def def;
        private ViewportCamera cam;
        private EditorGui e;

        public DisplayPanel(EditorGui e, ViewportCamera cam) {
            super(e);
            this.cam = cam;
            this.def = new Def(e.getEditor());
            this.e = e;
        }

        @Override
        public void render(MatrixStack stack, VBuffers buf, float partialTicks) {
            this.renderModel(stack, buf, partialTicks);
        }

        @Override
        public ViewportCamera getCamera() {
            return this.cam;
        }

        @Override
        public void preRender(MatrixStack stack, VBuffers buf) {
            this.e.getEditor().preRender();
        }

        @Override
        public ModelDefinition getDefinition() {
            return this.def;
        }
    }

    private static class Def
    extends ModelDefinition {
        private Editor editor;

        public Def(Editor editor) {
            this.editor = editor;
        }

        @Override
        public PartRoot getModelElementFor(VanillaModelPart part) {
            PartRoot root = new PartRoot();
            this.editor.elements.forEach(e -> {
                RootModelElement el = (RootModelElement)e.rc;
                if (el.getPart() == part) {
                    root.add(el);
                    if (!e.duplicated) {
                        root.setMainRoot(el);
                    }
                }
            });
            return root;
        }

        @Override
        public TextureProvider getTexture(TextureSheetType key, boolean inGui) {
            ETextures tex = this.editor.textures.get((Object)key);
            return tex != null ? tex.getRenderTexture() : null;
        }

        @Override
        public SkinType getSkinType() {
            return this.editor.skinType;
        }

        @Override
        public boolean hasRoot(VanillaModelPart type) {
            return this.editor.elements.stream().map(e -> ((RootModelElement)e.rc).getPart()).anyMatch(t -> t == type);
        }
    }
}

