/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.editor.gui.popup;

import com.tom.cpl.gui.Frame;
import com.tom.cpl.gui.elements.Button;
import com.tom.cpl.gui.elements.Label;
import com.tom.cpl.gui.elements.Panel;
import com.tom.cpl.gui.elements.PopupPanel;
import com.tom.cpl.gui.elements.TextField;
import com.tom.cpl.gui.elements.Tooltip;
import com.tom.cpl.gui.util.HorizontalLayout;
import com.tom.cpl.gui.util.TabbedPanelManager;
import com.tom.cpl.math.Box;
import com.tom.cpm.shared.definition.Link;
import com.tom.cpm.shared.editor.gui.EditorGui;
import com.tom.cpm.shared.paste.PastePopup;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;

public class OverflowPopup
extends PopupPanel {
    private HorizontalLayout topPanel;
    private TabbedPanelManager tabs;
    private String reason;

    public OverflowPopup(EditorGui frm, String text, String reason, Consumer<Link> ok) {
        super(frm.getGui());
        this.reason = reason;
        this.setBounds(new Box(0, 0, 260, 140));
        this.tabs = new TabbedPanelManager(this.gui);
        this.tabs.setBounds(new Box(0, 20, this.bounds.w, this.bounds.h - 20));
        this.addElement(this.tabs);
        Panel topPanel = new Panel(this.gui);
        topPanel.setBounds(new Box(0, 0, this.bounds.w, 20));
        topPanel.setBackgroundColor(this.gui.getColors().menu_bar_background);
        this.addElement(topPanel);
        this.topPanel = new HorizontalLayout(topPanel);
        Panel paste = new Panel(this.gui);
        this.addTab("paste", paste, 5);
        Label lbl1 = new Label(this.gui, this.gui.i18nFormat("label.cpm." + reason + "Overflow", new Object[0]));
        lbl1.setBounds(new Box(5, 0, 0, 0));
        paste.addElement(lbl1);
        Label lbl2 = new Label(this.gui, this.gui.i18nFormat("label.cpm.paste.name", new Object[0]));
        lbl2.setBounds(new Box(5, 10, 0, 0));
        paste.addElement(lbl2);
        TextField txtf = new TextField(this.gui);
        File file = frm.getEditor().file;
        String name = file == null ? this.gui.i18nFormat("label.cpm.new_project", new Object[0]) : file.getName();
        txtf.setText(name);
        txtf.setBounds(new Box(5, 20, 205, 20));
        paste.addElement(txtf);
        Button okBtn = new Button(this.gui, this.gui.i18nFormat("button.cpm.ok", new Object[0]), () -> {
            String fn = txtf.getText();
            PastePopup.runRequest((Frame)frm, c -> c.uploadFile(fn, text.getBytes(StandardCharsets.UTF_8)), id -> ok.accept(new Link("p", (String)id)), () -> {}, "uploading");
            this.close();
        });
        okBtn.setBounds(new Box(110, 70, 40, 20));
        paste.addElement(okBtn);
        Panel gist = new Panel(this.gui);
        this.addTab("gist", gist, 5);
        lbl1 = new Label(this.gui, this.gui.i18nFormat("label.cpm." + reason + "Overflow", new Object[0]));
        lbl1.setBounds(new Box(5, 0, 0, 0));
        gist.addElement(lbl1);
        lbl2 = new Label(this.gui, this.gui.i18nFormat("label.cpm.createGist", new Object[0]));
        lbl2.setBounds(new Box(5, 10, 0, 0));
        gist.addElement(lbl2);
        txtf = new TextField(this.gui);
        txtf.setText(text);
        txtf.setBounds(new Box(5, 20, 205, 20));
        gist.addElement(txtf);
        Label lbl3 = new Label(this.gui, this.gui.i18nFormat("label.cpm.uploadURL", new Object[0]));
        lbl3.setBounds(new Box(5, 45, 0, 0));
        gist.addElement(lbl3);
        Label lbl4 = new Label(this.gui, "");
        TextField urlf = new TextField(this.gui);
        urlf.setBounds(new Box(5, 55, 205, 20));
        urlf.setEventListener(() -> this.checkURL(frm, urlf.getText(), lbl4, null));
        gist.addElement(urlf);
        lbl4.setBounds(new Box(5, 80, 250, 10));
        gist.addElement(lbl4);
        Button okBtn2 = new Button(this.gui, this.gui.i18nFormat("button.cpm.ok", new Object[0]), () -> this.checkURL(frm, urlf.getText(), lbl4, l -> {
            ok.accept((Link)l);
            this.close();
        }));
        okBtn2.setBounds(new Box(110, 80, 40, 20));
        gist.addElement(okBtn2);
        Button cpyBtn = new Button(this.gui, this.gui.i18nFormat("button.cpm.copy", new Object[0]), () -> this.gui.setClipboardText(text));
        cpyBtn.setBounds(new Box(215, 20, 40, 20));
        gist.addElement(cpyBtn);
        Button pasteBtn = new Button(this.gui, this.gui.i18nFormat("button.cpm.paste", new Object[0]), () -> {
            urlf.setText(this.gui.getClipboardText());
            this.checkURL(frm, urlf.getText(), lbl4, null);
        });
        pasteBtn.setBounds(new Box(215, 55, 40, 20));
        gist.addElement(pasteBtn);
    }

    private void checkURL(Frame frm, String text, Label setter, Consumer<Link> linkConsumer) {
        if (text.isEmpty()) {
            setter.setText("");
            setter.setTooltip(null);
            return;
        }
        if (text.startsWith("https://gist.github.com/")) {
            String[] sp = (text = text.substring("https://gist.github.com/".length())).split("/");
            if (sp.length < 2) {
                setter.setText("Inavlid Gist URL");
                setter.setTooltip(new Tooltip(frm, "Your link should look like this:\\https://gist.github.com/<name>/<gist>"));
                return;
            }
            setter.setText("");
            setter.setTooltip(null);
            if (linkConsumer != null) {
                linkConsumer.accept(new Link("git", sp[0] + "/" + sp[1]));
            }
            return;
        }
        setter.setText("Unknown URL");
        setter.setTooltip(new Tooltip(frm, "Unknown link, currently only GitHub Gists are supported."));
    }

    @Override
    public String getTitle() {
        return this.gui.i18nFormat("label.cpm.export" + Character.toUpperCase(this.reason.charAt(0)) + this.reason.substring(1), new Object[0]);
    }

    public void addTab(String name, Panel panel, int topPadding) {
        panel.setBounds(new Box(0, topPadding, this.bounds.w, this.bounds.h - 20));
        this.topPanel.add(this.tabs.createTab(this.gui.i18nFormat("tab.cpm.export." + name, new Object[0]), panel));
    }
}

