/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.editor.gui.popup;

import com.tom.cpl.gui.IGui;
import com.tom.cpl.gui.elements.Button;
import com.tom.cpl.gui.elements.Checkbox;
import com.tom.cpl.gui.elements.DropDownBox;
import com.tom.cpl.gui.elements.Label;
import com.tom.cpl.gui.elements.ListPicker;
import com.tom.cpl.gui.elements.PopupPanel;
import com.tom.cpl.gui.elements.TextField;
import com.tom.cpl.gui.elements.Tooltip;
import com.tom.cpl.math.Box;
import com.tom.cpl.util.NamedElement;
import com.tom.cpm.shared.animation.CustomPose;
import com.tom.cpm.shared.animation.IPose;
import com.tom.cpm.shared.animation.VanillaPose;
import com.tom.cpm.shared.animation.interpolator.InterpolatorType;
import com.tom.cpm.shared.editor.Editor;
import com.tom.cpm.shared.editor.anim.AnimationDisplayData;
import java.util.ArrayList;
import java.util.Comparator;

public class AnimationSettinsPopup
extends PopupPanel {
    private final Editor editor;
    private String title;

    public AnimationSettinsPopup(IGui gui, Editor editor, boolean edit) {
        super(gui);
        this.editor = editor;
        this.setBounds(new Box(0, 0, 200, 170));
        AnimType sel = null;
        ArrayList<AnimType> ats = new ArrayList<AnimType>();
        for (VanillaPose p : VanillaPose.VALUES) {
            if (p == VanillaPose.CUSTOM) continue;
            AnimType type = new AnimType(p);
            ats.add(type);
            if (!edit || editor.selectedAnim == null || p != editor.selectedAnim.pose) continue;
            sel = type;
        }
        AnimType typePose = new AnimType("pose", false);
        ats.add(typePose);
        AnimType typeGesture = new AnimType("gesture", true);
        ats.add(typeGesture);
        AnimType typeLayer = new AnimType("layer", false);
        ats.add(typeLayer);
        AnimType typeValue = new AnimType("value", false);
        ats.add(typeValue);
        if (edit && editor.selectedAnim != null && sel == null) {
            sel = editor.selectedAnim.pose == null ? (editor.selectedAnim.displayName.startsWith("$layer$") ? typeLayer : (editor.selectedAnim.displayName.startsWith("$value$") ? typeValue : typeGesture)) : typePose;
        }
        ListPicker typeDd = new ListPicker(editor.frame, ats);
        typeDd.setListLoader(l -> {
            l.setComparator(Comparator.comparing(AnimType::getType).thenComparing(Comparator.comparing(AnimType::toString)));
            l.setRenderer(AnimType::draw);
            l.setGetTooltip(AnimType::getTooltip);
        });
        typeDd.setBounds(new Box(5, 5, 190, 20));
        this.addElement(typeDd);
        if (sel != null) {
            typeDd.setSelected(sel);
        }
        Checkbox boxAdd = new Checkbox(gui, gui.i18nFormat("label.cpm.anim_additive", new Object[0]));
        if (edit && editor.selectedAnim != null) {
            boxAdd.setSelected(editor.selectedAnim.add);
        } else {
            boxAdd.setSelected(true);
        }
        boxAdd.setBounds(new Box(5, 30, 60, 18));
        this.addElement(boxAdd);
        boxAdd.setAction(() -> boxAdd.setSelected(!boxAdd.isSelected()));
        Checkbox boxLoop = new Checkbox(gui, gui.i18nFormat("label.cpm.anim_loop", new Object[0]));
        if (edit && editor.selectedAnim != null) {
            boxLoop.setSelected(editor.selectedAnim.loop);
        }
        boxLoop.setBounds(new Box(5, 50, 60, 18));
        this.addElement(boxLoop);
        this.addElement(new Label(gui, gui.i18nFormat("label.cpm.name", new Object[0])).setBounds(new Box(5, 70, 0, 0)));
        TextField nameField = new TextField(gui);
        if (edit && editor.selectedAnim != null) {
            nameField.setText(editor.selectedAnim.getDisplayName());
        }
        nameField.setBounds(new Box(5, 80, 190, 20));
        this.addElement(nameField);
        this.addElement(new Label(gui, gui.i18nFormat("label.cpm.animIntType", new Object[0])).setBounds(new Box(5, 105, 190, 10)));
        NamedElement.NameMapper<InterpolatorType> intMap = new NamedElement.NameMapper<InterpolatorType>(InterpolatorType.VALUES, e -> gui.i18nFormat("label.cpm.animIntType." + e.name().toLowerCase(), new Object[0]));
        DropDownBox<NamedElement<InterpolatorType>> intBox = new DropDownBox<NamedElement<InterpolatorType>>(editor.frame, intMap.asList());
        intMap.setSetter(intBox::setSelected);
        if (edit && editor.selectedAnim != null) {
            intMap.setValue(editor.selectedAnim.intType);
        } else {
            intMap.setValue(InterpolatorType.POLY_LOOP);
        }
        intBox.setBounds(new Box(5, 115, 190, 20));
        this.addElement(intBox);
        Runnable r = () -> {
            AnimType at = (AnimType)typeDd.getSelected();
            boxLoop.setEnabled(at.loop);
            if (!edit) {
                intMap.setValue(((InterpolatorType)((Object)((Object)((NamedElement)intBox.getSelected()).getElem()))).getAlt(at.useLooping()));
            }
        };
        typeDd.setAction(r);
        r.run();
        boxLoop.setAction(() -> {
            boolean s;
            boolean bl = s = !boxLoop.isSelected();
            if (!edit) {
                intMap.setValue(((InterpolatorType)((Object)((Object)((NamedElement)intBox.getSelected()).getElem()))).getAlt(s));
            }
            boxLoop.setSelected(s);
        });
        Button okBtn = new Button(gui, gui.i18nFormat("button.cpm.ok", new Object[0]), () -> {
            VanillaPose pose;
            Object name = nameField.getText();
            AnimType at = (AnimType)typeDd.getSelected();
            IPose iPose = pose = at.pose == null && at.option.equals("pose") ? new CustomPose((String)name) : at.pose;
            if (at.pose == null) {
                if (at.option.equals("layer")) {
                    name = "$layer$" + (String)name;
                } else if (at.option.equals("value")) {
                    name = "$value$" + (String)name;
                }
            }
            if (edit) {
                editor.editAnim(pose, (String)name, boxAdd.isSelected(), at.loop && boxLoop.isSelected(), (InterpolatorType)((Object)((Object)((NamedElement)intBox.getSelected()).getElem())));
            } else {
                editor.addNewAnim(pose, (String)name, boxAdd.isSelected(), at.loop && boxLoop.isSelected(), (InterpolatorType)((Object)((Object)((NamedElement)intBox.getSelected()).getElem())));
            }
            this.close();
        });
        okBtn.setBounds(new Box(80, 140, 40, 20));
        this.addElement(okBtn);
        this.title = gui.i18nFormat("label.cpm.animationSettings." + (edit ? "edit" : "new"), new Object[0]);
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    private class AnimType {
        private VanillaPose pose;
        private AnimationDisplayData display;
        private String option;
        private boolean loop;

        public AnimType(VanillaPose pose) {
            this.pose = pose;
            this.display = AnimationDisplayData.getFor(pose);
        }

        public AnimType(String option, boolean loop) {
            this.option = option;
            this.loop = loop;
        }

        public String toString() {
            if (this.pose != null) {
                return AnimationSettinsPopup.this.gui.i18nFormat("label.cpm.anim_pose", this.pose.getName(AnimationSettinsPopup.this.gui, null));
            }
            return AnimationSettinsPopup.this.gui.i18nFormat("label.cpm.new_anim_" + this.option, new Object[0]);
        }

        private AnimationDisplayData.Type getType() {
            return this.display == null ? AnimationDisplayData.Type.CUSTOM : this.display.type;
        }

        private Tooltip getTooltip() {
            String tooltip = AnimationSettinsPopup.this.gui.i18nFormat("tooltip.cpm.animType.group." + this.getType().name().toLowerCase(), new Object[0]);
            String tip = "tooltip.cpm.animType.pose." + (String)(this.pose != null ? this.pose.name().toLowerCase() : "opt_" + this.option);
            String desc = AnimationSettinsPopup.this.gui.i18nFormat(tip, new Object[0]);
            String name = this.toString();
            String fullTip = name + "\\" + tooltip;
            if (!tip.equals(desc)) {
                fullTip = fullTip + "\\" + desc;
            }
            return new Tooltip(AnimationSettinsPopup.this.editor.frame, fullTip);
        }

        private void draw(int x, int y, int w, int h, boolean hovered, boolean selected) {
            int bg = ((AnimationSettinsPopup)AnimationSettinsPopup.this).gui.getColors().select_background;
            if (hovered) {
                bg = ((AnimationSettinsPopup)AnimationSettinsPopup.this).gui.getColors().popup_background;
            }
            if (selected || hovered) {
                AnimationSettinsPopup.this.gui.drawBox(x, y, w, h, bg);
            }
            AnimationSettinsPopup.this.gui.drawText(x + 3, y + h / 2 - 4, this.toString(), this.getType().color);
        }

        private boolean useLooping() {
            return this.pose == null ? true : !this.pose.hasStateGetter();
        }
    }
}

