/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.editor.gui;

import com.tom.cpl.gui.IGui;
import com.tom.cpl.gui.KeyboardEvent;
import com.tom.cpl.gui.MouseEvent;
import com.tom.cpl.gui.elements.GuiElement;
import com.tom.cpl.math.Box;
import com.tom.cpl.math.MathHelper;
import com.tom.cpl.math.Vec2i;
import com.tom.cpl.math.Vec3f;
import com.tom.cpl.math.Vec4f;
import com.tom.cpm.shared.editor.ETextures;
import com.tom.cpm.shared.editor.Editor;
import com.tom.cpm.shared.editor.EditorTool;
import com.tom.cpm.shared.editor.ElementType;
import com.tom.cpm.shared.editor.anim.AnimatedTex;
import com.tom.cpm.shared.editor.gui.EditorGui;
import com.tom.cpm.shared.editor.gui.TextureDisplay;
import com.tom.cpm.shared.editor.tree.TreeElement;
import com.tom.cpm.shared.editor.util.UVResizableArea;
import java.util.ArrayList;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class TextureEditorPanel
extends GuiElement {
    private int lastMx;
    private int lastMy;
    private boolean dragging;
    private float zoom;
    private int offX;
    private int offY;
    private int dragX;
    private int dragY;
    private Editor editor;
    public Supplier<Vec2i> cursorPos;
    private Vec2i mouseCursorPos = new Vec2i();
    private Vec2i moveStart;

    public TextureEditorPanel(IGui gui, Editor editor, int zoom) {
        super(gui);
        this.editor = editor;
        this.zoom = 0.0f;
        int dark = gui.getColors().button_border;
        int light = gui.getColors().button_disabled;
        editor.textureEditorBg.getImage().setRGB(0, 0, dark);
        editor.textureEditorBg.getImage().setRGB(1, 0, light);
        editor.textureEditorBg.getImage().setRGB(0, 1, light);
        editor.textureEditorBg.getImage().setRGB(1, 1, dark);
        editor.textureEditorBg.texture.markDirty();
    }

    @Override
    public void draw(MouseEvent event, float partialTicks) {
        this.mouseCursorPos.x = event.x;
        this.mouseCursorPos.y = event.y;
        this.gui.pushMatrix();
        this.gui.setPosOffset(this.bounds);
        this.gui.setupCut();
        this.gui.drawBox(0, 0, this.bounds.w, this.bounds.h, this.gui.getColors().button_fill);
        ETextures provider = this.editor.getTextureProvider();
        if (provider != null) {
            if (this.zoom == 0.0f) {
                this.zoom = (float)this.bounds.h / (float)provider.getImage().getWidth();
            }
            int rw = (int)(this.zoom * (float)provider.getImage().getWidth());
            int rh = (int)(this.zoom * (float)provider.getImage().getHeight());
            this.editor.textureEditorBg.bind();
            this.gui.drawTexture(this.offX, this.offY, rw, rh, 0.0f, 0.0f, (float)rw / 8.0f, (float)rh / 8.0f);
            provider.provider.bind();
            this.gui.drawTexture(this.offX, this.offY, rw, rh, 0.0f, 0.0f, 1.0f, 1.0f);
            int imgX = (int)((float)(event.x - this.offX - this.bounds.x) / this.zoom);
            int imgY = (int)((float)(event.y - this.offY - this.bounds.y) / this.zoom);
            TextureDisplay.drawBoxTextureOverlay(this.gui, this.editor, this.offX, this.offY, this.zoom, this.zoom, true);
            Vec2i p1 = event.isHovered(this.bounds) && imgX >= 0 && imgY >= 0 && imgX < provider.getImage().getWidth() && imgY < provider.getImage().getHeight() ? new Vec2i(imgX, imgY) : null;
            switch (this.editor.drawMode.get()) {
                case MOVE_UV: {
                    Box b;
                    if (p1 == null) break;
                    TreeElement e = this.getElementUnderMouse(event);
                    if (this.dragging && this.moveStart != null) {
                        e = this.editor.getSelectedElement();
                    }
                    if (e == null || (b = e.getTextureBox()) == null) break;
                    Vec4f s = UVResizableArea.expandBox(b, this.zoom);
                    this.gui.drawRectangle(s.x * this.zoom + (float)this.offX, s.y * this.zoom + (float)this.offY, s.z * this.zoom, s.w * this.zoom, -16777216);
                    break;
                }
                case PEN: 
                case RUBBER: 
                case COLOR_PICKER: {
                    Vec2i p;
                    Vec2i p2 = this.editor.cursorPos.get();
                    Vec2i vec2i = p = p2 != null ? p2 : p1;
                    if (!provider.isEditable() || p == null || p.x < 0 || p.y < 0 || p.x >= provider.getImage().getWidth() || p.y >= provider.getImage().getHeight()) break;
                    int imgC = provider.getImage().getRGB(p.x, p.y);
                    int outlineColor = 0xFFFFFF - (imgC & 0xFFFFFF) & 0xFFFFFF;
                    int a = imgC >> 24 & 0xFF;
                    if (a < 64) {
                        outlineColor = 0;
                    }
                    if (a == 0) {
                        imgC = -1;
                    }
                    this.gui.drawRectangle((float)p.x * this.zoom + (float)this.offX, (float)p.y * this.zoom + (float)this.offY, this.zoom, this.zoom, 0xFF000000 | outlineColor);
                    break;
                }
            }
        }
        this.gui.popMatrix();
    }

    private TreeElement getElementUnderMouse(MouseEvent event) {
        float x = (float)(event.x - this.offX - this.bounds.x) / this.zoom;
        float y = (float)(event.y - this.offY - this.bounds.y) / this.zoom;
        ArrayList elems = new ArrayList();
        this.walkElements(e -> {
            if (UVResizableArea.isHovered(e.getTextureBox(), x, y, this.zoom)) {
                elems.add(e);
            }
        });
        if (elems.contains(this.editor.selectedElement)) {
            return this.editor.selectedElement;
        }
        return !elems.isEmpty() ? (TreeElement)elems.get(0) : null;
    }

    private void walkElements(Consumer<TreeElement> c) {
        if (this.editor.selectedElement != null && (this.editor.getSelectedElement() == null || this.editor.getSelectedElement().type == ElementType.NORMAL)) {
            c.accept(this.editor.selectedElement);
            this.editor.selectedElement.getSettingsElements().forEach(c);
            AnimatedTex.applyAnims(this.editor.selectedElement, c);
        }
        Editor.walkElements(this.editor.elements, e -> {
            if (e.type != ElementType.NORMAL) {
                return;
            }
            c.accept((TreeElement)e);
            e.getSettingsElements().forEach(c);
        });
    }

    @Override
    public boolean mouseWheel(int x, int y, int dir) {
        if (this.bounds.isInBounds(x, y)) {
            this.zoom(x, y, dir);
            return true;
        }
        return false;
    }

    @Override
    public void mouseClick(MouseEvent event) {
        if (event.isHovered(this.bounds)) {
            this.lastMx = event.x;
            this.lastMy = event.y;
            this.dragging = true;
            ETextures provider = this.editor.getTextureProvider();
            int r = EditorGui.getRotateMouseButton();
            if (!(r != 0 ? event.btn == r : this.gui.isShiftDown()) && event.btn == 0) {
                int px = (int)((float)(event.x - this.offX - this.bounds.x) / this.zoom);
                int py = (int)((float)(event.y - this.offY - this.bounds.y) / this.zoom);
                if (px >= 0 && py >= 0 && px < provider.getImage().getWidth() && py < provider.getImage().getHeight()) {
                    switch (this.editor.drawMode.get()) {
                        case PEN: 
                        case RUBBER: 
                        case COLOR_PICKER: 
                        case FILL: {
                            if (this.gui.isCtrlDown() || this.editor.drawMode.get() == EditorTool.COLOR_PICKER) {
                                this.editor.penColor = provider.getImage().getRGB(px, py);
                                this.editor.setPenColor.accept(this.editor.penColor);
                                this.dragging = false;
                                break;
                            }
                            this.editor.drawPixel(px, py, false);
                            break;
                        }
                        case MOVE_UV: {
                            this.dragX = px;
                            this.dragY = py;
                            TreeElement me = this.getElementUnderMouse(event);
                            if (me != null) {
                                me.onClick(this.editor, event);
                                this.moveStart = new Vec2i();
                                Vec3f uv = me.getVec(TreeElement.VecType.TEXTURE);
                                this.moveStart.x = (int)uv.x;
                                this.moveStart.y = (int)uv.y;
                            } else {
                                this.editor.selectedElement = null;
                            }
                            this.editor.updateGui();
                            break;
                        }
                    }
                }
            }
            event.consume();
        }
    }

    @Override
    public boolean mouseDrag(int x, int y, int btn) {
        if (this.bounds.isInBounds(x, y)) {
            if (this.dragging) {
                int dx = x - this.lastMx;
                int dy = y - this.lastMy;
                ETextures provider = this.editor.getTextureProvider();
                int r = EditorGui.getRotateMouseButton();
                if (r == 0 ? this.gui.isShiftDown() : btn == r) {
                    this.offX += dx;
                    this.offY += dy;
                    this.offX = MathHelper.clamp(this.offX, (int)((float)(-provider.getImage().getWidth()) * this.zoom + 10.0f), this.bounds.w - 10);
                    this.offY = MathHelper.clamp(this.offY, (int)((float)(-provider.getImage().getWidth()) * this.zoom + 10.0f), this.bounds.h - 10);
                } else if (btn == 0) {
                    int px = (int)((float)(x - this.offX - this.bounds.x) / this.zoom);
                    int py = (int)((float)(y - this.offY - this.bounds.y) / this.zoom);
                    if (px >= 0 && py >= 0 && px < provider.getImage().getWidth() && py < provider.getImage().getHeight()) {
                        switch (this.editor.drawMode.get()) {
                            case PEN: 
                            case RUBBER: 
                            case FILL: {
                                this.editor.drawPixel(px, py, false);
                                break;
                            }
                            case MOVE_UV: {
                                TreeElement me = this.editor.selectedElement;
                                if (me == null || this.moveStart == null) break;
                                int xoff = px - this.dragX;
                                int yoff = py - this.dragY;
                                Vec3f uv = me.getVec(TreeElement.VecType.TEXTURE);
                                if ((float)Math.abs(xoff) >= uv.z) {
                                    this.dragX = px;
                                }
                                if ((float)Math.abs(yoff) >= uv.z) {
                                    this.dragY = py;
                                }
                                uv.x = MathHelper.clamp(uv.x + (float)(xoff / (int)uv.z), 0.0f, (float)provider.provider.size.x);
                                uv.y = MathHelper.clamp(uv.y + (float)(yoff / (int)uv.z), 0.0f, (float)provider.provider.size.y);
                                me.setVecTemp(TreeElement.VecType.TEXTURE, uv);
                                break;
                            }
                        }
                    }
                }
                this.lastMx = x;
                this.lastMy = y;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseRelease(int x, int y, int btn) {
        if (this.bounds.isInBounds(x, y) || this.dragging) {
            this.dragging = false;
            switch (this.editor.drawMode.get()) {
                case MOVE_UV: {
                    TreeElement me = this.editor.selectedElement;
                    if (me == null || this.moveStart == null) break;
                    Vec3f uv = me.getVec(TreeElement.VecType.TEXTURE);
                    me.setVecTemp(TreeElement.VecType.TEXTURE, new Vec3f(this.moveStart.x, this.moveStart.y, uv.z));
                    me.setVec(uv, TreeElement.VecType.TEXTURE);
                    this.moveStart = null;
                    if (me instanceof TreeElement.TreeSettingElement) {
                        this.editor.selectedElement = ((TreeElement.TreeSettingElement)me).getParent();
                    }
                    this.editor.updateGui();
                    break;
                }
            }
            return true;
        }
        return false;
    }

    private void zoom(int x, int y, int dir) {
        ETextures provider = this.editor.getTextureProvider();
        float zv = (float)dir * (this.zoom / 8.0f);
        float iw = (float)provider.getImage().getWidth() * this.zoom;
        float ih = (float)provider.getImage().getHeight() * this.zoom;
        this.zoom += zv;
        float niw = (float)provider.getImage().getWidth() * this.zoom;
        float nih = (float)provider.getImage().getHeight() * this.zoom;
        this.offX = (int)((float)this.offX - (niw - iw) / 2.0f * (float)MathHelper.clamp(Math.abs(1 - this.offX / (this.bounds.w / 2)), 0, 1));
        this.offY = (int)((float)this.offY - (nih - ih) / 2.0f * (float)MathHelper.clamp(Math.abs(1 - this.offY / (this.bounds.h / 2)), 0, 1));
        this.offX = MathHelper.clamp(this.offX, (int)((float)(-provider.getImage().getWidth()) * this.zoom + 10.0f), this.bounds.w - 10);
        this.offY = MathHelper.clamp(this.offY, (int)((float)(-provider.getImage().getWidth()) * this.zoom + 10.0f), this.bounds.h - 10);
    }

    @Override
    public void keyPressed(KeyboardEvent event) {
        if (!event.isConsumed() && this.bounds.isInBounds(this.mouseCursorPos)) {
            if (event.matches("+")) {
                this.zoom(this.mouseCursorPos.x, this.mouseCursorPos.y, 1);
            } else if (event.matches("-")) {
                this.zoom(this.mouseCursorPos.x, this.mouseCursorPos.y, -1);
            }
        }
    }
}

