/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.editor.gui;

import com.tom.cpl.gui.IGui;
import com.tom.cpl.gui.UpdaterRegistry;
import com.tom.cpl.gui.elements.Button;
import com.tom.cpl.gui.elements.Checkbox;
import com.tom.cpl.gui.elements.GuiElement;
import com.tom.cpl.gui.elements.Label;
import com.tom.cpl.gui.elements.Panel;
import com.tom.cpl.gui.elements.Spinner;
import com.tom.cpl.gui.elements.TextField;
import com.tom.cpl.gui.elements.Tooltip;
import com.tom.cpl.gui.util.ElementGroup;
import com.tom.cpl.gui.util.FlowLayout;
import com.tom.cpl.gui.util.TabFocusHandler;
import com.tom.cpl.math.Box;
import com.tom.cpl.math.Vec3f;
import com.tom.cpm.shared.editor.Editor;
import com.tom.cpm.shared.editor.Effect;
import com.tom.cpm.shared.editor.gui.EditorGui;
import com.tom.cpm.shared.editor.gui.ModeDisplayType;
import com.tom.cpm.shared.editor.gui.TextureDisplay;
import com.tom.cpm.shared.editor.gui.popup.SkinSettingsPopup;
import com.tom.cpm.shared.editor.tree.TreeElement;
import java.util.function.Consumer;

public class PosPanel
extends Panel {
    private TabFocusHandler tabHandler;

    public PosPanel(IGui gui, EditorGui e) {
        super(gui);
        this.tabHandler = new TabFocusHandler(gui);
        Editor editor = e.getEditor();
        this.setBounds(new Box(0, 0, 170, 475));
        this.setBackgroundColor(gui.getColors().panel_background);
        FlowLayout layout = new FlowLayout(this, 4, 1);
        Panel panel = new Panel(gui);
        this.addElement(panel);
        panel.setBounds(new Box(0, 0, 170, 30));
        panel.addElement(new Label(gui, gui.i18nFormat("label.cpm.name", new Object[0])).setBounds(new Box(5, 0, 0, 0)));
        TextField nameField = new TextField(gui);
        nameField.setBounds(new Box(5, 10, 160, 20));
        editor.updateName.add(t -> {
            nameField.setEnabled(t != null);
            if (t != null) {
                nameField.setText((String)t);
            } else {
                nameField.setText("");
            }
        });
        nameField.setEventListener(() -> editor.setName(nameField.getText()));
        panel.addElement(nameField);
        this.tabHandler.add(nameField);
        PosPanel.addVec3("size", v -> editor.setVec((Vec3f)v, TreeElement.VecType.SIZE), this, editor.setSize, 1, this.tabHandler);
        PosPanel.addVec3("offset", v -> editor.setVec((Vec3f)v, TreeElement.VecType.OFFSET), this, editor.setOffset, 2, this.tabHandler);
        PosPanel.addVec3("rotation", v -> editor.setVec((Vec3f)v, TreeElement.VecType.ROTATION), this, editor.setRot, 1, this.tabHandler);
        PosPanel.addVec3("position", v -> editor.setVec((Vec3f)v, TreeElement.VecType.POSITION), this, editor.setPosition, 2, this.tabHandler);
        Panel sc = PosPanel.addVec3("scale", v -> editor.setVec((Vec3f)v, TreeElement.VecType.SCALE), this, editor.setScale, 2, this.tabHandler);
        editor.updateGui.add(() -> {
            sc.setVisible(editor.displayAdvScaling);
            layout.reflow();
        });
        Panel panel2 = new Panel(gui);
        this.addElement(panel2);
        panel2.setBounds(new Box(0, 0, 170, 30));
        panel2.addElement(new Label(gui, gui.i18nFormat("label.cpm.mcScale", new Object[0])).setBounds(new Box(5, 0, 0, 0)));
        ModeDisplayType[] spinnerS = new Spinner(gui);
        spinnerS.setBounds(new Box(5, 10, 70, 18));
        editor.setMCScale.add(arg_0 -> PosPanel.lambda$new$8((Spinner)spinnerS, arg_0));
        spinnerS.addChangeListener(() -> PosPanel.lambda$new$9(editor, (Spinner)spinnerS));
        spinnerS.setDp(3);
        panel2.addElement(spinnerS);
        this.tabHandler.add((TabFocusHandler.Focusable)spinnerS);
        Checkbox box = new Checkbox(gui, gui.i18nFormat("label.cpm.mirror", new Object[0]));
        box.setBounds(new Box(80, 10, 70, 18));
        box.setAction(() -> editor.switchEffect(Effect.MIRROR));
        editor.setMirror.add(box::updateState);
        panel2.addElement(box);
        ElementGroup<ModeDisplayType, GuiElement> group = new ElementGroup<ModeDisplayType, GuiElement>(GuiElement::setVisible);
        editor.setModePanel.add(group);
        editor.setModePanel.add(layout);
        for (ModeDisplayType mdt : ModeDisplayType.VALUES) {
            Panel p = mdt.factory.apply(e, editor, this.tabHandler);
            this.addElement(p);
            group.addElement(mdt, p);
        }
        String skinLbl = gui.i18nFormat("label.cpm.skin", new Object[0]);
        Label lblS = new Label(gui, skinLbl);
        lblS.setBounds(new Box(5, 0, 40, 5));
        this.addElement(lblS);
        editor.setSkinEdited.add(b -> {
            if (b.booleanValue()) {
                lblS.setText(skinLbl + "*");
            } else {
                lblS.setText(skinLbl);
            }
        });
        TextureDisplay skinDisp = new TextureDisplay(gui, editor);
        skinDisp.setBounds(new Box(5, 0, 160, 160));
        this.addElement(skinDisp);
        panel2 = new Panel(gui);
        this.addElement(panel2);
        panel2.setBounds(new Box(0, 0, 170, 20));
        Button openSkinBtn = new Button(gui, gui.i18nFormat("button.cpm.skinSettings", new Object[0]), () -> SkinSettingsPopup.showPopup(e));
        openSkinBtn.setBounds(new Box(5, 0, 90, 20));
        panel2.addElement(openSkinBtn);
        Button refreshSkinBtn = new Button(gui, gui.i18nFormat("button.cpm.reloadSkin", new Object[0]), editor::reloadSkin);
        refreshSkinBtn.setBounds(new Box(100, 0, 65, 20));
        panel2.addElement(refreshSkinBtn);
        editor.setReload.add(f -> {
            refreshSkinBtn.setEnabled(f != null);
            refreshSkinBtn.setTooltip(new Tooltip(e, f != null ? gui.i18nFormat("tooltip.cpm.reloadSkin.file", f) : gui.i18nFormat("tooltip.cpm.reloadSkin.no_file", new Object[0])));
        });
        layout.reflow();
        this.addElement(this.tabHandler);
    }

    public static Panel addVec3(String name, Consumer<Vec3f> consumer, Panel panelIn, UpdaterRegistry.Updater<Vec3f> updater, int dp, TabFocusHandler tabHandler) {
        IGui gui = panelIn.getGui();
        final Spinner spinnerX = new Spinner(gui);
        final Spinner spinnerY = new Spinner(gui);
        final Spinner spinnerZ = new Spinner(gui);
        spinnerX.setBounds(new Box(5, 10, 50, 18));
        spinnerY.setBounds(new Box(60, 10, 50, 18));
        spinnerZ.setBounds(new Box(115, 10, 50, 18));
        spinnerX.setDp(dp);
        spinnerY.setDp(dp);
        spinnerZ.setDp(dp);
        Runnable r = () -> consumer.accept(new Vec3f(spinnerX.getValue(), spinnerY.getValue(), spinnerZ.getValue()));
        spinnerX.addChangeListener(r);
        spinnerY.addChangeListener(r);
        spinnerZ.addChangeListener(r);
        Panel panel = new Panel(gui){

            @Override
            public void setVisible(boolean visible) {
                super.setVisible(visible);
                spinnerX.setVisible(visible);
                spinnerY.setVisible(visible);
                spinnerZ.setVisible(visible);
            }
        };
        panel.setBounds(new Box(0, 0, 170, 30));
        panelIn.addElement(panel);
        panel.addElement(new Label(gui, gui.i18nFormat("label.cpm." + name, new Object[0])).setBounds(new Box(5, 0, 0, 0)));
        panel.addElement(spinnerX);
        panel.addElement(spinnerY);
        panel.addElement(spinnerZ);
        tabHandler.add(spinnerX);
        tabHandler.add(spinnerY);
        tabHandler.add(spinnerZ);
        spinnerX.setBackgroundColor(-30584);
        spinnerY.setBackgroundColor(-7798904);
        spinnerZ.setBackgroundColor(-7829249);
        updater.add(v -> {
            boolean en = v != null;
            spinnerX.setEnabled(en);
            spinnerY.setEnabled(en);
            spinnerZ.setEnabled(en);
            if (en) {
                spinnerX.setValue(v.x);
                spinnerY.setValue(v.y);
                spinnerZ.setValue(v.z);
            } else {
                spinnerX.setValue(0.0f);
                spinnerY.setValue(0.0f);
                spinnerZ.setValue(0.0f);
            }
        });
        return panel;
    }

    private static /* synthetic */ void lambda$new$9(Editor editor, Spinner spinnerS) {
        editor.setMcScale(spinnerS.getValue());
    }

    private static /* synthetic */ void lambda$new$8(Spinner spinnerS, Float f) {
        spinnerS.setEnabled(f != null);
        if (f != null) {
            spinnerS.setValue(f.floatValue());
        } else {
            spinnerS.setValue(0.0f);
        }
    }
}

