/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.editor.gui;

import com.tom.cpl.gui.Frame;
import com.tom.cpl.gui.IGui;
import com.tom.cpl.gui.UpdaterRegistry;
import com.tom.cpl.gui.elements.Label;
import com.tom.cpl.gui.elements.Panel;
import com.tom.cpl.gui.util.FlowLayout;
import com.tom.cpl.gui.util.TabFocusHandler;
import com.tom.cpl.math.Box;
import com.tom.cpl.math.Vec3f;
import com.tom.cpm.shared.MinecraftClientAccess;
import com.tom.cpm.shared.config.Player;
import com.tom.cpm.shared.definition.ModelDefinition;
import com.tom.cpm.shared.editor.Editor;
import com.tom.cpm.shared.editor.gui.EditorGui;
import com.tom.cpm.shared.editor.gui.PosPanel;
import com.tom.cpm.shared.model.PartPosition;
import java.util.function.BiConsumer;
import java.util.function.Function;

public class FirstPersonHandPosGui
extends Frame {
    private Editor e;
    private ModelDefinition tempDef;

    public FirstPersonHandPosGui(IGui gui) {
        super(gui);
    }

    @Override
    public void initFrame(int width, int height) {
        this.e = EditorGui.getActiveTestingEditor();
        if (this.e == null) {
            String str = "How did you get here?";
            Label lbl = new Label(this.gui, str);
            lbl.setBounds(new Box(width / 2 - this.gui.textWidth(str) / 2, height / 2 - 4, 0, 0));
            this.addElement(lbl);
            return;
        }
        Player<?> pl = MinecraftClientAccess.get().getCurrentClientPlayer();
        if (pl == null || pl.getModelDefinition() == null) {
            String str = "How did you get here?";
            Label lbl = new Label(this.gui, str);
            lbl.setBounds(new Box(width / 2 - this.gui.textWidth(str) / 2, height / 2 - 4, 0, 0));
            this.addElement(lbl);
            return;
        }
        this.tempDef = pl.getModelDefinition();
        if (this.tempDef.fpLeftHand == null) {
            this.tempDef.fpLeftHand = new PartPosition();
        }
        if (this.tempDef.fpRightHand == null) {
            this.tempDef.fpRightHand = new PartPosition();
        }
        this.makeSettings(width, height, 0, this.e.leftHandPos, this.tempDef.fpLeftHand, 0);
        this.makeSettings(width, height, 1, this.e.rightHandPos, this.tempDef.fpRightHand, 170);
    }

    private void makeSettings(int width, int height, int name, PartPosition pp, PartPosition pp2, int x) {
        Panel p = new Panel(this.gui);
        p.setBounds(new Box(width / 2 - 170 + x, height / 2 - 50, 170, 100));
        this.addElement(p);
        p.addElement(new Label(this.gui, this.gui.i18nFormat("label.cpm.firstPersonHand.offset_" + name, new Object[0])).setBounds(new Box(0, 0, 100, 10)));
        TabFocusHandler tabHandler = new TabFocusHandler(this.gui);
        FlowLayout layout = new FlowLayout(p, 4, 1);
        this.addPart("rotation", p, tabHandler, 1, pp, pp2, PartPosition::getRRotation, PartPosition::setRRotation);
        this.addPart("position", p, tabHandler, 2, pp, pp2, PartPosition::getRPos, PartPosition::setRPos);
        this.addPart("scale", p, tabHandler, 2, pp, pp2, PartPosition::getRScale, PartPosition::setRScale);
        this.addElement(tabHandler);
        layout.reflow();
    }

    private void addPart(String name, Panel panel, TabFocusHandler tabHandler, int dp, PartPosition pp, PartPosition pp2, Function<PartPosition, Vec3f> getter, BiConsumer<PartPosition, Vec3f> setter) {
        PosPanel.addVec3(name, v -> this.e.action("set", "label.cpm." + name).updateValueOp(pp, (Vec3f)getter.apply(pp), v, (a, p) -> {
            setter.accept(pp, (Vec3f)p);
            setter.accept(pp2, (Vec3f)p);
        }).execute(), panel, UpdaterRegistry.makeStatic(() -> (Vec3f)getter.apply(pp)), dp, tabHandler);
    }
}

