/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.editor.gui;

import com.tom.cpl.gui.IGui;
import com.tom.cpl.gui.elements.GuiElement;
import com.tom.cpl.gui.elements.Panel;
import com.tom.cpl.math.Box;
import com.tom.cpl.util.MarkdownParser;
import com.tom.cpl.util.MarkdownRenderer;
import com.tom.cpm.externals.org.apache.maven.artifact.versioning.ComparableVersion;
import com.tom.cpm.shared.MinecraftCommonAccess;
import com.tom.cpm.shared.util.MdResourceLoader;
import com.tom.cpm.shared.util.VersionCheck;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public class ChangelogPanel
extends Panel {
    private MarkdownRenderer mdr;

    public ChangelogPanel(IGui gui, String version) {
        super(gui);
        String ch = "# " + gui.i18nFormat("label.cpm.changelog.title", new Object[0]) + "\n\n" + gui.i18nFormat("label.cpm.loading", new Object[0]);
        this.mdr = new MarkdownRenderer(gui, (MarkdownRenderer.MarkdownResourceLoader)new MdResourceLoader(gui::openURL, null, true), ch);
        this.addElement(this.mdr);
        VersionCheck vc = VersionCheck.get();
        ((CompletableFuture)vc.getFinished().thenRunAsync(() -> {
            Map<ComparableVersion, String> allChanges;
            StringBuilder sb = new StringBuilder("# ");
            if (version != null) {
                ComparableVersion ver = new ComparableVersion(version);
                allChanges = new LinkedHashMap<ComparableVersion, String>();
                for (Map.Entry<ComparableVersion, String> e2 : vc.getAllChanges().entrySet()) {
                    if (e2.getKey().compareTo(ver) <= 0) continue;
                    allChanges.put(e2.getKey(), e2.getValue());
                }
                sb.append(gui.i18nFormat("label.cpm.changelog.changesSince", version));
                sb.append("\n\n");
            } else {
                allChanges = vc.getAllChanges();
                sb.append(gui.i18nFormat("label.cpm.changelog.title", new Object[0]));
                sb.append("\n\n");
            }
            ComparableVersion c = new ComparableVersion(MinecraftCommonAccess.get().getModVersion());
            allChanges.entrySet().stream().sorted(Collections.reverseOrder(Comparator.comparing(Map.Entry::getKey))).forEach(e -> {
                sb.append("## ");
                if (c.equals(e.getKey())) {
                    sb.append(gui.i18nFormat("label.cpm.changelog.currentVersion", ((ComparableVersion)e.getKey()).toString()));
                } else {
                    sb.append(e.getKey());
                }
                sb.append('\n');
                String chlnk = ((String)e.getValue()).replaceAll("#(\\d+)", "[#$1](https://github.com/tom5454/CustomPlayerModels/issues/$1)");
                String chmd = chlnk.replaceAll("- (.+)\n([^-])", "- $1\n\n$2").replace("\n", "  \n");
                sb.append(chmd);
                sb.append("\n\n");
            });
            this.mdr.setContent(new MarkdownParser(sb.toString()));
        }, gui::executeLater)).handleAsync((__, e) -> {
            if (e != null) {
                this.mdr.setContent(MarkdownParser.makeErrorPage(gui, e));
            }
            return null;
        }, gui::executeLater);
    }

    @Override
    public GuiElement setBounds(Box bounds) {
        this.mdr.setBounds(new Box(0, 0, bounds.w, bounds.h));
        return super.setBounds(bounds);
    }
}

