/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.editor.gui;

import com.tom.cpl.gui.IGui;
import com.tom.cpl.gui.MouseEvent;
import com.tom.cpl.gui.elements.ButtonIcon;
import com.tom.cpl.gui.elements.Checkbox;
import com.tom.cpl.gui.elements.DropDownBox;
import com.tom.cpl.gui.elements.Label;
import com.tom.cpl.gui.elements.Panel;
import com.tom.cpl.gui.elements.PopupMenu;
import com.tom.cpl.gui.elements.Slider;
import com.tom.cpl.gui.util.FlowLayout;
import com.tom.cpl.math.Box;
import com.tom.cpl.math.Vec2i;
import com.tom.cpl.util.ItemSlot;
import com.tom.cpl.util.NamedElement;
import com.tom.cpm.shared.MinecraftClientAccess;
import com.tom.cpm.shared.animation.CustomPose;
import com.tom.cpm.shared.animation.IPose;
import com.tom.cpm.shared.animation.VanillaPose;
import com.tom.cpm.shared.editor.Editor;
import com.tom.cpm.shared.editor.anim.AnimationDisplayData;
import com.tom.cpm.shared.editor.anim.EditorAnim;
import com.tom.cpm.shared.editor.gui.EditorGui;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;

public class AnimTestPanel
extends Panel {
    private Editor editor;
    private DropDownPanel<IPose> poseSel;
    private DropDownPanel<String> gestureSel;
    private DropDownPanel<VanillaPose> mainPose;
    private Slider progressSlider;
    private DropDownPanel<VanillaPose> otherHandLeft;
    private DropDownPanel<VanillaPose> otherHandRight;
    private List<DropDownPanel<VanillaPose>> poseBoxes;
    private Checkbox chbxLeftParrot;
    private Checkbox chbxRightParrot;
    private PopupMenu customLayers;
    private Set<String> enabledLayers = new HashSet<String>();

    public AnimTestPanel(IGui gui, EditorGui e) {
        super(gui);
        this.editor = e.getEditor();
        this.setBounds(new Box(0, 0, 170, 80));
        this.setBackgroundColor(gui.getColors().panel_background);
        FlowLayout layout = new FlowLayout(this, 5, 1);
        ArrayList poses = new ArrayList();
        poses.add(new NamedElement<IPose>(VanillaPose.STANDING, this::poseToString));
        ArrayList gestures = new ArrayList();
        gestures.add(new NamedElement<String>(null, k -> gui.i18nFormat("label.cpm.no_gesture", new Object[0])));
        this.editor.updateGui.add(() -> {
            poses.clear();
            gestures.clear();
            this.customLayers = new PopupMenu(gui, e);
            gestures.add(new NamedElement<String>(null, k -> gui.i18nFormat("label.cpm.no_gesture", new Object[0])));
            for (VanillaPose p : VanillaPose.VALUES) {
                if (p == VanillaPose.CUSTOM || p == VanillaPose.GLOBAL) continue;
                AnimationDisplayData d = AnimationDisplayData.getFor(p);
                if (d.type != AnimationDisplayData.Type.POSE && d.type != AnimationDisplayData.Type.POSE_SERVER) continue;
                poses.add(new NamedElement<IPose>(p, this::poseToString));
            }
            HashSet addedGestures = new HashSet();
            HashSet addedLayers = new HashSet();
            HashSet addedPoses = new HashSet();
            this.editor.animations.forEach(a -> {
                if (a.isCustom()) {
                    if (a.pose != null) {
                        String name = ((CustomPose)a.pose).getId();
                        if (!addedPoses.contains(name)) {
                            addedPoses.add(name);
                            poses.add(new NamedElement<IPose>(a.pose, k -> name));
                        }
                    } else if (a.isLayer()) {
                        String id = a.getId();
                        String name = a.getDisplayGroup();
                        if (!addedLayers.contains(id)) {
                            addedLayers.add(id);
                            if (a.displayName.startsWith("$value$")) {
                                Slider progressSlider = new Slider(gui, name + ": 0");
                                progressSlider.setBounds(new Box(0, 0, 160, 20));
                                progressSlider.setValue(this.editor.animTestSliders.getOrDefault(id, Float.valueOf(0.0f)).floatValue());
                                progressSlider.setAction(() -> {
                                    progressSlider.setText(name + ": " + (int)(progressSlider.getValue() * 100.0f));
                                    this.editor.animTestSliders.put(id, Float.valueOf(progressSlider.getValue()));
                                });
                                this.customLayers.add(progressSlider);
                            } else {
                                this.customLayers.addCheckbox(name, b -> {
                                    if (this.enabledLayers.contains(id)) {
                                        this.enabledLayers.remove(id);
                                    } else {
                                        this.enabledLayers.add(id);
                                    }
                                    b.setSelected(this.enabledLayers.contains(id));
                                }).setSelected(this.enabledLayers.contains(id));
                            }
                        }
                    } else {
                        String id = a.getId();
                        String name = a.getDisplayGroup();
                        if (!addedGestures.contains(id)) {
                            addedGestures.add(id);
                            gestures.add(new NamedElement<String>(id, k -> name));
                        }
                    }
                }
            });
            if (addedLayers.isEmpty()) {
                this.customLayers.add(new Label(gui, gui.i18nFormat("label.cpm.no_elements", new Object[0])).setBounds(new Box(5, 5, 0, 0)));
            }
        });
        this.poseSel = this.createDropDown("label.cpm.pose", poses);
        this.gestureSel = this.createDropDown("label.cpm.gesture", gestures);
        this.gestureSel.dropDown.setAction(() -> {
            this.editor.gestureStartTime = MinecraftClientAccess.get().getPlayerRenderManager().getAnimationEngine().getTime();
        });
        TreeMap<AnimationDisplayData.Slot, List> slots = new TreeMap<AnimationDisplayData.Slot, List>();
        for (VanillaPose p : VanillaPose.VALUES) {
            AnimationDisplayData animationDisplayData = AnimationDisplayData.getFor(p);
            if (animationDisplayData == null || animationDisplayData.layerSlot == null) continue;
            slots.computeIfAbsent(animationDisplayData.layerSlot, __ -> {
                ArrayList<NamedElement<VanillaPose>> l = new ArrayList<NamedElement<VanillaPose>>();
                l.add(new NamedElement<VanillaPose>(null, ___ -> gui.i18nFormat("label.cpm.no_elements", new Object[0])));
                return l;
            }).add(new NamedElement<VanillaPose>(p, this::poseToString));
        }
        this.poseBoxes = new ArrayList<DropDownPanel<VanillaPose>>();
        ArrayList handItems = new ArrayList();
        handItems.addAll((Collection)slots.get((Object)AnimationDisplayData.Slot.LEFT_HAND));
        ((List)slots.get((Object)AnimationDisplayData.Slot.RIGHT_HAND)).stream().filter(i -> i.getElem() != null).forEach(handItems::add);
        handItems.add(new NamedElement<VanillaPose>(VanillaPose.PUNCH_LEFT, this::poseToString));
        handItems.add(new NamedElement<VanillaPose>(VanillaPose.PUNCH_RIGHT, this::poseToString));
        handItems.add(new NamedElement<VanillaPose>(VanillaPose.SPEAKING, this::poseToString));
        handItems.sort(Comparator.comparing(NamedElement::toString));
        this.mainPose = this.createDropDown("label.cpm.animSlot.heldItem", handItems);
        this.mainPose.dropDown.setAction(() -> {
            VanillaPose p = this.mainPose.getSelected().getElem();
            AnimationDisplayData d = AnimationDisplayData.getFor(p);
            this.progressSlider.setVisible(p != null && p.hasStateGetter());
            this.otherHandLeft.setVisible(d != null && (d.item == null || !d.item.pose.isTwoHanded()) && d.slot == ItemSlot.RIGHT_HAND);
            this.otherHandRight.setVisible(d != null && (d.item == null || !d.item.pose.isTwoHanded()) && d.slot == ItemSlot.LEFT_HAND);
            layout.reflow();
        });
        this.poseBoxes.add(this.mainPose);
        this.progressSlider = new Slider(gui, gui.i18nFormat("label.cpm.animProgress", 0));
        this.progressSlider.setVisible(false);
        this.progressSlider.setBounds(new Box(5, 0, 160, 20));
        this.progressSlider.setValue(this.editor.animTestSliders.getOrDefault("__pose", Float.valueOf(0.0f)).floatValue());
        this.progressSlider.setAction(() -> {
            this.progressSlider.setText(gui.i18nFormat("label.cpm.animProgress", (int)(this.progressSlider.getValue() * 100.0f)));
            this.editor.animTestSliders.put("__pose", Float.valueOf(this.progressSlider.getValue()));
        });
        this.addElement(this.progressSlider);
        List handItemsOtherLeft = ((List)slots.get((Object)AnimationDisplayData.Slot.LEFT_HAND)).stream().filter(i -> i.getElem() != null && !AnimationDisplayData.getFor((VanillaPose)((VanillaPose)i.getElem())).item.pose.isTwoHanded()).collect(Collectors.toList());
        handItemsOtherLeft.add(0, new NamedElement<VanillaPose>(null, ___ -> gui.i18nFormat("label.cpm.no_elements", new Object[0])));
        List handItemsOtherRight = ((List)slots.get((Object)AnimationDisplayData.Slot.RIGHT_HAND)).stream().filter(i -> i.getElem() != null && !AnimationDisplayData.getFor((VanillaPose)((VanillaPose)i.getElem())).item.pose.isTwoHanded()).collect(Collectors.toList());
        handItemsOtherRight.add(0, new NamedElement<VanillaPose>(null, ___ -> gui.i18nFormat("label.cpm.no_elements", new Object[0])));
        this.otherHandLeft = this.createDropDown("label.cpm.animSlot.left_hand", handItemsOtherLeft);
        this.otherHandLeft.setVisible(false);
        this.poseBoxes.add(this.otherHandLeft);
        this.otherHandRight = this.createDropDown("label.cpm.animSlot.right_hand", handItemsOtherRight);
        this.otherHandRight.setVisible(false);
        this.poseBoxes.add(this.otherHandRight);
        slots.remove((Object)AnimationDisplayData.Slot.LEFT_HAND);
        slots.remove((Object)AnimationDisplayData.Slot.RIGHT_HAND);
        slots.remove((Object)AnimationDisplayData.Slot.PARROTS);
        for (Map.Entry entry : slots.entrySet()) {
            AnimationDisplayData.Slot key = (AnimationDisplayData.Slot)((Object)entry.getKey());
            List val = (List)entry.getValue();
            DropDownPanel dropDown = this.createDropDown("label.cpm.animSlot." + key.name().toLowerCase(), val);
            this.poseBoxes.add(dropDown);
        }
        ArrayList val = new ArrayList();
        val.add(new NamedElement<VanillaPose>(null, k -> gui.i18nFormat("label.cpm.animSlot.noEffect", new Object[0])));
        for (VanillaPose p : VanillaPose.VALUES) {
            AnimationDisplayData d = AnimationDisplayData.getFor(p);
            if (d == null || d.layerSlot != null || d.type != AnimationDisplayData.Type.LAYERS || p.hasStateGetter()) continue;
            val.add(new NamedElement<VanillaPose>(p, this::poseToString));
        }
        DropDownPanel dropDownPanel = this.createDropDown("label.cpm.animSlot.effects", val);
        this.poseBoxes.add(dropDownPanel);
        this.chbxLeftParrot = new Checkbox(gui, gui.i18nFormat("label.cpm.animSlot.leftParrot", new Object[0]));
        this.chbxLeftParrot.setBounds(new Box(5, 0, 160, 20));
        this.chbxLeftParrot.setAction(() -> this.chbxLeftParrot.setSelected(!this.chbxLeftParrot.isSelected()));
        this.addElement(this.chbxLeftParrot);
        this.chbxRightParrot = new Checkbox(gui, gui.i18nFormat("label.cpm.animSlot.rightParrot", new Object[0]));
        this.chbxRightParrot.setBounds(new Box(5, 0, 160, 20));
        this.chbxRightParrot.setAction(() -> this.chbxRightParrot.setSelected(!this.chbxRightParrot.isSelected()));
        this.addElement(this.chbxRightParrot);
        Panel layersPanel = new Panel(gui);
        layersPanel.setBounds(new Box(5, 0, 160, 20));
        layersPanel.addElement(new Label(gui, gui.i18nFormat("label.cpm.customLayers", new Object[0])).setBounds(new Box(0, 6, 0, 0)));
        ButtonIcon layersDropDown = new ButtonIcon(gui, "editor", 24, 8, null){

            @Override
            public void mouseClick(MouseEvent evt) {
                if (evt.isHovered(this.bounds)) {
                    Vec2i p = evt.getPos();
                    AnimTestPanel.this.customLayers.display(p.x - evt.x, p.y - evt.y + this.bounds.h + this.bounds.y, 160);
                    evt.consume();
                }
            }
        };
        layersDropDown.setBounds(new Box(140, 4, 12, 12));
        layersPanel.addElement(layersDropDown);
        this.addElement(layersPanel);
        layout.reflow();
        this.editor.gestureFinished.add(() -> this.gestureSel.dropDown.setSelected(null));
    }

    private <T> DropDownPanel<T> createDropDown(String name, List<NamedElement<T>> val) {
        DropDownPanel<T> panel = new DropDownPanel<T>(name, val);
        this.addElement(panel);
        return panel;
    }

    private String poseToString(IPose p) {
        return p.getName(this.gui, null);
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.editor.playStartTime = MinecraftClientAccess.get().getPlayerRenderManager().getAnimationEngine().getTime();
            this.editor.playFullAnim = true;
            this.editor.selectedAnim = null;
        }
    }

    @Override
    public void draw(MouseEvent event, float partialTicks) {
        NamedElement<String> gesture;
        super.draw(event, partialTicks);
        this.editor.animsToPlay.clear();
        NamedElement<IPose> pose = this.poseSel.getSelected();
        if (pose != null) {
            this.editor.poseToApply = pose.getElem();
            for (EditorAnim anim : this.editor.animations) {
                if (anim.pose != null && (anim.pose == pose.getElem() || pose.getElem() instanceof CustomPose && anim.pose instanceof CustomPose && ((CustomPose)pose.getElem()).getId().equals(((CustomPose)anim.pose).getId()))) {
                    this.editor.animsToPlay.add(anim);
                    continue;
                }
                if (anim.pose != VanillaPose.GLOBAL) continue;
                this.editor.animsToPlay.add(anim);
            }
        }
        if ((gesture = this.gestureSel.getSelected()) != null && gesture.getElem() != null) {
            for (EditorAnim anim : this.editor.animations) {
                if (!anim.isCustom() || anim.pose != null || anim.isLayer() || !anim.getId().equals(gesture.getElem())) continue;
                this.editor.animsToPlay.add(anim);
            }
        }
        this.editor.testPoses.clear();
        this.poseBoxes.forEach(ddb -> {
            if (!ddb.isVisible()) {
                return;
            }
            VanillaPose p = (VanillaPose)ddb.getSelected().getElem();
            if (p != null) {
                this.handlePose(p);
            }
        });
        if (this.chbxLeftParrot.isSelected()) {
            this.handlePose(VanillaPose.PARROT_LEFT);
        }
        if (this.chbxRightParrot.isSelected()) {
            this.handlePose(VanillaPose.PARROT_RIGHT);
        }
        this.enabledLayers.forEach(l -> {
            for (EditorAnim anim : this.editor.animations) {
                if (!anim.isCustom() || anim.pose != null || !anim.isLayer() || !anim.getId().equals(l)) continue;
                this.editor.animsToPlay.add(anim);
            }
        });
        for (EditorAnim anim : this.editor.animations) {
            if (!anim.isCustom() || anim.pose != null || !anim.isLayer() || !anim.displayName.startsWith("$value$")) continue;
            this.editor.animsToPlay.add(anim);
        }
    }

    private void handlePose(VanillaPose p) {
        this.editor.testPoses.add(p);
        for (EditorAnim anim : this.editor.animations) {
            if (anim.pose != p) continue;
            this.editor.animsToPlay.add(anim);
        }
    }

    private class DropDownPanel<T>
    extends Panel {
        private DropDownBox<NamedElement<T>> dropDown;

        public DropDownPanel(String name, List<NamedElement<T>> val) {
            super(AnimTestPanel.this.getGui());
            this.setBounds(new Box(0, 0, 170, 30));
            this.addElement(new Label(this.gui, this.gui.i18nFormat(name, new Object[0])).setBounds(new Box(5, 2, 160, 10)));
            this.dropDown = new DropDownBox<NamedElement<NamedElement<T>>>(AnimTestPanel.this.editor.frame, val);
            this.dropDown.setBounds(new Box(5, 10, 160, 20));
            this.addElement(this.dropDown);
        }

        public NamedElement<T> getSelected() {
            return this.dropDown.getSelected();
        }
    }
}

