/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.editor.gui;

import com.tom.cpl.gui.IGui;
import com.tom.cpl.gui.MouseEvent;
import com.tom.cpl.gui.elements.Button;
import com.tom.cpl.gui.elements.ButtonIcon;
import com.tom.cpl.gui.elements.Checkbox;
import com.tom.cpl.gui.elements.ConfirmPopup;
import com.tom.cpl.gui.elements.Label;
import com.tom.cpl.gui.elements.ListPicker;
import com.tom.cpl.gui.elements.Panel;
import com.tom.cpl.gui.elements.Spinner;
import com.tom.cpl.gui.elements.Tooltip;
import com.tom.cpl.gui.util.FlowLayout;
import com.tom.cpl.gui.util.TabFocusHandler;
import com.tom.cpl.math.Box;
import com.tom.cpl.math.Vec3f;
import com.tom.cpl.util.CombinedListView;
import com.tom.cpl.util.ListView;
import com.tom.cpm.shared.MinecraftClientAccess;
import com.tom.cpm.shared.animation.CustomPose;
import com.tom.cpm.shared.animation.IPose;
import com.tom.cpm.shared.animation.VanillaPose;
import com.tom.cpm.shared.editor.Editor;
import com.tom.cpm.shared.editor.anim.EditorAnim;
import com.tom.cpm.shared.editor.gui.EditorGui;
import com.tom.cpm.shared.editor.gui.PosPanel;
import com.tom.cpm.shared.editor.gui.popup.AnimEncConfigPopup;
import com.tom.cpm.shared.editor.gui.popup.AnimationSettinsPopup;
import com.tom.cpm.shared.editor.gui.popup.ColorButton;
import java.util.Collections;
import java.util.Comparator;

public class AnimPanel
extends Panel {
    private Editor editor;
    private ListPicker<IAnim> animSel;
    private TabFocusHandler tabHandler;
    private Button prevFrm;
    private Button nextFrm;
    private Button clearAnimData;

    public AnimPanel(final IGui gui, EditorGui e) {
        super(gui);
        this.tabHandler = new TabFocusHandler(gui);
        this.editor = e.getEditor();
        this.setBounds(new Box(0, 0, 170, 330));
        this.setBackgroundColor(gui.getColors().panel_background);
        FlowLayout layout = new FlowLayout(this, 4, 1);
        this.animSel = new ListPicker(e, new CombinedListView(Collections.singletonList(new IAnim(){

            public String toString() {
                return gui.i18nFormat("label.cpm.no_animation", new Object[0]);
            }

            @Override
            public String noAnim() {
                return "";
            }
        }), new ListView<EditorAnim, IAnim>(this.editor.animations, v -> v)));
        this.animSel.setBounds(new Box(5, 5, 160, 20));
        this.animSel.setListLoader(l -> l.setComparator(Comparator.comparing(IAnim::noAnim, Comparator.nullsLast(Comparator.naturalOrder())).thenComparing(Comparator.comparing(IAnim::getPose0, Comparator.nullsLast(Comparator.naturalOrder()))).thenComparing(Comparator.comparing(IAnim::getPose1, Comparator.nullsLast(Comparator.naturalOrder()))).thenComparing(Comparator.comparing(Object::toString))));
        this.addElement(this.animSel);
        this.animSel.setAction(() -> {
            IAnim sel = this.animSel.getSelected();
            this.editor.selectedAnim = sel instanceof EditorAnim ? (EditorAnim)sel : null;
            this.editor.updateGui();
        });
        this.editor.setSelAnim.add(this.animSel::setSelected);
        Panel p = new Panel(gui);
        p.setBounds(new Box(0, 0, this.bounds.w, 18));
        this.addElement(p);
        ButtonIcon newAnimBtn = new ButtonIcon(gui, "editor", 0, 16, () -> e.openPopup(new AnimationSettinsPopup(gui, this.editor, false)));
        newAnimBtn.setBounds(new Box(5, 0, 18, 18));
        p.addElement(newAnimBtn);
        ButtonIcon delAnimBtn = new ButtonIcon(gui, "editor", 14, 16, ConfirmPopup.confirmHandler(e, gui.i18nFormat("label.cpm.confirmDel", new Object[0]), this.editor::delSelectedAnim));
        delAnimBtn.setBounds(new Box(25, 0, 18, 18));
        p.addElement(delAnimBtn);
        this.editor.setAnimDelEn.add(delAnimBtn::setEnabled);
        Button editBtn = new Button(gui, gui.i18nFormat("button.cpm.edit", new Object[0]), () -> e.openPopup(new AnimationSettinsPopup(gui, this.editor, true)));
        editBtn.setBounds(new Box(45, 0, 80, 18));
        p.addElement(editBtn);
        this.editor.setAnimDelEn.add(editBtn::setEnabled);
        p = new Panel(gui);
        p.setBounds(new Box(0, 0, this.bounds.w, 18));
        this.addElement(p);
        Label currFrame = new Label(gui, "");
        currFrame.setBounds(new Box(30, 5, 110, 10));
        p.addElement(currFrame);
        this.prevFrm = new Button(gui, "<", () -> {
            if (gui.isCtrlDown()) {
                this.editor.animMoveFrame(-1);
            } else {
                this.editor.animPrevFrm();
            }
        });
        this.prevFrm.setBounds(new Box(5, 0, 18, 18));
        p.addElement(this.prevFrm);
        this.nextFrm = new Button(gui, ">", () -> {
            if (gui.isCtrlDown()) {
                this.editor.animMoveFrame(1);
            } else {
                this.editor.animNextFrm();
            }
        });
        this.nextFrm.setBounds(new Box(145, 0, 18, 18));
        p.addElement(this.nextFrm);
        this.editor.setAnimFrame.add(i -> {
            this.prevFrm.setEnabled(i != null);
            this.nextFrm.setEnabled(i != null);
            if (i != null) {
                currFrame.setText(gui.i18nFormat("label.cpm.anim_frame_x", i));
            } else {
                currFrame.setText(gui.i18nFormat("label.cpm.anim_frame_none", new Object[0]));
            }
        });
        p = new Panel(gui);
        p.setBounds(new Box(0, 0, this.bounds.w, 18));
        this.addElement(p);
        ButtonIcon newFrmBtn = new ButtonIcon(gui, "editor", 0, 16, this.editor::addNewAnimFrame);
        newFrmBtn.setBounds(new Box(5, 0, 18, 18));
        p.addElement(newFrmBtn);
        this.editor.setFrameAddEn.add(newFrmBtn::setEnabled);
        ButtonIcon delFrmBtn = new ButtonIcon(gui, "editor", 14, 16, ConfirmPopup.confirmHandler(e, gui.i18nFormat("label.cpm.confirmDel", new Object[0]), this.editor::delSelectedAnimFrame));
        delFrmBtn.setBounds(new Box(25, 0, 18, 18));
        p.addElement(delFrmBtn);
        this.editor.setFrameDelEn.add(delFrmBtn::setEnabled);
        ButtonIcon playBtn = new ButtonIcon(gui, "editor", 56, 16, true, () -> {
            this.editor.playFullAnim = !this.editor.playFullAnim;
            this.editor.playStartTime = MinecraftClientAccess.get().getPlayerRenderManager().getAnimationEngine().getTime();
            this.editor.setAnimPlay.accept(this.editor.playFullAnim);
        });
        playBtn.setBounds(new Box(45, 0, 18, 18));
        p.addElement(playBtn);
        this.editor.setAnimPlayEn.add(playBtn::setEnabled);
        this.editor.setAnimPlay.add(v -> playBtn.setU(v != false ? 72 : 56));
        p = new Panel(gui);
        p.setBounds(new Box(0, 0, this.bounds.w, 28));
        this.addElement(p);
        Label lblDuration = new Label(gui, gui.i18nFormat("label.cpm.duration", new Object[0]));
        lblDuration.setBounds(new Box(5, 0, 0, 0));
        p.addElement(lblDuration);
        Spinner duration = new Spinner(gui);
        duration.setDp(0);
        duration.setBounds(new Box(5, 10, 100, 18));
        p.addElement(duration);
        this.editor.setAnimDuration.add(i -> {
            duration.setEnabled(i != null);
            if (i != null) {
                duration.setValue(i.intValue());
            } else {
                duration.setValue(1000.0f);
            }
        });
        duration.addChangeListener(() -> this.editor.setAnimDuration((int)duration.getValue()));
        this.tabHandler.add(duration);
        this.clearAnimData = new Button(gui, gui.i18nFormat("button.cpm.clearAnimData", new Object[0]), () -> {
            boolean all = gui.isCtrlDown();
            ConfirmPopup.confirm(e, gui.i18nFormat("label.cpm.confirmDel", new Object[0]), () -> this.editor.delSelectedAnimPartData(all));
        });
        this.clearAnimData.setBounds(new Box(110, 10, 55, 18));
        this.clearAnimData.setTooltip(new Tooltip(e, gui.i18nFormat("tooltip.cpm.clearAnimData", new Object[0])));
        p.addElement(this.clearAnimData);
        PosPanel.addVec3("rotation", v -> this.editor.setAnimRot((Vec3f)v), this, this.editor.setAnimRot, 1, this.tabHandler);
        PosPanel.addVec3("position", v -> this.editor.setAnimPos((Vec3f)v), this, this.editor.setAnimPos, 2, this.tabHandler);
        Panel sc = PosPanel.addVec3("render_scale", v -> this.editor.setAnimScale((Vec3f)v), this, this.editor.setAnimScale, 2, this.tabHandler);
        this.editor.updateGui.add(() -> {
            sc.setVisible(this.editor.displayAdvScaling);
            this.clearAnimData.setEnabled(this.editor.getSelectedElement() != null && this.editor.selectedAnim != null && this.editor.selectedAnim.getSelectedFrame() != null);
            layout.reflow();
        });
        ColorButton colorBtn = new ColorButton(gui, e, this.editor::setAnimColor);
        colorBtn.setBounds(new Box(5, 0, 140, 20));
        this.editor.setAnimColor.add(c -> {
            colorBtn.setEnabled(c != null);
            if (c != null) {
                colorBtn.setColor((int)c);
            } else {
                colorBtn.setColor(0);
            }
        });
        this.addElement(colorBtn);
        Checkbox boxShow = new Checkbox(gui, gui.i18nFormat("label.cpm.visible", new Object[0]));
        boxShow.setBounds(new Box(5, 0, 60, 18));
        boxShow.setAction(this.editor::switchAnimShow);
        this.editor.setAnimShow.add(boxShow::updateState);
        this.addElement(boxShow);
        Button encSettings = new Button(gui, gui.i18nFormat("button.cpm.animEncSettings", new Object[0]), () -> e.openPopup(new AnimEncConfigPopup(gui, this.editor, null)));
        encSettings.setBounds(new Box(5, 0, 155, 20));
        this.addElement(encSettings);
        p = new Panel(gui);
        p.setBounds(new Box(0, 0, this.bounds.w, 28));
        this.addElement(p);
        Label lblPri = new Label(gui, gui.i18nFormat("label.cpm.anim_priority", new Object[0]));
        lblPri.setBounds(new Box(5, 0, 160, 10));
        lblPri.setTooltip(new Tooltip(e, gui.i18nFormat("tooltip.cpm.anim_priority", new Object[0])));
        p.addElement(lblPri);
        Spinner animPriority = new Spinner(gui);
        this.editor.setAnimPriority.add(v -> {
            animPriority.setEnabled(v != null);
            if (v != null) {
                animPriority.setValue(v.intValue());
            } else {
                animPriority.setValue(0.0f);
            }
        });
        animPriority.setBounds(new Box(5, 10, 100, 18));
        animPriority.setDp(0);
        animPriority.addChangeListener(() -> this.editor.setAnimPriority((int)animPriority.getValue()));
        p.addElement(animPriority);
        this.tabHandler.add(animPriority);
        layout.reflow();
        this.addElement(this.tabHandler);
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.editor.playFullAnim = false;
            IAnim sel = this.animSel.getSelected();
            this.editor.selectedAnim = sel instanceof EditorAnim ? (EditorAnim)sel : null;
            this.editor.setAnimPlay.accept(false);
            this.editor.updateGui();
        }
    }

    @Override
    public void draw(MouseEvent event, float partialTicks) {
        if (this.gui.isCtrlDown()) {
            this.prevFrm.setText("<<");
            this.nextFrm.setText(">>");
            this.clearAnimData.setText(this.gui.i18nFormat("button.cpm.clearAnimDataAll", new Object[0]));
        } else {
            this.prevFrm.setText("<");
            this.nextFrm.setText(">");
            this.clearAnimData.setText(this.gui.i18nFormat("button.cpm.clearAnimData", new Object[0]));
        }
        super.draw(event, partialTicks);
    }

    public static interface IAnim {
        default public IPose getPose() {
            return null;
        }

        default public VanillaPose getPose0() {
            IPose pose = this.getPose();
            if (pose == null || !(pose instanceof VanillaPose)) {
                return null;
            }
            return (VanillaPose)pose;
        }

        default public String getPose1() {
            IPose pose = this.getPose();
            if (pose == null || !(pose instanceof CustomPose)) {
                return null;
            }
            return ((CustomPose)pose).getName();
        }

        default public String noAnim() {
            return null;
        }
    }
}

