/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.editor;

import com.tom.cpl.math.MatrixStack;
import com.tom.cpl.math.TriangleBoundingBox;
import com.tom.cpl.math.Vec3f;
import com.tom.cpl.render.OptionalBuffer;
import com.tom.cpl.render.RenderTypes;
import com.tom.cpl.render.VBuffers;
import com.tom.cpl.render.VertexBuffer;
import com.tom.cpm.shared.config.ModConfig;
import com.tom.cpm.shared.definition.ModelDefinition;
import com.tom.cpm.shared.editor.ETextures;
import com.tom.cpm.shared.editor.Editor;
import com.tom.cpm.shared.editor.EditorRenderer;
import com.tom.cpm.shared.editor.ElementType;
import com.tom.cpm.shared.editor.ModelElement;
import com.tom.cpm.shared.editor.gui.ViewportPanel;
import com.tom.cpm.shared.model.Cube;
import com.tom.cpm.shared.model.PartRoot;
import com.tom.cpm.shared.model.RenderedCube;
import com.tom.cpm.shared.model.RootModelElement;
import com.tom.cpm.shared.model.ScaleData;
import com.tom.cpm.shared.model.SkinType;
import com.tom.cpm.shared.model.TextureSheetType;
import com.tom.cpm.shared.model.render.BoxRender;
import com.tom.cpm.shared.model.render.GuiModelRenderManager;
import com.tom.cpm.shared.model.render.Mesh;
import com.tom.cpm.shared.model.render.RenderMode;
import com.tom.cpm.shared.model.render.VanillaModelPart;
import com.tom.cpm.shared.skin.TextureProvider;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;

public class EditorDefinition
extends ModelDefinition {
    private Editor editor;
    public List<EditorRenderer.Bounds> bounds = new ArrayList<EditorRenderer.Bounds>();
    public ViewportPanel renderingPanel;

    public EditorDefinition(final Editor editor) {
        this.editor = editor;
        this.setScale(new ScaleData(new HashMap()){

            @Override
            public Vec3f getRPos() {
                return editor.scalingElem.pos;
            }

            @Override
            public Vec3f getRRotation() {
                return editor.scalingElem.rotation;
            }

            @Override
            public Vec3f getRScale() {
                return editor.scalingElem.scale;
            }
        });
    }

    @Override
    public PartRoot getModelElementFor(VanillaModelPart part) {
        PartRoot root = new PartRoot();
        this.editor.elements.forEach(e -> {
            RootModelElement el = (RootModelElement)e.rc;
            if (el.getPart() == part) {
                root.add(el);
                if (!e.duplicated) {
                    root.setMainRoot(el);
                }
            }
        });
        if (root.isEmpty()) {
            return null;
        }
        return root;
    }

    @Override
    public boolean isEditor() {
        return true;
    }

    @Override
    public TextureProvider getTexture(TextureSheetType key, boolean inGui) {
        ETextures tex = this.editor.textures.get((Object)key);
        return tex != null ? tex.getRenderTexture() : null;
    }

    @Override
    public void cleanup() {
        super.cleanup();
    }

    @Override
    public SkinType getSkinType() {
        return this.editor.skinType;
    }

    @Override
    public boolean hasRoot(VanillaModelPart type) {
        return this.editor.elements.stream().map(e -> ((RootModelElement)e.rc).getPart()).anyMatch(t -> t == type);
    }

    private void drawSelectionBox(GuiModelRenderManager.RedirectPartRenderer renderer, MatrixStack stack, VBuffers buf, RenderTypes<RenderMode> renderTypes, RenderedCube cube) {
        RenderedCube.ElementSelectMode sel = cube.getSelected();
        if (sel.isRenderOutline()) {
            boolean s;
            boolean bl = s = sel == RenderedCube.ElementSelectMode.SELECTED;
            if (s) {
                BoxRender.drawOrigin(stack, buf.getBuffer(renderTypes, RenderMode.OUTLINE), 0.0f, 0.0f, 0.0f, 1.0f);
            }
            Cube c = cube.getCube();
            if (c.size == null || c.size.x != 0.0f || c.size.y != 0.0f || c.size.z != 0.0f || c.mcScale != 0.0f) {
                BoxRender.drawBoundingBox(stack, buf.getBuffer(renderTypes, RenderMode.OUTLINE), cube.getBounds(), s ? 1.0f : 0.5f, s ? 1.0f : 0.5f, s ? 1.0f : 0.0f, 1.0f);
            }
        }
        if (cube.getCube() instanceof ModelElement && this.editor.displayGizmo.get()) {
            Mesh mesh = cube.renderObject;
            ModelElement me = (ModelElement)cube.getCube();
            EditorRenderer.Bounds b = new EditorRenderer.Bounds();
            b.elem = me;
            TriangleBoundingBox.BoxBuilder builder = TriangleBoundingBox.builder();
            if (mesh != null) {
                mesh.draw(stack, builder, 0.0f, 0.0f, 0.0f, 0.0f);
            } else if (me.type == ElementType.ROOT_PART && cube.doDisplay()) {
                renderer.renderParent(builder);
            }
            b.bb = builder.build();
            this.addBounds(b);
            Cube c = cube.getCube();
            if (c.size == null || c.size.x != 0.0f || c.size.y != 0.0f || c.size.z != 0.0f || c.mcScale != 0.0f) {
                OptionalBuffer vb = new OptionalBuffer(buf.getBuffer(renderTypes, RenderMode.OUTLINE));
                b.drawHover = vb;
                BoxRender.drawBoundingBox(stack, vb, cube.getBounds(), 1.0f, 0.0f, 0.0f, 1.0f);
            }
        }
    }

    public void render(GuiModelRenderManager.RedirectPartRenderer renderer, MatrixStack stack, VBuffers buf, RenderTypes<RenderMode> renderTypes, RenderedCube cube) {
        this.drawSelectionBox(renderer, stack, buf, renderTypes, cube);
        this.drawGizmo(cube, stack, buf, renderTypes);
    }

    private void drawGizmo(RenderedCube cube, MatrixStack matrixStackIn, VBuffers bufferIn, RenderTypes<RenderMode> renderTypes) {
        if (this.renderingPanel != null && this.renderingPanel.draggingVec != null && this.editor.displayGizmo.get() && cube.getCube() == this.editor.selectedElement && this.renderingPanel.canEdit()) {
            float gAlpha = ModConfig.getCommonConfig().getFloat("editorGizmoAlpha", 1.0f);
            float sc = 128.0f / (ModConfig.getCommonConfig().getBoolean("editorGizmoScale", true) ? this.renderingPanel.getCamera().camDist : 128.0f);
            float scW = Math.max(0.1f, Math.min(1.0f, ModConfig.getCommonConfig().getFloat("editorGizmoSize", 1.0f) * sc));
            float scL = Math.max(0.1f, Math.min(1.0f, ModConfig.getCommonConfig().getFloat("editorGizmoLength", 1.0f) * sc)) * 16.0f;
            EditorRenderer.drawDrag(matrixStackIn, bufferIn.getBuffer(renderTypes, RenderMode.OUTLINE), this.renderingPanel.draggingVec, (bt, bb) -> {
                EditorRenderer.Bounds b = new EditorRenderer.Bounds();
                b.elem = (ModelElement)cube.getCube();
                b.bb = bb.build();
                b.type = bt;
                this.addBounds(b);
                OptionalBuffer vb1 = new OptionalBuffer(bufferIn.getBuffer(renderTypes, RenderMode.COLOR));
                OptionalBuffer vb2 = new OptionalBuffer(bufferIn.getBuffer(renderTypes, RenderMode.OUTLINE));
                b.drawHover = () -> {
                    vb1.run();
                    vb2.run();
                };
                return new VertexBuffer[]{vb1, vb2};
            }, cube, this.renderingPanel.oldValue == null ? null : this.renderingPanel.oldValue[0], scW, scL, gAlpha);
            if (this.renderingPanel.draggingElement == cube.getCube()) {
                EditorRenderer.Bounds b = new EditorRenderer.Bounds();
                b.elem = (ModelElement)cube.getCube();
                b.bb = EditorRenderer.drawDragPane(matrixStackIn, bufferIn.getBuffer(renderTypes, RenderMode.OUTLINE), this.renderingPanel.draggingType, this.renderingPanel.draggingVec, cube, 48.0f, this.renderingPanel.oldValue[0]).build(true);
                b.type = EditorRenderer.BoundType.DRAG_PANE;
                this.addBounds(b);
            }
        }
    }

    @Override
    public boolean isHideHeadIfSkull() {
        return this.editor.hideHeadIfSkull;
    }

    @Override
    public boolean isRemoveArmorOffset() {
        return this.editor.removeArmorOffset;
    }

    public void addBounds(EditorRenderer.Bounds b) {
        if (this.renderingPanel != null) {
            this.renderingPanel.finishTransform(b);
        }
        this.bounds.add(b);
    }

    public EditorRenderer.Bounds select() {
        return this.bounds.stream().filter(b -> Float.isFinite(b.bb.isHovered())).max(Comparator.comparingDouble(b -> (float)((b.type == EditorRenderer.BoundType.CLICK ? 0 : (b.type == EditorRenderer.BoundType.DRAG_PANE ? 2 : 1)) * 100) - b.bb.isHovered())).orElse(null);
    }

    public void preRender() {
        this.itemTransforms.clear();
        this.bounds.clear();
    }
}

