/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.editor;

import com.tom.cpm.shared.editor.Editor;
import com.tom.cpm.shared.editor.ModelElement;
import com.tom.cpm.shared.editor.project.JsonMap;
import java.util.HashMap;
import java.util.Map;

public class CopyTransformEffect {
    public final ModelElement to;
    public long storeID;
    public ModelElement from;
    public boolean copyPX;
    public boolean copyPY;
    public boolean copyPZ;
    public boolean copyRX;
    public boolean copyRY;
    public boolean copyRZ;
    public boolean copySX;
    public boolean copySY;
    public boolean copySZ;

    public CopyTransformEffect(ModelElement to) {
        this.to = to;
    }

    public void load(JsonMap data) {
        this.storeID = data.getLong("storeID", 0L);
        this.copyPX = data.getBoolean("px", false);
        this.copyPY = data.getBoolean("py", false);
        this.copyPZ = data.getBoolean("pz", false);
        this.copyRX = data.getBoolean("rx", false);
        this.copyRY = data.getBoolean("ry", false);
        this.copyRZ = data.getBoolean("rz", false);
        this.copySX = data.getBoolean("sx", false);
        this.copySY = data.getBoolean("sy", false);
        this.copySZ = data.getBoolean("sz", false);
    }

    public short toShort() {
        short r = 0;
        if (this.copyPX) {
            r = (short)(r | 1);
        }
        if (this.copyPY) {
            r = (short)(r | 2);
        }
        if (this.copyPZ) {
            r = (short)(r | 4);
        }
        if (this.copyRX) {
            r = (short)(r | 8);
        }
        if (this.copyRY) {
            r = (short)(r | 0x10);
        }
        if (this.copyRZ) {
            r = (short)(r | 0x20);
        }
        if (this.copySX) {
            r = (short)(r | 0x40);
        }
        if (this.copySY) {
            r = (short)(r | 0x80);
        }
        if (this.copySZ) {
            r = (short)(r | 0x100);
        }
        return r;
    }

    public void apply() {
        if (this.from != null) {
            this.to.rc.setPosition(false, this.copyPX ? this.from.rc.getTransformPosition().x : this.to.rc.getTransformPosition().x, this.copyPY ? this.from.rc.getTransformPosition().y : this.to.rc.getTransformPosition().y, this.copyPZ ? this.from.rc.getTransformPosition().z : this.to.rc.getTransformPosition().z);
            this.to.rc.setRotation(false, this.copyRX ? this.from.rc.getTransformRotation().x : this.to.rc.getTransformRotation().x, this.copyRY ? this.from.rc.getTransformRotation().y : this.to.rc.getTransformRotation().y, this.copyRZ ? this.from.rc.getTransformRotation().z : this.to.rc.getTransformRotation().z);
            this.to.rc.setRenderScale(false, this.copySX ? this.from.rc.getRenderScale().x : this.to.rc.getRenderScale().x, this.copySY ? this.from.rc.getRenderScale().y : this.to.rc.getRenderScale().y, this.copySZ ? this.from.rc.getRenderScale().z : this.to.rc.getRenderScale().z);
        }
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> r = new HashMap<String, Object>();
        if (this.from != null) {
            r.put("storeID", this.from.storeID);
            r.put("px", this.copyPX);
            r.put("py", this.copyPY);
            r.put("pz", this.copyPZ);
            r.put("rx", this.copyRX);
            r.put("ry", this.copyRY);
            r.put("rz", this.copyRZ);
            r.put("sx", this.copySX);
            r.put("sy", this.copySY);
            r.put("sz", this.copySZ);
        }
        return r;
    }

    public void load(Editor editor) {
        Editor.walkElements(editor.elements, elem -> {
            if (elem.storeID == this.storeID) {
                this.from = elem;
            }
        });
    }
}

