/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.animation.interpolator;

import com.tom.cpl.math.MathHelper;
import com.tom.cpm.shared.animation.InterpolatorChannel;
import com.tom.cpm.shared.animation.interpolator.Interpolator;
import java.util.function.DoubleUnaryOperator;

public class LinearInterpolator
implements Interpolator {
    private float[] values;

    @Override
    public double applyAsDouble(double operand) {
        int frm = Math.abs(MathHelper.floor(operand));
        return MathHelper.lerp((float)(operand - Math.floor(operand)), this.values[Math.min(frm, this.values.length - 1)], this.values[Math.min(frm + 1, this.values.length - 1)]);
    }

    @Override
    public void init(float[] values, InterpolatorChannel channel) {
        DoubleUnaryOperator setup = channel.createInterpolatorSetup();
        this.values = new float[values.length];
        for (int i = 0; i < values.length; ++i) {
            this.values[i] = (float)setup.applyAsDouble(values[i]);
        }
    }
}

