/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.animation.interpolator;

import com.tom.cpm.shared.animation.interpolator.Interpolator;
import com.tom.cpm.shared.animation.interpolator.LinearInterpolator;
import com.tom.cpm.shared.animation.interpolator.LinearLoopInterpolator;
import com.tom.cpm.shared.animation.interpolator.NoInterpolate;
import com.tom.cpm.shared.animation.interpolator.PolynomialSplineInterpolator;
import com.tom.cpm.shared.animation.interpolator.PolynomialSplineLoopInterpolator;
import java.util.function.Supplier;

public enum InterpolatorType {
    POLY_LOOP(PolynomialSplineLoopInterpolator::new),
    POLY_SINGLE(PolynomialSplineInterpolator::new),
    LINEAR_LOOP(LinearLoopInterpolator::new),
    LINEAR_SINGLE(LinearInterpolator::new),
    NO_INTERPOLATE(NoInterpolate::new);

    public static final InterpolatorType[] VALUES;
    private final Supplier<Interpolator> factory;

    private InterpolatorType(Supplier<Interpolator> factory) {
        this.factory = factory;
    }

    public Interpolator create() {
        return this.factory.get();
    }

    public InterpolatorType getAlt(boolean loop) {
        if (loop) {
            if (this == POLY_SINGLE) {
                return POLY_LOOP;
            }
            if (this == LINEAR_SINGLE) {
                return LINEAR_LOOP;
            }
        } else {
            if (this == POLY_LOOP) {
                return POLY_SINGLE;
            }
            if (this == LINEAR_LOOP) {
                return LINEAR_SINGLE;
            }
        }
        return this;
    }

    static {
        VALUES = InterpolatorType.values();
    }
}

