/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.animation;

import com.tom.cpl.nbt.NBTTagCompound;
import com.tom.cpl.util.Hand;
import com.tom.cpl.util.HandAnimation;
import com.tom.cpm.shared.MinecraftClientAccess;
import com.tom.cpm.shared.animation.AnimationRegistry;
import com.tom.cpm.shared.animation.VanillaPose;
import com.tom.cpm.shared.model.render.PlayerModelSetup;
import com.tom.cpm.shared.network.ModelEventType;
import java.util.function.Consumer;

public class AnimationState {
    public int encodedState;
    public long jumping;
    public boolean hasSkullOnHead;
    public boolean wearingHelm;
    public boolean wearingBody;
    public boolean wearingLegs;
    public boolean wearingBoots;
    public boolean wearingElytra;
    public boolean sleeping;
    public boolean dying;
    public boolean riding;
    public boolean elytraFlying;
    public boolean creativeFlying;
    public boolean creativeFlyingServer;
    public boolean swimming;
    public boolean retroSwimming;
    public boolean sprinting;
    public boolean sneaking;
    public boolean takingDmg;
    public boolean tridentSpin;
    public float fallDistance;
    public float fallDistanceServer;
    public float moveAmountX;
    public float moveAmountY;
    public float moveAmountZ;
    public float attackTime;
    public float swimAmount;
    public float bowPullback;
    public float crossbowPullback;
    public float yaw;
    public float pitch;
    public float speakLevel;
    public int hurtTime;
    public Hand mainHand = Hand.RIGHT;
    public Hand activeHand = Hand.RIGHT;
    public Hand swingingHand = Hand.RIGHT;
    public PlayerModelSetup.ArmPose leftArm = PlayerModelSetup.ArmPose.EMPTY;
    public PlayerModelSetup.ArmPose rightArm = PlayerModelSetup.ArmPose.EMPTY;
    public HandAnimation usingAnimation = HandAnimation.NONE;
    public boolean parrotLeft;
    public boolean parrotRight;
    public boolean isFreezing;
    public boolean isBurning;
    public boolean isOnLadder;
    public boolean isClimbing;
    public boolean inGui;
    public boolean firstPersonMod;
    public byte[] gestureData;

    public void resetPlayer() {
        this.sleeping = false;
        this.dying = false;
        this.riding = false;
        this.elytraFlying = false;
        this.creativeFlying = false;
        this.swimming = false;
        this.retroSwimming = false;
        this.sprinting = false;
        this.sneaking = false;
        this.tridentSpin = false;
        this.usingAnimation = HandAnimation.NONE;
        this.encodedState = 0;
        this.fallDistance = 0.0f;
        this.moveAmountX = 0.0f;
        this.moveAmountY = 0.0f;
        this.moveAmountZ = 0.0f;
        this.bowPullback = 0.0f;
        this.crossbowPullback = 0.0f;
        this.yaw = 0.0f;
        this.pitch = 0.0f;
        this.hurtTime = 0;
        this.speakLevel = 0.0f;
    }

    public void resetModel() {
        this.attackTime = 0.0f;
        this.swimAmount = 0.0f;
        this.rightArm = PlayerModelSetup.ArmPose.EMPTY;
        this.leftArm = PlayerModelSetup.ArmPose.EMPTY;
    }

    public VanillaPose getMainPose(long time, AnimationRegistry registry) {
        if (this.sleeping) {
            return VanillaPose.SLEEPING;
        }
        if (this.dying) {
            return VanillaPose.DYING;
        }
        if (this.elytraFlying) {
            return VanillaPose.FLYING;
        }
        if (this.tridentSpin) {
            return VanillaPose.TRIDENT_SPIN;
        }
        if (this.fallDistance > 4.0f || this.fallDistanceServer > 4.0f) {
            return VanillaPose.FALLING;
        }
        if (this.creativeFlying || this.creativeFlyingServer) {
            return VanillaPose.CREATIVE_FLYING;
        }
        if (this.riding) {
            return VanillaPose.RIDING;
        }
        if (this.swimming) {
            return VanillaPose.SWIMMING;
        }
        if (this.retroSwimming && registry.hasPoseAnimations(VanillaPose.RETRO_SWIMMING)) {
            return VanillaPose.RETRO_SWIMMING;
        }
        if (this.isClimbing && Math.abs(this.moveAmountY) > 0.05f && registry.hasPoseAnimations(VanillaPose.CLIMBING_ON_LADDER)) {
            return VanillaPose.CLIMBING_ON_LADDER;
        }
        if (this.isClimbing && registry.hasPoseAnimations(VanillaPose.ON_LADDER)) {
            return VanillaPose.ON_LADDER;
        }
        if (this.jumping + 500L > time && registry.hasPoseAnimations(VanillaPose.JUMPING)) {
            return VanillaPose.JUMPING;
        }
        if (this.sneaking) {
            return (Math.abs(this.moveAmountX) > 0.0f || Math.abs(this.moveAmountZ) > 0.0f) && registry.hasPoseAnimations(VanillaPose.SNEAK_WALK) ? VanillaPose.SNEAK_WALK : VanillaPose.SNEAKING;
        }
        if (this.sprinting) {
            return VanillaPose.RUNNING;
        }
        if (Math.abs(this.moveAmountX) > 0.0f || Math.abs(this.moveAmountZ) > 0.0f) {
            return VanillaPose.WALKING;
        }
        return VanillaPose.STANDING;
    }

    public void collectAnimations(Consumer<VanillaPose> h) {
        VanillaPose pose;
        h.accept(VanillaPose.GLOBAL);
        if (this.attackTime > 0.0f) {
            if (this.swingingHand == Hand.LEFT) {
                h.accept(VanillaPose.PUNCH_LEFT);
            } else if (this.swingingHand == Hand.RIGHT) {
                h.accept(VanillaPose.PUNCH_RIGHT);
            }
        }
        if (this.hasSkullOnHead) {
            h.accept(VanillaPose.WEARING_SKULL);
        } else if (this.wearingHelm) {
            h.accept(VanillaPose.ARMOR_HEAD);
        }
        if (this.wearingElytra) {
            h.accept(VanillaPose.WEARING_ELYTRA);
        } else if (this.wearingBody) {
            h.accept(VanillaPose.ARMOR_BODY);
        }
        if (this.wearingLegs) {
            h.accept(VanillaPose.ARMOR_LEGS);
        }
        if (this.wearingBoots) {
            h.accept(VanillaPose.ARMOR_BOOTS);
        }
        if ((pose = AnimationState.getArmPose(this.leftArm, true)) != null) {
            h.accept(pose);
        }
        if ((pose = AnimationState.getArmPose(this.rightArm, false)) != null) {
            h.accept(pose);
        }
        if (this.usingAnimation == HandAnimation.EAT || this.usingAnimation == HandAnimation.DRINK) {
            if (this.activeHand == Hand.LEFT) {
                h.accept(VanillaPose.EATING_LEFT);
            } else {
                h.accept(VanillaPose.EATING_RIGHT);
            }
        }
        if (this.parrotLeft) {
            h.accept(VanillaPose.PARROT_LEFT);
        }
        if (this.parrotRight) {
            h.accept(VanillaPose.PARROT_RIGHT);
        }
        if (this.hurtTime > 0) {
            h.accept(VanillaPose.HURT);
        }
        if (this.isBurning) {
            h.accept(VanillaPose.ON_FIRE);
        }
        if (this.isFreezing) {
            h.accept(VanillaPose.FREEZING);
        }
        if (this.speakLevel > 0.1f) {
            h.accept(VanillaPose.SPEAKING);
        }
        if (this.inGui) {
            h.accept(VanillaPose.IN_GUI);
        }
        if (this.firstPersonMod) {
            h.accept(VanillaPose.FIRST_PERSON_MOD);
        }
    }

    private static VanillaPose getArmPose(PlayerModelSetup.ArmPose pose, boolean left) {
        switch (pose) {
            case BLOCK: {
                return left ? VanillaPose.BLOCKING_LEFT : VanillaPose.BLOCKING_RIGHT;
            }
            case BOW_AND_ARROW: {
                return left ? VanillaPose.BOW_LEFT : VanillaPose.BOW_RIGHT;
            }
            case CROSSBOW_CHARGE: {
                return left ? VanillaPose.CROSSBOW_CH_LEFT : VanillaPose.CROSSBOW_CH_RIGHT;
            }
            case CROSSBOW_HOLD: {
                return left ? VanillaPose.CROSSBOW_LEFT : VanillaPose.CROSSBOW_RIGHT;
            }
            case EMPTY: {
                break;
            }
            case ITEM: {
                return left ? VanillaPose.HOLDING_LEFT : VanillaPose.HOLDING_RIGHT;
            }
            case SPYGLASS: {
                return left ? VanillaPose.SPYGLASS_LEFT : VanillaPose.SPYGLASS_RIGHT;
            }
            case THROW_SPEAR: {
                return left ? VanillaPose.TRIDENT_LEFT : VanillaPose.TRIDENT_RIGHT;
            }
            case TOOT_HORN: {
                return left ? VanillaPose.TOOT_HORN_LEFT : VanillaPose.TOOT_HORN_RIGHT;
            }
        }
        return null;
    }

    public void receiveEvent(NBTTagCompound tag, boolean isClient) {
        if (!isClient) {
            if (tag.hasKey(ModelEventType.FALLING.getName())) {
                this.fallDistanceServer = tag.getFloat(ModelEventType.FALLING.getName());
            }
            if (tag.hasKey(ModelEventType.CREATIVE_FLYING.getName())) {
                this.creativeFlyingServer = tag.getBoolean(ModelEventType.CREATIVE_FLYING.getName());
            }
            if (tag.hasKey(ModelEventType.JUMPING.getName())) {
                long l = this.jumping = tag.getBoolean(ModelEventType.JUMPING.getName()) ? MinecraftClientAccess.get().getPlayerRenderManager().getAnimationEngine().getTime() : 0L;
            }
        }
        if (tag.hasKey("gesture")) {
            this.gestureData = tag.getByteArray("gesture");
        }
    }

    public void jump() {
        this.jumping = MinecraftClientAccess.get().getPlayerRenderManager().getAnimationEngine().getTime();
    }

    public void preAnimate() {
        if (this.isOnLadder && this.moveAmountY > 0.0f) {
            this.isClimbing = true;
        } else if (!this.isOnLadder) {
            this.isClimbing = false;
        }
    }
}

