/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.animation;

import com.tom.cpm.shared.animation.AnimationState;
import com.tom.cpm.shared.animation.Gesture;
import com.tom.cpm.shared.animation.IAnimation;
import com.tom.cpm.shared.animation.IPose;
import com.tom.cpm.shared.definition.ModelDefinition;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Supplier;

public class AnimationHandler {
    private final Supplier<ModelDefinition> player;
    private List<PlayingAnim> currentAnimations = new ArrayList<PlayingAnim>();
    private List<NextAnim> nextAnims = new ArrayList<NextAnim>();
    private Gesture currentGesture;

    public AnimationHandler(Supplier<ModelDefinition> player) {
        this.player = player;
    }

    public void animate(AnimationState state, long currentTime) {
        boolean needsSort = false;
        this.currentAnimations.removeIf(a -> this.nextAnims.stream().noneMatch(n -> n.animation == a.currentAnimation));
        for (NextAnim animation : this.nextAnims) {
            boolean found = false;
            for (int i = 0; i < this.currentAnimations.size(); ++i) {
                if (this.currentAnimations.get((int)i).currentAnimation != animation.animation) continue;
                found = true;
                break;
            }
            if (found) continue;
            this.currentAnimations.add(new PlayingAnim(animation, currentTime, this.currentGesture != null ? (this.currentGesture.animation.contains(animation.animation) ? this.currentGesture.isLoop : true) : true));
            needsSort = true;
        }
        if (needsSort) {
            this.currentAnimations.sort(Comparator.comparingInt(e -> e.currentAnimation.getPriority()));
        }
        this.player.get().resetAnimationPos();
        for (PlayingAnim a2 : this.currentAnimations) {
            if (a2.finished) continue;
            long currentStep = currentTime - a2.currentStart;
            a2.currentAnimation.animate(a2.getTime(state, currentStep), this.player.get());
            if (a2.loop || currentStep <= (long)a2.currentAnimation.getDuration()) continue;
            a2.finished = true;
        }
        this.nextAnims.clear();
    }

    public void addAnimations(List<? extends IAnimation> next, IPose pose) {
        next.stream().map(a -> new NextAnim((IAnimation)a, pose)).forEach(this.nextAnims::add);
    }

    public void setGesture(Gesture next) {
        this.currentGesture = next;
        if (next != null) {
            this.addAnimations(next.animation, null);
        }
    }

    public void clear() {
        this.currentGesture = null;
        this.nextAnims.clear();
        this.currentAnimations.clear();
    }

    private static class NextAnim {
        private IAnimation animation;
        private IPose pose;

        public NextAnim(IAnimation animation, IPose pose) {
            this.animation = animation;
            this.pose = pose;
        }
    }

    private static class PlayingAnim {
        private IAnimation currentAnimation;
        private IPose pose;
        private long currentStart;
        private boolean loop;
        private boolean finished;

        public PlayingAnim(NextAnim anim, long currentStart, boolean loop) {
            this.currentAnimation = anim.animation;
            this.pose = anim.pose;
            this.currentStart = currentStart;
            this.loop = loop;
            this.finished = false;
        }

        public long getTime(AnimationState state, long time) {
            if (this.pose == null) {
                return time;
            }
            return this.pose.getTime(state, time);
        }
    }
}

