/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared;

import com.tom.cpl.command.ArgType;
import com.tom.cpl.command.CommandCtx;
import com.tom.cpl.command.CommandHandler;
import com.tom.cpl.command.LiteralCommandBuilder;
import com.tom.cpl.command.RequiredCommandBuilder;
import com.tom.cpl.config.ConfigEntry;
import com.tom.cpl.text.FormatText;
import com.tom.cpl.util.Pair;
import com.tom.cpm.shared.MinecraftServerAccess;
import com.tom.cpm.shared.config.BuiltInSafetyProfiles;
import com.tom.cpm.shared.config.ConfigKeys;
import com.tom.cpm.shared.config.ModConfig;
import com.tom.cpm.shared.config.PlayerSpecificConfigKey;
import com.tom.cpm.shared.network.NetHandler;
import com.tom.cpm.shared.util.ScalingOptions;
import java.util.ArrayList;
import java.util.List;

public class CommandCPM {
    public static void register(CommandHandler<?> dispatcher) {
        LiteralCommandBuilder cpm = (LiteralCommandBuilder)((LiteralCommandBuilder)((LiteralCommandBuilder)((LiteralCommandBuilder)new LiteralCommandBuilder("cpm").then(((LiteralCommandBuilder)((LiteralCommandBuilder)((LiteralCommandBuilder)new LiteralCommandBuilder("setskin").then(new LiteralCommandBuilder("-f").then(new RequiredCommandBuilder("target", ArgType.PLAYER).then(new RequiredCommandBuilder("skin", ArgType.STRING, true).run(c -> CommandCPM.executeSkinChange(c, (String)c.getArgument("skin"), true, true)))))).then(new LiteralCommandBuilder("-t").then(new RequiredCommandBuilder("target", ArgType.PLAYER).then(new RequiredCommandBuilder("skin", ArgType.STRING, true).run(c -> CommandCPM.executeSkinChange(c, (String)c.getArgument("skin"), false, false)))))).then(new LiteralCommandBuilder("-r").then(new RequiredCommandBuilder("target", ArgType.PLAYER).run(c -> CommandCPM.executeSkinChange(c, null, false, true))))).then(new RequiredCommandBuilder("target", ArgType.PLAYER).then(new RequiredCommandBuilder("skin", ArgType.STRING, true).run(c -> CommandCPM.executeSkinChange(c, (String)c.getArgument("skin"), false, true)))))).then(((LiteralCommandBuilder)new LiteralCommandBuilder("safety").then(new LiteralCommandBuilder("recommend").then(new RequiredCommandBuilder("enable", ArgType.BOOLEAN).run(c -> CommandCPM.executeSafetyRec(c, (Boolean)c.getArgument("enable")))))).then(new LiteralCommandBuilder("set").thenAll(CommandCPM::buildSettings)))).then(((LiteralCommandBuilder)((LiteralCommandBuilder)new LiteralCommandBuilder("kick").then(new LiteralCommandBuilder("enable").then(new RequiredCommandBuilder("time", ArgType.INT, Pair.of(1, Short.MAX_VALUE)).run(c -> CommandCPM.executeSetKickTimer(c, (Integer)c.getArgument("time")))))).then(new LiteralCommandBuilder("disable").run(c -> CommandCPM.executeSetKickTimer(c, 0)))).then(new LiteralCommandBuilder("message").then(new RequiredCommandBuilder("message", ArgType.STRING, true).run(CommandCPM::executeSetKickMessage))))).then(new LiteralCommandBuilder("scaling").thenAll(CommandCPM::buildScaling));
        dispatcher.register(cpm);
    }

    private static void executeSetKickTimer(CommandCtx<?> context, int time) {
        ModConfig.getWorldConfig().setInt("kickPlayersWithoutMod", time);
        ModConfig.getWorldConfig().save();
        context.sendSuccess(new FormatText("commands.cpm.setValue", new FormatText("commands.cpm.kickWOMod", new Object[0]), time));
    }

    private static void executeSetKickMessage(CommandCtx<?> context) {
        String msg = (String)context.getArgument("message");
        ModConfig.getWorldConfig().setString("kickMessage", msg);
        ModConfig.getWorldConfig().save();
        context.sendSuccess(new FormatText("commands.cpm.setValue", new FormatText("commands.cpm.kickWOMod.msg", new Object[0]), msg));
    }

    private static List<LiteralCommandBuilder> buildSettings() {
        ArrayList<LiteralCommandBuilder> l = new ArrayList<LiteralCommandBuilder>();
        LiteralCommandBuilder profile = new LiteralCommandBuilder("profile");
        for (BuiltInSafetyProfiles builtInSafetyProfiles : BuiltInSafetyProfiles.VALUES) {
            profile.then(new LiteralCommandBuilder(builtInSafetyProfiles.name().toLowerCase()).run(c -> CommandCPM.executeSafetyProfile(c, p)));
        }
        l.add(profile);
        for (PlayerSpecificConfigKey playerSpecificConfigKey : ConfigKeys.SAFETY_KEYS) {
            LiteralCommandBuilder s = new LiteralCommandBuilder(playerSpecificConfigKey.getName());
            s.then(new RequiredCommandBuilder("value", playerSpecificConfigKey.getType(), playerSpecificConfigKey.getTypeArg()).run(c -> CommandCPM.executeSetSettings(c, playerSpecificConfigKey)));
            l.add(s);
        }
        return l;
    }

    private static void executeSafetyRec(CommandCtx<?> context, boolean en) {
        ModConfig.getWorldConfig().setBoolean("serverRecommendSafetySettings", en);
        ModConfig.getWorldConfig().save();
        context.sendSuccess(new FormatText("commands.cpm.setValue", new FormatText("commands.cpm.safety.recommend", new Object[0]), en));
    }

    private static <V> void executeSetSettings(CommandCtx<?> context, PlayerSpecificConfigKey<V> key) {
        Object value = context.getArgument("value");
        ConfigEntry main = ModConfig.getWorldConfig().getEntry("safetySettings");
        key.setValue(main, value);
        ModConfig.getWorldConfig().save();
        context.sendSuccess(new FormatText("commands.cpm.setValue", new FormatText("label.cpm.safety." + key.getName(), new Object[0]), key.formatValue(value)));
    }

    private static void executeSafetyProfile(CommandCtx<?> context, BuiltInSafetyProfiles profile) {
        ModConfig.getWorldConfig().setString("safetyProfile", profile.name().toLowerCase());
        ModConfig.getWorldConfig().save();
        FormatText t = profile == BuiltInSafetyProfiles.CUSTOM ? new FormatText("commands.cpm.safety.profile.custom", new Object[0]) : new FormatText("label.cpm.safetyProfile." + profile.name().toLowerCase(), new Object[0]);
        context.sendSuccess(new FormatText("commands.cpm.setValue", new FormatText("label.cpm.safetyProfileName", new Object[0]), t));
    }

    private static void executeSkinChange(CommandCtx<?> context, String skin, boolean force, boolean save) {
        Object player = context.getArgument("target");
        NetHandler<?, ?, ?> h = MinecraftServerAccess.get().getNetHandler();
        h.setSkin(player, skin, force, save);
        if (force) {
            context.sendSuccess(new FormatText("commands.cpm.setskin.success.force", context.handler.toStringPlayer(player)));
        } else {
            context.sendSuccess(new FormatText("commands.cpm.setskin.success", context.handler.toStringPlayer(player)));
        }
    }

    private static List<LiteralCommandBuilder> buildScaling() {
        ArrayList<LiteralCommandBuilder> l = new ArrayList<LiteralCommandBuilder>();
        for (ScalingOptions o : ScalingOptions.VALUES) {
            String name = o.name().toLowerCase();
            LiteralCommandBuilder s = new LiteralCommandBuilder(name);
            ((LiteralCommandBuilder)s.then(((LiteralCommandBuilder)((LiteralCommandBuilder)new LiteralCommandBuilder("limit").then(((RequiredCommandBuilder)new RequiredCommandBuilder("target", ArgType.PLAYER).then(new RequiredCommandBuilder("max", ArgType.FLOAT, Pair.of(Float.valueOf(o.getMin()), Float.valueOf(o.getMax()))).run(c -> CommandCPM.setScalingLimit(c, c.getArgument("target"), o, o.getMin(), ((Float)c.getArgument("max")).floatValue())))).then(new RequiredCommandBuilder("min", ArgType.FLOAT, Pair.of(Float.valueOf(o.getMin()), Float.valueOf(o.getMax()))).then(new RequiredCommandBuilder("max", ArgType.FLOAT, Pair.of(Float.valueOf(o.getMin()), Float.valueOf(o.getMax()))).run(c -> CommandCPM.setScalingLimit(c, c.getArgument("target"), o, ((Float)c.getArgument("min")).floatValue(), ((Float)c.getArgument("max")).floatValue())))))).then(new RequiredCommandBuilder("max", ArgType.FLOAT, Pair.of(Float.valueOf(o.getMin()), Float.valueOf(o.getMax()))).run(c -> CommandCPM.setScalingLimit(c, null, o, o.getMin(), ((Float)c.getArgument("max")).floatValue())))).then(new RequiredCommandBuilder("min", ArgType.FLOAT, Pair.of(Float.valueOf(o.getMin()), Float.valueOf(o.getMax()))).then(new RequiredCommandBuilder("max", ArgType.FLOAT, Pair.of(Float.valueOf(o.getMin()), Float.valueOf(o.getMax()))).run(c -> CommandCPM.setScalingLimit(c, null, o, ((Float)c.getArgument("min")).floatValue(), ((Float)c.getArgument("max")).floatValue())))))).then(((LiteralCommandBuilder)new LiteralCommandBuilder("enabled").then(new RequiredCommandBuilder("target", ArgType.PLAYER).then(new RequiredCommandBuilder("enable", ArgType.BOOLEAN).run(c -> CommandCPM.setScalingEn(c, c.getArgument("target"), o, (Boolean)c.getArgument("enable")))))).then(new RequiredCommandBuilder("enable", ArgType.BOOLEAN).run(c -> CommandCPM.setScalingEn(c, null, o, (Boolean)c.getArgument("enable")))));
            l.add(s);
        }
        LiteralCommandBuilder all = new LiteralCommandBuilder("all");
        all.then(((LiteralCommandBuilder)new LiteralCommandBuilder("enabled").then(new RequiredCommandBuilder("target", ArgType.PLAYER).then(new RequiredCommandBuilder("enable", ArgType.BOOLEAN).run(c -> CommandCPM.setScalingEnAll(c, c.getArgument("target"), (Boolean)c.getArgument("enable")))))).then(new RequiredCommandBuilder("enable", ArgType.BOOLEAN).run(c -> CommandCPM.setScalingEnAll(c, null, (Boolean)c.getArgument("enable")))));
        l.add(all);
        return l;
    }

    private static void setScalingEnAll(CommandCtx<?> context, Object player, boolean en) {
        NetHandler<?, ?, ?> h = MinecraftServerAccess.get().getNetHandler();
        ConfigEntry e = ModConfig.getWorldConfig();
        e = player != null ? e.getEntry("player_scaling_settings").getEntry(h.getID(player)) : e.getEntry("scaling_settings");
        for (ScalingOptions o : ScalingOptions.VALUES) {
            ConfigEntry ce = e.getEntry(o.name().toLowerCase());
            ce.setBoolean("enabled", en);
            context.sendSuccess(new FormatText("commands.cpm.setValue", new FormatText("label.cpm.tree.scaling." + o.name().toLowerCase(), new Object[0]), new FormatText("label.cpm.enableX", en)));
        }
        ModConfig.getWorldConfig().save();
    }

    private static void setScalingEn(CommandCtx<?> context, Object player, ScalingOptions sc, boolean en) {
        NetHandler<?, ?, ?> h = MinecraftServerAccess.get().getNetHandler();
        ConfigEntry e = ModConfig.getWorldConfig();
        e = player != null ? e.getEntry("player_scaling_settings").getEntry(h.getID(player)) : e.getEntry("scaling_settings");
        e = e.getEntry(sc.name().toLowerCase());
        e.setBoolean("enabled", en);
        ModConfig.getWorldConfig().save();
        context.sendSuccess(new FormatText("commands.cpm.setValue", new FormatText("label.cpm.tree.scaling." + sc.name().toLowerCase(), new Object[0]), new FormatText("label.cpm.enableX", en)));
    }

    private static void setScalingLimit(CommandCtx<?> context, Object player, ScalingOptions sc, float min, float max) {
        if (min > 1.0f || min > max || max < 1.0f) {
            context.fail(new FormatText("commands.cpm.numberOutOfBounds", new Object[0]));
            return;
        }
        NetHandler<?, ?, ?> h = MinecraftServerAccess.get().getNetHandler();
        ConfigEntry e = ModConfig.getWorldConfig();
        e = player != null ? e.getEntry("player_scaling_settings").getEntry(h.getID(player)) : e.getEntry("scaling_settings");
        e = e.getEntry(sc.name().toLowerCase());
        e.setFloat("min", min);
        e.setFloat("max", max);
        ModConfig.getWorldConfig().save();
        context.sendSuccess(new FormatText("commands.cpm.setValue", new FormatText("label.cpm.tree.scaling." + sc.name().toLowerCase(), new Object[0]), new FormatText("label.cpm.rangeOf", Float.valueOf(min), Float.valueOf(max))));
    }
}

