/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.client;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.blaze3d.systems.RenderSystem;
import com.tom.cpl.math.MathHelper;
import com.tom.cpl.util.Hand;
import com.tom.cpl.util.HandAnimation;
import com.tom.cpm.shared.config.Player;
import com.tom.cpm.shared.model.SkinType;
import com.tom.cpm.shared.model.render.PlayerModelSetup;
import com.tom.cpm.shared.skin.PlayerTextureLoader;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.BooleanSupplier;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1068;
import net.minecraft.class_1071;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1664;
import net.minecraft.class_1747;
import net.minecraft.class_1753;
import net.minecraft.class_1764;
import net.minecraft.class_1770;
import net.minecraft.class_1799;
import net.minecraft.class_2190;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4050;
import net.minecraft.class_591;

public class PlayerProfile
extends Player<class_1657> {
    public static boolean inGui;
    public static BooleanSupplier inFirstPerson;
    private final GameProfile profile;
    private String skinType;

    public PlayerProfile(GameProfile profile) {
        this.profile = profile;
        if (profile.getId() != null) {
            this.skinType = class_1068.method_4647((UUID)profile.getId());
        }
    }

    @Override
    public SkinType getSkinType() {
        return SkinType.get(this.skinType);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.profile == null ? 0 : this.profile.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PlayerProfile other = (PlayerProfile)obj;
        return !(this.profile == null ? other.profile != null : !this.profile.equals((Object)other.profile));
    }

    @Override
    protected PlayerTextureLoader initTextures() {
        return new PlayerTextureLoader(class_310.method_1551().method_1582().field_5305){

            @Override
            protected CompletableFuture<Void> load0() {
                Map map = class_310.method_1551().method_1582().method_4654(PlayerProfile.this.profile);
                this.defineAll(map, MinecraftProfileTexture::getUrl, MinecraftProfileTexture::getHash);
                if (map.containsKey(MinecraftProfileTexture.Type.SKIN)) {
                    MinecraftProfileTexture tex = (MinecraftProfileTexture)map.get(MinecraftProfileTexture.Type.SKIN);
                    PlayerProfile.this.skinType = tex.getMetadata("model");
                    if (PlayerProfile.this.skinType == null) {
                        PlayerProfile.this.skinType = "default";
                    }
                    return CompletableFuture.completedFuture(null);
                }
                final CompletableFuture<Void> cf = new CompletableFuture<Void>();
                class_310.method_1551().method_1582().method_4652(PlayerProfile.this.profile, new class_1071.class_1072(){

                    public void onSkinTextureAvailable(MinecraftProfileTexture.Type typeIn, class_2960 identifier, MinecraftProfileTexture profileTexture) {
                        this.defineTexture((Enum)typeIn, profileTexture.getUrl(), profileTexture.getHash());
                        switch (typeIn) {
                            case SKIN: {
                                PlayerProfile.this.skinType = profileTexture.getMetadata("model");
                                if (PlayerProfile.this.skinType == null) {
                                    PlayerProfile.this.skinType = "default";
                                }
                                RenderSystem.recordRenderCall(() -> cf.complete(null));
                                break;
                            }
                        }
                    }
                }, true);
                return cf;
            }
        };
    }

    @Override
    public UUID getUUID() {
        return this.profile.getId();
    }

    @Override
    public void updateFromPlayer(class_1657 player) {
        float f1;
        float f;
        class_1799 is;
        class_4050 p = player.method_18376();
        this.animState.resetPlayer();
        switch (p) {
            case field_18081: {
                this.animState.sneaking = true;
                break;
            }
            case field_18082: {
                break;
            }
            case field_18077: {
                this.animState.elytraFlying = true;
                break;
            }
            case field_18078: {
                this.animState.sleeping = true;
                break;
            }
            case field_18080: {
                this.animState.tridentSpin = true;
                break;
            }
            case field_18076: {
                break;
            }
            case field_18079: {
                this.animState.swimming = true;
                break;
            }
        }
        if (!player.method_5805()) {
            this.animState.dying = true;
        }
        if (player.method_5765()) {
            this.animState.riding = true;
        }
        if (player.method_31549().field_7479) {
            this.animState.creativeFlying = true;
        }
        if (player.method_5624()) {
            this.animState.sprinting = true;
        }
        if (player.method_6115()) {
            this.animState.usingAnimation = HandAnimation.of(player.method_6030().method_7976());
        }
        this.animState.fallDistance = player.field_6017;
        this.animState.moveAmountX = (float)(player.method_23317() - player.field_6014);
        this.animState.moveAmountY = (float)(player.method_23318() - player.field_6036);
        this.animState.moveAmountZ = (float)(player.method_23321() - player.field_5969);
        this.animState.yaw = player.method_36454();
        this.animState.pitch = player.method_36455();
        if (player.method_7348(class_1664.field_7563)) {
            this.animState.encodedState |= 1;
        }
        if (player.method_7348(class_1664.field_7564)) {
            this.animState.encodedState |= 2;
        }
        if (player.method_7348(class_1664.field_7566)) {
            this.animState.encodedState |= 4;
        }
        if (player.method_7348(class_1664.field_7565)) {
            this.animState.encodedState |= 8;
        }
        if (player.method_7348(class_1664.field_7568)) {
            this.animState.encodedState |= 0x10;
        }
        if (player.method_7348(class_1664.field_7570)) {
            this.animState.encodedState |= 0x20;
        }
        this.animState.hasSkullOnHead = (is = player.method_6118(class_1304.field_6169)).method_7909() instanceof class_1747 && ((class_1747)is.method_7909()).method_7711() instanceof class_2190;
        this.animState.wearingHelm = !is.method_7960();
        is = player.method_6118(class_1304.field_6174);
        this.animState.wearingElytra = is.method_7909() instanceof class_1770;
        this.animState.wearingBody = !is.method_7960();
        this.animState.wearingLegs = !player.method_6118(class_1304.field_6172).method_7960();
        this.animState.wearingBoots = !player.method_6118(class_1304.field_6166).method_7960();
        this.animState.mainHand = Hand.of(player.method_6068());
        this.animState.activeHand = Hand.of(this.animState.mainHand, player.method_6058());
        this.animState.swingingHand = Hand.of(this.animState.mainHand, player.field_6266);
        this.animState.hurtTime = player.field_6235;
        this.animState.isOnLadder = player.method_6101();
        this.animState.isBurning = player.method_5809();
        this.animState.isFreezing = player.method_32312() > 0;
        this.animState.inGui = inGui;
        this.animState.firstPersonMod = inFirstPerson.getAsBoolean();
        if (player.method_6030().method_7909() instanceof class_1764) {
            f = class_1764.method_7775((class_1799)player.method_6030());
            f1 = MathHelper.clamp((float)player.method_6048(), 0.0f, f);
            this.animState.crossbowPullback = f1 / f;
        }
        if (player.method_6030().method_7909() instanceof class_1753) {
            f = 20.0f;
            f1 = MathHelper.clamp((float)player.method_6048(), 0.0f, f);
            this.animState.bowPullback = f1 / f;
        }
        this.animState.parrotLeft = !player.method_7356().method_10558("id").isEmpty();
        this.animState.parrotRight = !player.method_7308().method_10558("id").isEmpty();
    }

    @Override
    public void updateFromModel(Object model) {
        if (model instanceof class_591) {
            class_591 m = (class_591)model;
            this.animState.resetModel();
            this.animState.attackTime = m.field_3447;
            this.animState.swimAmount = m.field_3396;
            this.animState.leftArm = PlayerModelSetup.ArmPose.of(m.field_3399);
            this.animState.rightArm = PlayerModelSetup.ArmPose.of(m.field_3395);
        }
    }

    @Override
    public String getName() {
        return this.profile.getName();
    }

    @Override
    public Object getGameProfile() {
        return this.profile;
    }

    static {
        inFirstPerson = () -> false;
        if (FabricLoader.getInstance().isModLoaded("firstperson")) {
            try {
                MethodHandle h = MethodHandles.lookup().unreflectGetter(Class.forName("dev.tr7zw.firstperson.FirstPersonModelCore").getDeclaredField("isRenderingPlayer"));
                inFirstPerson = () -> {
                    try {
                        return h.invoke();
                    }
                    catch (Throwable e) {
                        inFirstPerson = () -> false;
                        return false;
                    }
                };
                inFirstPerson.getAsBoolean();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

