/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.tom.cpl.gui.Frame;
import com.tom.cpl.gui.IGui;
import com.tom.cpl.gui.KeyCodes;
import com.tom.cpl.gui.KeyboardEvent;
import com.tom.cpl.gui.MouseEvent;
import com.tom.cpl.gui.NativeGuiComponents;
import com.tom.cpl.gui.UIColors;
import com.tom.cpl.gui.elements.FileChooserPopup;
import com.tom.cpl.gui.elements.TextField;
import com.tom.cpl.math.Box;
import com.tom.cpl.math.Vec2i;
import com.tom.cpl.text.IText;
import com.tom.cpm.client.GLFWKeyCodes;
import com.tom.cpm.client.MinecraftObject;
import com.tom.cpm.client.Panel3dImpl;
import com.tom.cpm.client.TinyFDChooser;
import com.tom.cpm.shared.gui.panel.Panel3d;
import java.io.File;
import java.nio.file.Path;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1074;
import net.minecraft.class_1159;
import net.minecraft.class_155;
import net.minecraft.class_156;
import net.minecraft.class_1659;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_342;
import net.minecraft.class_408;
import net.minecraft.class_419;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_757;
import net.minecraft.client.ClientBrandRetriever;
import org.lwjgl.glfw.GLFW;

public class GuiImpl
extends class_437
implements IGui {
    private static final KeyCodes CODES = new GLFWKeyCodes();
    private static final NativeGuiComponents nativeComponents = new NativeGuiComponents();
    private Frame gui;
    private class_437 parent;
    private IGui.CtxStack stack;
    private UIColors colors = new UIColors();
    private Consumer<Runnable> closeListener;
    private int keyModif;
    public class_4587 matrixStack;
    private int vanillaScale = -1;

    public GuiImpl(Function<IGui, Frame> creator, class_437 parent) {
        super((class_2561)new class_2585(""));
        this.parent = parent;
        try {
            this.gui = creator.apply(this);
        }
        catch (Throwable e) {
            this.onGuiException("Error creating gui", e, true);
        }
    }

    private static <G extends Supplier<IGui>, N> NativeGuiComponents.NativeConstructor<G, N> local(Function<GuiImpl, N> fac) {
        return f -> fac.apply((GuiImpl)f.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void method_25394(class_4587 matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.method_25433(matrixStack, 0);
        try {
            this.matrixStack = matrixStack;
            matrixStack.method_22903();
            matrixStack.method_22904(0.0, 0.0, 800.0);
            this.stack = new IGui.CtxStack(this.field_22789, this.field_22790);
            RenderSystem.runAsFancy(() -> this.gui.draw(mouseX, mouseY, partialTicks));
        }
        catch (Throwable e) {
            this.onGuiException("Error drawing gui", e, true);
        }
        finally {
            RenderSystem.disableScissor();
            String modVer = FabricLoader.getInstance().getModContainer("cpm").map(m -> m.getMetadata().getVersion().getFriendlyString()).orElse("?UNKNOWN?");
            Object s = "Minecraft " + class_155.method_16673().getName() + " (" + this.field_22787.method_1515() + "/" + ClientBrandRetriever.getClientModName() + ") " + modVer;
            this.field_22793.method_1729(matrixStack, (String)s, (float)(this.field_22789 - this.field_22793.method_1727((String)s) - 4), 2.0f, -16777216);
            s = this.field_22787.field_1770;
            this.field_22793.method_1729(matrixStack, (String)s, (float)(this.field_22789 - this.field_22793.method_1727((String)s) - 4), 11.0f, -16777216);
            this.matrixStack = null;
            matrixStack.method_22909();
        }
        if (this.field_22787.field_1724 != null && this.gui.enableChat()) {
            matrixStack.method_22903();
            matrixStack.method_22904(0.0, (double)(this.field_22787.method_22683().method_4502() - 48), 800.0);
            this.field_22787.field_1705.method_1743().method_1805(matrixStack, this.field_22787.field_1705.method_1738());
            matrixStack.method_22909();
        }
    }

    public void method_25432() {
        this.field_22787.field_1774.method_1462(false);
        if (this.vanillaScale >= 0 && this.vanillaScale != this.field_22787.field_1690.field_1868) {
            this.field_22787.field_1690.field_1868 = this.vanillaScale;
            this.vanillaScale = -999;
            this.field_22787.method_15993();
        }
    }

    public void method_25419() {
        class_437 p = this.parent;
        this.parent = null;
        this.field_22787.method_1507(p);
    }

    public boolean method_25421() {
        return false;
    }

    @Override
    public void drawBox(int x, int y, int w, int h, int color) {
        GuiImpl.method_25294((class_4587)this.matrixStack, (int)(x += this.getOffset().x), (int)(y += this.getOffset().y), (int)(x + w), (int)(y + h), (int)color);
    }

    protected void method_25426() {
        this.field_22787.field_1774.method_1462(true);
        try {
            this.gui.init(this.field_22789, this.field_22790);
        }
        catch (Throwable e) {
            this.onGuiException("Error in init gui", e, true);
        }
    }

    @Override
    public void drawText(int x, int y, String text, int color) {
        this.matrixStack.method_22903();
        this.matrixStack.method_22904(0.0, 0.0, 50.0);
        this.field_22793.method_1729(this.matrixStack, text, (float)(x += this.getOffset().x), (float)(y += this.getOffset().y), color);
        this.matrixStack.method_22909();
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        try {
            this.keyModif = modifiers;
            KeyboardEvent evt = new KeyboardEvent(keyCode, scanCode, '\uffff', GLFW.glfwGetKeyName((int)keyCode, (int)scanCode));
            this.gui.keyPressed(evt);
            if (!evt.isConsumed() && this.field_22787.field_1724 != null && this.field_22787.field_1690.field_1890.method_1417(keyCode, scanCode) && this.field_22787.field_1690.field_1877 != class_1659.field_7536) {
                RenderSystem.recordRenderCall(() -> {
                    int scale = this.vanillaScale;
                    this.vanillaScale = -1;
                    this.field_22787.method_1507((class_437)new Overlay());
                    this.vanillaScale = scale;
                });
                return true;
            }
            return true;
        }
        catch (Throwable e) {
            this.onGuiException("Error processing key event", e, false);
            return true;
        }
    }

    public boolean method_25400(char codePoint, int modifiers) {
        try {
            this.keyModif = modifiers;
            KeyboardEvent evt = new KeyboardEvent(-1, -1, codePoint, null);
            this.gui.keyPressed(evt);
            return evt.isConsumed();
        }
        catch (Throwable e) {
            this.onGuiException("Error processing key event", e, false);
            return true;
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        try {
            MouseEvent evt = new MouseEvent((int)mouseX, (int)mouseY, button);
            this.gui.mouseClick(evt);
            return evt.isConsumed();
        }
        catch (Throwable e) {
            this.onGuiException("Error processing mouse event", e, false);
            return true;
        }
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        try {
            MouseEvent evt = new MouseEvent((int)mouseX, (int)mouseY, button);
            this.gui.mouseDrag(evt);
            return evt.isConsumed();
        }
        catch (Throwable e) {
            this.onGuiException("Error processing mouse event", e, false);
            return true;
        }
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        try {
            MouseEvent evt = new MouseEvent((int)mouseX, (int)mouseY, button);
            this.gui.mouseRelease(evt);
            return evt.isConsumed();
        }
        catch (Throwable e) {
            this.onGuiException("Error processing mouse event", e, false);
            return true;
        }
    }

    public boolean method_25401(double mouseX, double mouseY, double delta) {
        if (delta != 0.0) {
            try {
                MouseEvent evt = new MouseEvent((int)mouseX, (int)mouseY, (int)delta);
                this.gui.mouseWheel(evt);
                return evt.isConsumed();
            }
            catch (Throwable e) {
                this.onGuiException("Error processing mouse event", e, false);
                return true;
            }
        }
        return false;
    }

    public void method_29638(List<Path> filesIn) {
        try {
            this.gui.filesDropped(filesIn.stream().map(Path::toFile).filter(File::exists).collect(Collectors.toList()));
        }
        catch (Throwable e) {
            this.onGuiException("Error processing mouse event", e, false);
        }
    }

    @Override
    public void displayError(String e) {
        class_437 p = this.parent;
        this.parent = null;
        class_310.method_1551().method_1507((class_437)new class_419(p, (class_2561)new class_2585("Custom Player Models"), (class_2561)new class_2588("error.cpm.crash", new Object[]{e})));
    }

    @Override
    public void close() {
        if (this.closeListener != null) {
            this.closeListener.accept(this::method_25419);
        } else {
            this.method_25419();
        }
    }

    @Override
    public void drawTexture(int x, int y, int w, int h, int u, int v, String texture) {
        x += this.getOffset().x;
        y += this.getOffset().y;
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (class_2960)new class_2960("cpm", "textures/gui/" + texture + ".png"));
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        this.method_25302(this.matrixStack, x, y, u, v, w, h);
        RenderSystem.disableBlend();
    }

    @Override
    public void drawTexture(int x, int y, int w, int h, int u, int v, String texture, int color) {
        x += this.getOffset().x;
        y += this.getOffset().y;
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)a);
        RenderSystem.setShaderTexture((int)0, (class_2960)new class_2960("cpm", "textures/gui/" + texture + ".png"));
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        this.method_25302(this.matrixStack, x, y, u, v, w, h);
        RenderSystem.disableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    public void drawTexture(int x, int y, int width, int height, float u1, float v1, float u2, float v2) {
        x += this.getOffset().x;
        y += this.getOffset().y;
        RenderSystem.setShaderTexture((int)0, (class_2960)MinecraftObject.DynTexture.getBoundLoc());
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        class_1159 mat = this.matrixStack.method_23760().method_23761();
        float bo = this.method_25305();
        class_289 tessellator = class_289.method_1348();
        class_287 bufferbuilder = tessellator.method_1349();
        bufferbuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
        bufferbuilder.method_22918(mat, (float)x, (float)(y + height), bo).method_22913(u1, v2).method_1344();
        bufferbuilder.method_22918(mat, (float)(x + width), (float)(y + height), bo).method_22913(u2, v2).method_1344();
        bufferbuilder.method_22918(mat, (float)(x + width), (float)y, bo).method_22913(u2, v1).method_1344();
        bufferbuilder.method_22918(mat, (float)x, (float)y, bo).method_22913(u1, v1).method_1344();
        bufferbuilder.method_1326();
        class_286.method_1309((class_287)bufferbuilder);
        RenderSystem.disableBlend();
    }

    @Override
    public String i18nFormat(String key, Object ... obj) {
        return class_1074.method_4662((String)key, (Object[])obj);
    }

    @Override
    public void setupCut() {
        int dw = this.field_22787.method_22683().method_4480();
        int dh = this.field_22787.method_22683().method_4507();
        float multiplierX = (float)dw / (float)this.field_22789;
        float multiplierY = (float)dh / (float)this.field_22790;
        Box box = this.getContext().cutBox;
        RenderSystem.enableScissor((int)((int)((float)box.x * multiplierX)), (int)(dh - (int)((float)(box.y + box.h) * multiplierY)), (int)((int)((float)box.w * multiplierX)), (int)((int)((float)box.h * multiplierY)));
    }

    @Override
    public int textWidth(String text) {
        return this.field_22793.method_1727(text);
    }

    private TextField.ITextField createTextField() {
        return new TxtField();
    }

    @Override
    public UIColors getColors() {
        return this.colors;
    }

    @Override
    public void setCloseListener(Consumer<Runnable> listener) {
        this.closeListener = listener;
    }

    @Override
    public boolean isShiftDown() {
        return GuiImpl.method_25442();
    }

    @Override
    public boolean isCtrlDown() {
        return GuiImpl.method_25441();
    }

    @Override
    public boolean isAltDown() {
        return GuiImpl.method_25443();
    }

    @Override
    public KeyCodes getKeyCodes() {
        return CODES;
    }

    @Override
    public void drawGradientBox(int x, int y, int w, int h, int topLeft, int topRight, int bottomLeft, int bottomRight) {
        int left = x += this.getOffset().x;
        int top = y += this.getOffset().y;
        int right = x + w;
        int bottom = y + h;
        float atr = (float)(topRight >> 24 & 0xFF) / 255.0f;
        float rtr = (float)(topRight >> 16 & 0xFF) / 255.0f;
        float gtr = (float)(topRight >> 8 & 0xFF) / 255.0f;
        float btr = (float)(topRight & 0xFF) / 255.0f;
        float atl = (float)(topLeft >> 24 & 0xFF) / 255.0f;
        float rtl = (float)(topLeft >> 16 & 0xFF) / 255.0f;
        float gtl = (float)(topLeft >> 8 & 0xFF) / 255.0f;
        float btl = (float)(topLeft & 0xFF) / 255.0f;
        float abl = (float)(bottomLeft >> 24 & 0xFF) / 255.0f;
        float rbl = (float)(bottomLeft >> 16 & 0xFF) / 255.0f;
        float gbl = (float)(bottomLeft >> 8 & 0xFF) / 255.0f;
        float bbl = (float)(bottomLeft & 0xFF) / 255.0f;
        float abr = (float)(bottomRight >> 24 & 0xFF) / 255.0f;
        float rbr = (float)(bottomRight >> 16 & 0xFF) / 255.0f;
        float gbr = (float)(bottomRight >> 8 & 0xFF) / 255.0f;
        float bbr = (float)(bottomRight & 0xFF) / 255.0f;
        RenderSystem.disableTexture();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(class_757::method_34540);
        class_289 tessellator = class_289.method_1348();
        class_287 bufferbuilder = tessellator.method_1349();
        class_1159 mat = this.matrixStack.method_23760().method_23761();
        bufferbuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        bufferbuilder.method_22918(mat, (float)right, (float)top, (float)this.method_25305()).method_22915(rtr, gtr, btr, atr).method_1344();
        bufferbuilder.method_22918(mat, (float)left, (float)top, (float)this.method_25305()).method_22915(rtl, gtl, btl, atl).method_1344();
        bufferbuilder.method_22918(mat, (float)left, (float)bottom, (float)this.method_25305()).method_22915(rbl, gbl, bbl, abl).method_1344();
        bufferbuilder.method_22918(mat, (float)right, (float)bottom, (float)this.method_25305()).method_22915(rbr, gbr, bbr, abr).method_1344();
        tessellator.method_1350();
        RenderSystem.disableBlend();
        RenderSystem.enableTexture();
    }

    @Override
    public NativeGuiComponents getNative() {
        return nativeComponents;
    }

    @Override
    public void setClipboardText(String text) {
        this.field_22787.field_1774.method_1455(text);
    }

    @Override
    public Frame getFrame() {
        return this.gui;
    }

    @Override
    public String getClipboardText() {
        return this.field_22787.field_1774.method_1460();
    }

    @Override
    public void setScale(int value) {
        if (this.vanillaScale == -999) {
            return;
        }
        if (value != this.field_22787.field_1690.field_1868) {
            if (this.vanillaScale == -1) {
                this.vanillaScale = this.field_22787.field_1690.field_1868;
            }
            if (value == -1) {
                if (this.field_22787.field_1690.field_1868 != this.vanillaScale) {
                    this.field_22787.field_1690.field_1868 = this.vanillaScale;
                    this.vanillaScale = -1;
                    this.field_22787.method_15993();
                }
            } else {
                this.field_22787.field_1690.field_1868 = value;
                this.field_22787.method_15993();
            }
        }
    }

    @Override
    public int getScale() {
        return this.field_22787.field_1690.field_1868;
    }

    @Override
    public int getMaxScale() {
        return this.field_22787.method_22683().method_4476(0, this.field_22787.method_1573()) + 1;
    }

    @Override
    public IGui.CtxStack getStack() {
        return this.stack;
    }

    public void method_25393() {
        try {
            this.gui.tick();
        }
        catch (Throwable e) {
            this.onGuiException("Error in tick gui", e, true);
        }
    }

    @Override
    public void drawFormattedText(float x, float y, IText text, int color, float scale) {
        this.matrixStack.method_22903();
        this.matrixStack.method_22904((double)(x += (float)this.getOffset().x), (double)(y += (float)this.getOffset().y), 50.0);
        this.matrixStack.method_22905(scale, scale, scale);
        this.field_22793.method_30883(this.matrixStack, (class_2561)text.remap(), 0.0f, 0.0f, color);
        this.matrixStack.method_22909();
    }

    @Override
    public int textWidthFormatted(IText text) {
        return this.field_22793.method_30880(((class_2561)text.remap()).method_30937());
    }

    @Override
    public void openURL0(String url) {
        class_156.method_668().method_670(url);
    }

    static {
        nativeComponents.register(TextField.class, GuiImpl.local(GuiImpl::createTextField));
        nativeComponents.register(FileChooserPopup.class, TinyFDChooser::new);
        nativeComponents.register(Panel3d.class, Panel3dImpl::new);
    }

    private class TxtField
    implements TextField.ITextField,
    Consumer<String> {
        private class_342 field;
        private Runnable eventListener;
        private Vec2i currentOff = new Vec2i(0, 0);
        private Box bounds = new Box(0, 0, 0, 0);
        private boolean settingText;
        private boolean updateField;

        public TxtField() {
            this.field = new class_342(GuiImpl.this.field_22793, 0, 0, 0, 0, (class_2561)new class_2588("narrator.cpm.field"));
            this.field.method_1880(0x100000);
            this.field.method_1858(false);
            this.field.method_1862(true);
            this.field.method_1868(0xFFFFFF);
            this.field.method_1863((Consumer)this);
        }

        @Override
        public void draw(int mouseX, int mouseY, float partialTicks, Box bounds) {
            Vec2i off = GuiImpl.this.getOffset();
            this.field.field_22760 = bounds.x + off.x + 4;
            this.field.field_22761 = bounds.y + off.y + 6;
            this.currentOff.x = off.x;
            this.currentOff.y = off.y;
            this.bounds.x = bounds.x;
            this.bounds.y = bounds.y;
            this.bounds.w = bounds.w;
            this.bounds.h = bounds.h;
            this.field.method_25358(bounds.w - 5);
            this.field.field_22759 = bounds.h - 12;
            if (this.updateField) {
                this.settingText = true;
                this.field.method_1872();
                this.updateField = false;
                this.settingText = false;
            }
            this.field.method_25394(GuiImpl.this.matrixStack, mouseX, mouseY, partialTicks);
        }

        @Override
        public void keyPressed(KeyboardEvent evt) {
            if (evt.isConsumed()) {
                return;
            }
            if (evt.keyCode == -1) {
                if (this.field.method_25400(evt.charTyped, GuiImpl.this.keyModif)) {
                    evt.consume();
                }
            } else if (this.field.method_25404(evt.keyCode, evt.scancode, GuiImpl.this.keyModif) || this.field.method_20315()) {
                evt.consume();
            }
        }

        @Override
        public void mouseClick(MouseEvent evt) {
            if (evt.isConsumed()) {
                this.field.method_25402(-2.147483648E9, -2.147483648E9, evt.btn);
                return;
            }
            this.field.field_22760 = this.bounds.x + this.currentOff.x;
            this.field.field_22761 = this.bounds.y + this.currentOff.y;
            this.field.method_25358(this.bounds.w);
            this.field.field_22759 = this.bounds.h;
            if (this.field.method_25402((double)(evt.x + this.currentOff.x), (double)(evt.y + this.currentOff.y), evt.btn)) {
                evt.consume();
            }
        }

        @Override
        public String getText() {
            return this.field.method_1882();
        }

        @Override
        public void setText(String txt) {
            this.settingText = true;
            this.field.method_1852(txt);
            this.settingText = false;
            this.updateField = true;
        }

        @Override
        public void setEventListener(Runnable eventListener) {
            this.eventListener = eventListener;
        }

        @Override
        public void accept(String value) {
            if (this.eventListener != null && !this.settingText) {
                this.eventListener.run();
            }
        }

        @Override
        public void setEnabled(boolean enabled) {
            this.field.method_1888(enabled);
        }

        @Override
        public boolean isFocused() {
            return this.field.method_25370();
        }

        @Override
        public void setFocused(boolean focused) {
            this.field.method_1876(focused);
        }

        @Override
        public int getCursorPos() {
            return this.field.method_1881();
        }

        @Override
        public void setCursorPos(int pos) {
            this.field.method_1883(pos);
        }

        @Override
        public void setSelectionPos(int pos) {
            this.field.method_1884(pos);
        }

        @Override
        public int getSelectionPos() {
            return this.field.field_2101;
        }
    }

    public class Overlay
    extends class_408 {
        public Overlay() {
            super("");
        }

        public void method_25394(class_4587 st, int mouseX, int mouseY, float partialTicks) {
            GuiImpl.this.method_25394(st, Integer.MIN_VALUE, Integer.MIN_VALUE, partialTicks);
            super.method_25394(st, mouseX, mouseY, partialTicks);
        }

        public class_437 getGui() {
            return GuiImpl.this;
        }
    }
}

