/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.api;

import com.tom.cpm.api.CPMApiManager;
import com.tom.cpm.api.ICPMPlugin;
import com.tom.cpm.api.ICommonAPI;
import com.tom.cpm.api.SharedApi;
import com.tom.cpm.shared.MinecraftServerAccess;
import com.tom.cpm.shared.io.ModelFile;
import com.tom.cpm.shared.network.NetHandler;

public class CommonApi
extends SharedApi
implements ICommonAPI {
    @Override
    protected void callInit0(ICPMPlugin plugin) {
        plugin.initCommon(this);
    }

    protected CommonApi() {
    }

    @Override
    public <P> void setPlayerModel(Class<P> playerClass, P player, String b64, boolean forced, boolean persistent) {
        if (this.checkClass(playerClass, SharedApi.Clazz.PLAYER)) {
            return;
        }
        NetHandler<?, ?, ?> h = MinecraftServerAccess.get().getNetHandler();
        h.setSkin(player, b64, forced, persistent);
    }

    @Override
    public <P> void setPlayerModel(Class<P> playerClass, P player, ModelFile model, boolean forced) {
        if (this.checkClass(playerClass, SharedApi.Clazz.PLAYER)) {
            return;
        }
        NetHandler<?, ?, ?> h = MinecraftServerAccess.get().getNetHandler();
        h.setSkin(player, model.getDataBlock(), forced);
    }

    @Override
    public <P> void resetPlayerModel(Class<P> playerClass, P player) {
        if (this.checkClass(playerClass, SharedApi.Clazz.PLAYER)) {
            return;
        }
        NetHandler<?, ?, ?> h = MinecraftServerAccess.get().getNetHandler();
        h.setSkin(player, null, false, true);
    }

    @Override
    public <P> void playerJumped(Class<P> playerClass, P player) {
        if (this.checkClass(playerClass, SharedApi.Clazz.PLAYER)) {
            return;
        }
        NetHandler<?, ?, ?> h = MinecraftServerAccess.get().getNetHandler();
        h.onJump(player);
    }

    public static class ApiBuilder {
        private final CPMApiManager api;

        protected ApiBuilder(CPMApiManager api) {
            this.api = api;
            api.common = new CommonApi();
        }

        public ApiBuilder player(Class<?> player) {
            this.api.common.classes.put(SharedApi.Clazz.PLAYER, player);
            return this;
        }

        public void init() {
            this.api.initCommon();
        }
    }
}

