/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm;

import com.mojang.brigadier.CommandDispatcher;
import com.tom.cpl.config.ModConfigFile;
import com.tom.cpl.text.TextRemapper;
import com.tom.cpl.text.TextStyle;
import com.tom.cpl.util.ILogger;
import com.tom.cpm.Log4JLogger;
import com.tom.cpm.MinecraftServerObject;
import com.tom.cpm.api.CPMApiManager;
import com.tom.cpm.api.ICPMPlugin;
import com.tom.cpm.common.Command;
import com.tom.cpm.common.ServerHandler;
import com.tom.cpm.shared.MinecraftCommonAccess;
import com.tom.cpm.shared.MinecraftObjectHolder;
import com.tom.cpm.shared.PlatformFeature;
import com.tom.cpm.shared.config.ModConfig;
import com.tom.cpm.shared.util.IVersionCheck;
import com.tom.cpm.shared.util.VersionCheck;
import java.io.File;
import java.util.EnumSet;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v1.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.networking.v1.EntityTrackingEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.minecraft.class_155;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2572;
import net.minecraft.class_2583;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_5250;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CustomPlayerModels
implements MinecraftCommonAccess,
ModInitializer {
    private ModConfigFile config;
    public static final Logger LOG = LogManager.getLogger((String)"CPM");
    public static final ILogger log = new Log4JLogger(LOG);
    public static CPMApiManager api;
    private static final EnumSet<PlatformFeature> features;

    public void onInitialize() {
        api = new CPMApiManager();
        this.config = new ModConfigFile(new File(FabricLoader.getInstance().getConfigDir().toFile(), "cpm.json"));
        MinecraftObjectHolder.setCommonObject(this);
        ServerLifecycleEvents.SERVER_STARTED.register(s -> MinecraftObjectHolder.setServerObject(new MinecraftServerObject(s)));
        ServerLifecycleEvents.SERVER_STOPPING.register(s -> {
            ModConfig.getWorldConfig().save();
            MinecraftObjectHolder.setServerObject(null);
        });
        ServerTickEvents.END_SERVER_TICK.register(s -> ServerHandler.netHandler.tick());
        CommandRegistrationCallback.EVENT.register((d, isD) -> new Command((CommandDispatcher<class_2168>)d));
        EntityTrackingEvents.START_TRACKING.register(ServerHandler::onTrackingStart);
        FabricLoader.getInstance().getEntrypointContainers("cpmapi", ICPMPlugin.class).forEach(entrypoint -> {
            ModMetadata metadata = entrypoint.getProvider().getMetadata();
            String modId = metadata.getId();
            try {
                ICPMPlugin plugin = (ICPMPlugin)entrypoint.getEntrypoint();
                api.register(plugin);
            }
            catch (Throwable e) {
                LOG.error("Mod {} provides a broken implementation of CPM api", (Object)modId, (Object)e);
            }
        });
        LOG.info("Customizable Player Models Initialized");
        LOG.info(api.getPluginStatus());
        api.buildCommon().player(class_1657.class).init();
    }

    @Override
    public ModConfigFile getConfig() {
        return this.config;
    }

    @Override
    public ILogger getLogger() {
        return log;
    }

    @Override
    public EnumSet<PlatformFeature> getSupportedFeatures() {
        return features;
    }

    @Override
    public String getMCVersion() {
        return class_155.method_16673().getName();
    }

    @Override
    public String getMCBrand() {
        String fVer = FabricLoader.getInstance().getModContainer("fabric").map(m -> m.getMetadata().getVersion().getFriendlyString()).orElse("?UNKNOWN?");
        String lVer = FabricLoader.getInstance().getModContainer("fabricloader").map(m -> m.getMetadata().getVersion().getFriendlyString()).orElse("?UNKNOWN?");
        return "(fabric/" + lVer + "/" + fVer + ")";
    }

    @Override
    public String getModVersion() {
        return FabricLoader.getInstance().getModContainer("cpm").map(m -> m.getMetadata().getVersion().getFriendlyString()).orElse("?UNKNOWN?");
    }

    public TextRemapper<class_5250> getTextRemapper() {
        return new TextRemapper<class_5250>(class_2588::new, class_2585::new, class_5250::method_10852, class_2572::new, CustomPlayerModels::styleText);
    }

    private static class_5250 styleText(class_5250 in, TextStyle style) {
        return in.method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(style.bold)).method_10978(Boolean.valueOf(style.italic)).method_30938(Boolean.valueOf(style.underline)).method_36140(Boolean.valueOf(style.strikethrough)));
    }

    @Override
    public CPMApiManager getApi() {
        return api;
    }

    @Override
    public IVersionCheck getVersionCheck() {
        return VersionCheck.get(this.getMCVersion() + "-fabric", this.getModVersion());
    }

    static {
        features = EnumSet.of(PlatformFeature.EDITOR_HELD_ITEM, PlatformFeature.EDITOR_SUPPORTED);
    }
}

