/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpl.util;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;

public class NamedElement<T> {
    private T elem;
    private Function<T, String> tostring;

    public NamedElement(T elem, Function<T, String> tostring) {
        this.elem = elem;
        this.tostring = tostring;
    }

    public T getElem() {
        return this.elem;
    }

    public String toString() {
        return this.tostring.apply(this.elem);
    }

    public static class NameMapper<T> {
        private List<NamedElement<T>> list;
        private Map<T, NamedElement<T>> elems = new HashMap<T, NamedElement<T>>();
        private Consumer<NamedElement<T>> setter;

        public NameMapper(Iterable<T> in, Function<T, String> tostring) {
            this.list = new ArrayList<NamedElement<T>>();
            for (T t : in) {
                NamedElement<T> e = new NamedElement<T>(t, tostring);
                this.elems.put(t, e);
                this.list.add(e);
            }
        }

        public NameMapper(T[] in, Function<T, String> tostring) {
            this.list = new ArrayList<NamedElement<T>>();
            for (T t : in) {
                NamedElement<T> e = new NamedElement<T>(t, tostring);
                this.elems.put(t, e);
                this.list.add(e);
            }
        }

        public List<NamedElement<T>> asList() {
            return this.list;
        }

        public NamedElement<T> get(T v) {
            return this.elems.get(v);
        }

        public void setSetter(Consumer<NamedElement<T>> setter) {
            this.setter = setter;
        }

        public void setValue(T t) {
            this.setter.accept(this.get(t));
        }

        public void sort(Comparator<? super NamedElement<T>> c) {
            this.list.sort(c);
        }
    }
}

