/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpl.render;

import com.tom.cpl.math.Mat3f;
import com.tom.cpl.math.Mat4f;
import com.tom.cpl.math.MatrixStack;
import com.tom.cpl.math.Vec3f;
import com.tom.cpl.math.Vec4f;

public interface VertexBuffer {
    public VertexBuffer pos(float var1, float var2, float var3);

    public VertexBuffer tex(float var1, float var2);

    public VertexBuffer color(float var1, float var2, float var3, float var4);

    public VertexBuffer normal(float var1, float var2, float var3);

    public void endVertex();

    default public void addVertex(float x, float y, float z, float red, float green, float blue, float alpha, float texU, float texV, float normalX, float normalY, float normalZ) {
        this.pos(x, y, z);
        this.color(red, green, blue, alpha);
        this.tex(texU, texV);
        this.normal(normalX, normalY, normalZ);
        this.endVertex();
    }

    default public void addVertex(MatrixStack.Entry mat, float x, float y, float z, float red, float green, float blue, float alpha, float texU, float texV, float normalX, float normalY, float normalZ) {
        this.pos(mat.getMatrix(), x, y, z);
        this.color(red, green, blue, alpha);
        this.tex(texU, texV);
        this.normal(mat.getNormal(), normalX, normalY, normalZ);
        this.endVertex();
    }

    default public VertexBuffer pos(Mat4f matrixIn, float x, float y, float z) {
        Vec4f vector4f = new Vec4f(x, y, z, 1.0f);
        vector4f.transform(matrixIn);
        return this.pos(vector4f.x, vector4f.y, vector4f.z);
    }

    default public VertexBuffer normal(Mat3f matrix, float x, float y, float z) {
        Vec3f vec3f = new Vec3f(x, y, z);
        vec3f.transform(matrix);
        return this.normal(vec3f.x, vec3f.y, vec3f.z);
    }

    public void finish();
}

