/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpl.nbt;

import com.tom.cpl.nbt.NBTTagByte;
import com.tom.cpl.nbt.NBTTagByteArray;
import com.tom.cpl.nbt.NBTTagCompound;
import com.tom.cpl.nbt.NBTTagDouble;
import com.tom.cpl.nbt.NBTTagEnd;
import com.tom.cpl.nbt.NBTTagFloat;
import com.tom.cpl.nbt.NBTTagInt;
import com.tom.cpl.nbt.NBTTagIntArray;
import com.tom.cpl.nbt.NBTTagList;
import com.tom.cpl.nbt.NBTTagLong;
import com.tom.cpl.nbt.NBTTagShort;
import com.tom.cpl.nbt.NBTTagString;
import com.tom.cpm.shared.io.IOHelper;
import java.io.IOException;

public abstract class NBTTag {
    public static final int TAG_END = 0;
    public static final int TAG_BYTE = 1;
    public static final int TAG_SHORT = 2;
    public static final int TAG_INT = 3;
    public static final int TAG_LONG = 4;
    public static final int TAG_FLOAT = 5;
    public static final int TAG_DOUBLE = 6;
    public static final int TAG_BYTE_ARRAY = 7;
    public static final int TAG_STRING = 8;
    public static final int TAG_LIST = 9;
    public static final int TAG_COMPOUND = 10;
    public static final int TAG_INT_ARRAY = 11;
    public static final int TAG_ANY_NUMERIC = 99;

    public abstract byte getId();

    public abstract void write(IOHelper var1) throws IOException;

    public abstract void read(IOHelper var1) throws IOException;

    public abstract NBTTag copy();

    public int hashCode() {
        return this.getId();
    }

    public boolean equals(Object other) {
        if (!(other instanceof NBTTag)) {
            return false;
        }
        NBTTag nbtbase = (NBTTag)other;
        return this.getId() == nbtbase.getId();
    }

    protected String getString() {
        return this.toString();
    }

    public static NBTTag createNewByType(byte id) {
        switch (id) {
            case 0: {
                return new NBTTagEnd();
            }
            case 1: {
                return new NBTTagByte();
            }
            case 2: {
                return new NBTTagShort();
            }
            case 3: {
                return new NBTTagInt();
            }
            case 4: {
                return new NBTTagLong();
            }
            case 5: {
                return new NBTTagFloat();
            }
            case 6: {
                return new NBTTagDouble();
            }
            case 7: {
                return new NBTTagByteArray();
            }
            case 8: {
                return new NBTTagString();
            }
            case 9: {
                return new NBTTagList();
            }
            case 10: {
                return new NBTTagCompound();
            }
            case 11: {
                return new NBTTagIntArray();
            }
        }
        return null;
    }

    public static abstract class NBTPrimitive
    extends NBTTag {
        public abstract long getLong();

        public abstract int getInt();

        public abstract short getShort();

        public abstract byte getByte();

        public abstract double getDouble();

        public abstract float getFloat();
    }
}

