/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpl.gui.elements;

import com.tom.cpl.gui.Frame;
import com.tom.cpl.gui.MouseEvent;
import com.tom.cpl.gui.elements.GuiElement;
import com.tom.cpl.gui.elements.Tooltip;
import com.tom.cpl.math.Box;
import com.tom.cpl.math.Vec2i;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public class Tree<T>
extends GuiElement {
    private Map<Integer, TreeHandler.TreeElement<T>> map = new HashMap<Integer, TreeHandler.TreeElement<T>>();
    private TreeHandler<T> handler;
    private Frame frame;
    private Consumer<Vec2i> sizeUpdate;

    public Tree(Frame gui, TreeModel<T> model) {
        super(gui.getGui());
        this.frame = gui;
        this.handler = new TreeHandler<T>(model);
    }

    public Tree(Frame gui, TreeHandler<T> handler) {
        super(gui.getGui());
        this.frame = gui;
        this.handler = handler;
    }

    @Override
    public void mouseClick(MouseEvent evt) {
        if (evt.isConsumed()) {
            return;
        }
        if (this.bounds.isInBounds(evt.x, evt.y)) {
            int yp = (evt.y - this.bounds.y) / 10;
            TreeHandler.TreeElement<T> elem = this.map.get(yp);
            if (elem != null) {
                if (evt.btn == 0 && evt.x < 5 + elem.depth * 5 && elem != this.handler.root && !elem.children.isEmpty()) {
                    boolean bl = elem.showChildren = !elem.showChildren;
                    if (this.sizeUpdate != null) {
                        this.sizeUpdate.accept(this.getSize());
                    }
                } else {
                    this.handler.model.onClick(evt, elem.value);
                }
            } else {
                this.handler.model.onClick(evt, null);
            }
            this.handler.model.treeUpdated();
            evt.consume();
        }
    }

    public Vec2i getSize() {
        int[] s = new int[2];
        this.walk(s, this.handler.root, 0);
        return new Vec2i(s[0], s[1] * 10);
    }

    private void walk(int[] s, TreeHandler.TreeElement<T> e, int layer) {
        s[1] = s[1] + 1;
        s[0] = Math.max(s[0], layer * 5 + this.gui.textWidth(e.display) + 5);
        if (e.showChildren) {
            for (TreeHandler.TreeElement i : e.children) {
                this.walk(s, i, layer + 1);
            }
        }
    }

    @Override
    public void draw(MouseEvent event, float partialTicks) {
        this.map.clear();
        this.drawTree(event, 0, new int[1], this.handler.root);
    }

    private void drawTree(MouseEvent event, int x, int[] y, TreeHandler.TreeElement<T> e) {
        int txtc;
        int bg;
        int n = y[0];
        y[0] = n + 1;
        int yp = n;
        int textColor = this.gui.getColors().button_text_color;
        int n2 = bg = e.value == null ? 0 : this.handler.model.bgColor(e.value);
        if (bg != 0) {
            this.gui.drawBox(x * 5, yp * 10, this.bounds.w, 10, bg);
        }
        int n3 = txtc = e.value == null ? 0 : this.handler.model.textColor(e.value);
        if (txtc != 0) {
            textColor = txtc;
        }
        int dropD = textColor;
        if (event.isHovered(new Box(this.bounds.x, yp * 10, this.bounds.w, 10))) {
            textColor = this.gui.getColors().button_text_hover;
            Tooltip tt = this.handler.model.getTooltip(e.value);
            if (tt != null) {
                tt.set();
            }
            if (event.isHovered(new Box(this.bounds.x, yp * 10, 5 + e.depth * 5, 10))) {
                dropD = textColor;
            }
        }
        this.map.put(yp, e);
        this.gui.drawText(x * 5 + 3, yp * 10, e.display, textColor);
        e.depth = x;
        if (e.showChildren) {
            if (e != this.handler.root && !e.children.isEmpty()) {
                this.gui.drawTexture(x * 5 - 5, yp * 10, 8, 8, 24, 8, "editor", dropD);
            }
            for (TreeHandler.TreeElement i : e.children) {
                this.drawTree(event, x + 1, y, i);
            }
        } else if (e != this.handler.root && !e.children.isEmpty()) {
            this.gui.drawTexture(x * 5 - 5, yp * 10, 8, 8, 24, 0, "editor", dropD);
        }
    }

    public void updateTree() {
        this.walk(this.handler.root);
        if (this.sizeUpdate != null) {
            this.sizeUpdate.accept(this.getSize());
        }
    }

    private boolean walk(TreeHandler.TreeElement<T> e) {
        boolean r = this.handler.model.isSelected(e.value);
        for (TreeHandler.TreeElement i : e.children) {
            boolean w = this.walk(i);
            e.showChildren |= w;
            r |= w;
        }
        return r;
    }

    public void setSizeUpdate(Consumer<Vec2i> sizeUpdate) {
        this.sizeUpdate = sizeUpdate;
    }

    private TreeHandler.TreeElement<T> find(T elem) {
        return this.handler.find(Collections.singletonList(this.handler.root), elem);
    }

    private TreeHandler.TreeElement<T> findParent(TreeHandler.TreeElement<T> elem) {
        if (elem == null) {
            return null;
        }
        return this.walk(this.handler.root, elem);
    }

    private TreeHandler.TreeElement<T> walk(TreeHandler.TreeElement<T> e, TreeHandler.TreeElement<T> toFind) {
        for (TreeHandler.TreeElement i : e.children) {
            if (i == toFind) {
                return e;
            }
            TreeHandler.TreeElement d = this.walk(i, toFind);
            if (d == null) continue;
            return d;
        }
        return null;
    }

    public T findUp(T curr) {
        TreeHandler.TreeElement<T> p = this.findParent(this.find(curr));
        if (p != null) {
            return p.value;
        }
        return curr;
    }

    public T findDown(T curr) {
        TreeHandler.TreeElement<T> p = this.find(curr);
        if (p != null && !p.children.isEmpty()) {
            return p.children.get((int)0).value;
        }
        return curr;
    }

    public T findNext(T curr) {
        int i;
        TreeHandler.TreeElement<T> c = this.find(curr);
        TreeHandler.TreeElement<T> p = this.findParent(c);
        if (c != null && p != null && (i = p.children.indexOf(c)) != -1 && i + 1 < p.children.size()) {
            return p.children.get((int)(i + 1)).value;
        }
        return curr;
    }

    public T findPrev(T curr) {
        int i;
        TreeHandler.TreeElement<T> c = this.find(curr);
        TreeHandler.TreeElement<T> p = this.findParent(c);
        if (c != null && p != null && (i = p.children.indexOf(c)) > 0) {
            return p.children.get((int)(i - 1)).value;
        }
        return curr;
    }

    public static class TreeHandler<T> {
        private TreeModel<T> model;
        private TreeElement<T> root = new TreeElement();

        public TreeHandler(TreeModel<T> model) {
            this.root.display = "Root";
            this.model = model;
        }

        public void update() {
            ArrayList old = new ArrayList(this.root.children);
            this.root.children.clear();
            this.root.showChildren = true;
            this.model.getElements(null, e -> {
                TreeElement t = new TreeElement();
                t.display = this.model.getName(e);
                t.value = e;
                TreeElement<Object> oldTree = this.find(old, e);
                if (oldTree != null) {
                    t.showChildren = oldTree.showChildren;
                }
                this.root.children.add(t);
                this.model.refresh(e);
                this.walkChildren(t, oldTree != null ? oldTree.children : null);
            });
        }

        private TreeElement<T> find(List<TreeElement<T>> list, T elem) {
            for (TreeElement<T> e : list) {
                if (e.value == elem) {
                    return e;
                }
                TreeElement d = this.find(e.children, elem);
                if (d == null) continue;
                return d;
            }
            return null;
        }

        private void walkChildren(TreeElement<T> p, List<TreeElement<T>> old) {
            this.model.getElements(p.value, e -> {
                TreeElement t = new TreeElement();
                t.display = this.model.getName(e);
                t.value = e;
                p.children.add(t);
                TreeElement<Object> oldTree = null;
                if (old != null) {
                    oldTree = this.find(old, e);
                }
                if (oldTree != null) {
                    t.showChildren = oldTree.showChildren;
                }
                this.walkChildren(t, oldTree != null ? oldTree.children : null);
            });
        }

        public TreeModel<T> getModel() {
            return this.model;
        }

        public static class TreeElement<T> {
            private String display;
            private T value;
            private List<TreeElement<T>> children = new ArrayList<TreeElement<T>>();
            private boolean showChildren;
            private int depth;
        }
    }

    public static abstract class TreeModel<T> {
        protected abstract int textColor(T var1);

        protected abstract void getElements(T var1, Consumer<T> var2);

        protected abstract int bgColor(T var1);

        protected abstract void treeUpdated();

        protected abstract void onClick(MouseEvent var1, T var2);

        protected abstract String getName(T var1);

        protected abstract Tooltip getTooltip(T var1);

        protected abstract void refresh(T var1);

        protected abstract boolean isSelected(T var1);
    }
}

