/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpl.gui.elements;

import com.tom.cpl.gui.Frame;
import com.tom.cpl.gui.MouseEvent;
import com.tom.cpl.gui.elements.GuiElement;
import com.tom.cpl.gui.elements.Label;
import com.tom.cpl.gui.elements.Panel;
import com.tom.cpl.math.Box;

public class Tooltip
extends Panel {
    private final Frame frm;

    protected Tooltip(Frame frm) {
        super(frm.getGui());
        this.frm = frm;
        this.setBackgroundColor(this.gui.getColors().popup_border);
    }

    public Tooltip(Frame frm, String text) {
        this(frm);
        int i;
        String[] lines = text.split("\\\\");
        int wm = 180;
        for (i = 0; i < lines.length; ++i) {
            int w = this.gui.textWidth(lines[i]);
            if (w <= wm) continue;
            wm = w;
        }
        for (i = 0; i < lines.length; ++i) {
            this.addElement(new Label(this.gui, lines[i]).setBounds(new Box(5, 5 + i * 10, 0, 0)));
        }
        this.setBounds(new Box(0, 0, wm + 20, 8 + lines.length * 10));
    }

    public void set() {
        this.frm.setTooltip(this);
    }

    @Override
    public void draw(MouseEvent event, float partialTicks) {
        this.gui.pushMatrix();
        this.gui.setPosOffset(this.getBounds());
        this.gui.drawBox(0, 0, this.bounds.w, this.bounds.h, this.backgroundColor);
        this.gui.drawBox(1, 1, this.bounds.w - 2, this.bounds.h - 2, this.gui.getColors().panel_background);
        for (GuiElement guiElement : this.elements) {
            if (!guiElement.isVisible()) continue;
            guiElement.draw(event.offset(this.bounds), partialTicks);
        }
        this.gui.popMatrix();
    }
}

