/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpl.gui.elements;

import com.tom.cpl.gui.IGui;
import com.tom.cpl.gui.KeyboardEvent;
import com.tom.cpl.gui.MouseEvent;
import com.tom.cpl.gui.elements.GuiElement;
import com.tom.cpl.gui.util.TabFocusHandler;
import com.tom.cpl.math.Box;
import java.util.function.Supplier;

public class TextField
extends GuiElement
implements Supplier<IGui>,
TabFocusHandler.Focusable {
    private ITextField field;
    private int bgColor;

    public TextField(IGui gui) {
        super(gui);
        this.field = (ITextField)gui.getNative().getNative(TextField.class, this);
        this.bgColor = gui.getColors().popup_border;
    }

    @Override
    public void draw(MouseEvent event, float partialTicks) {
        this.gui.drawBox(this.bounds.x, this.bounds.y, this.bounds.w, this.bounds.h, this.gui.getColors().button_fill);
        this.gui.drawBox(this.bounds.x + 1, this.bounds.y + 1, this.bounds.w - 2, this.bounds.h - 2, this.enabled ? this.bgColor : this.gui.getColors().button_disabled);
        this.field.draw(event.x, event.y, partialTicks, this.bounds);
    }

    @Override
    public void keyPressed(KeyboardEvent evt) {
        if (this.field.isFocused() && (evt.matches(this.gui.getKeyCodes().KEY_ENTER) || evt.matches(this.gui.getKeyCodes().KEY_KP_ENTER) || evt.matches(this.gui.getKeyCodes().KEY_ESCAPE))) {
            this.setFocused(false);
            evt.consume();
        }
        this.field.keyPressed(evt);
    }

    @Override
    public void mouseClick(MouseEvent evt) {
        this.field.mouseClick(evt);
    }

    public String getText() {
        return this.field.getText();
    }

    public void setText(String txt) {
        this.field.setText(txt);
    }

    public void setEventListener(Runnable eventListener) {
        this.field.setEventListener(eventListener);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.field.setEnabled(enabled);
    }

    @Override
    public IGui get() {
        return this.gui;
    }

    @Override
    public boolean isFocused() {
        return this.field.isFocused();
    }

    @Override
    public void setFocused(boolean focused) {
        this.field.setFocused(focused);
    }

    public void setBackgroundColor(int bgColor) {
        this.bgColor = bgColor;
    }

    public int getCursorPos() {
        return this.field.getCursorPos();
    }

    public void setCursorPos(int pos) {
        this.field.setCursorPos(pos);
    }

    public int getSelectionPos() {
        return this.field.getSelectionPos();
    }

    public void setSelectionPos(int pos) {
        this.field.setSelectionPos(pos);
    }

    public void setSelectionPos(int start, int end) {
        this.field.setCursorPos(end);
        this.field.setSelectionPos(start);
    }

    @Override
    public boolean isSelectable() {
        return this.visible && this.enabled;
    }

    public static interface ITextField {
        public void draw(int var1, int var2, float var3, Box var4);

        public void keyPressed(KeyboardEvent var1);

        public void mouseClick(MouseEvent var1);

        public String getText();

        public void setText(String var1);

        public void setEventListener(Runnable var1);

        public void setEnabled(boolean var1);

        public boolean isFocused();

        public void setFocused(boolean var1);

        public int getCursorPos();

        public void setCursorPos(int var1);

        default public int getSelectionPos() {
            return -1;
        }

        default public void setSelectionPos(int pos) {
        }
    }
}

