/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpl.gui.elements;

import com.tom.cpl.gui.Frame;
import com.tom.cpl.gui.elements.Button;
import com.tom.cpl.gui.elements.GuiElement;
import com.tom.cpl.gui.elements.Label;
import com.tom.cpl.gui.elements.PopupPanel;
import com.tom.cpl.math.Box;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;

public class ProcessPopup<R>
extends PopupPanel
implements Runnable {
    protected String title;
    protected Thread processThread;
    protected final Frame frame;
    protected AtomicBoolean cancelled = new AtomicBoolean();
    protected Callable<R> function;
    protected Consumer<R> finished;
    protected Consumer<Throwable> error;
    protected Button cancel;

    public ProcessPopup(Frame frame, String title, String text, Callable<R> function, CompletableFuture<R> cf) {
        this(frame, title, text, function, cf::complete, cf::completeExceptionally);
    }

    public ProcessPopup(Frame frame, String title, String text, Callable<R> function, Consumer<R> finished, Consumer<Throwable> error) {
        this(frame);
        this.title = title;
        this.function = function;
        this.finished = finished;
        this.error = error;
        this.setupLabels(text);
    }

    protected ProcessPopup(Frame frame) {
        super(frame.getGui());
        this.frame = frame;
        this.cancel = new Button(this.gui, this.gui.i18nFormat("button.cpm.cancel", new Object[0]), () -> {
            this.cancelled.set(true);
            this.processThread.interrupt();
        });
        this.addElement(this.cancel);
        this.processThread = new Thread((Runnable)this, "CPM Process Thread");
        this.processThread.setDaemon(true);
    }

    protected List<GuiElement> setupLabels(String text) {
        int w;
        int i;
        ArrayList<GuiElement> labels = new ArrayList<GuiElement>();
        String[] lines = text.split("\\\\");
        int wm = 180;
        for (i = 0; i < lines.length; ++i) {
            w = this.gui.textWidth(lines[i]);
            if (w <= wm) continue;
            wm = w;
        }
        for (i = 0; i < lines.length; ++i) {
            w = this.gui.textWidth(lines[i]);
            labels.add(this.addElement(new Label(this.gui, lines[i]).setBounds(new Box(wm / 2 - w / 2 + 10, 15 + i * 10, 0, 0))));
        }
        this.setBounds(new Box(0, 0, wm + 20, 55 + lines.length * 10));
        this.cancel.setBounds(new Box(wm / 2 - 10, 30 + lines.length * 10, 40, 20));
        return labels;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public void start() {
        this.processThread.start();
        this.frame.openPopup(this);
    }

    @Override
    public void run() {
        try {
            R r = this.function.call();
            if (!this.cancelled.get()) {
                this.gui.executeLater(() -> this.finished.accept(r));
            } else {
                this.gui.executeLater(() -> this.error.accept(null));
            }
        }
        catch (Throwable e) {
            if (!this.cancelled.get()) {
                this.gui.executeLater(() -> this.error.accept(e));
            }
        }
        finally {
            this.gui.executeLater(this::close);
        }
    }
}

