/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpl.command;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.tom.cpl.command.AbstractCommandBuilder;
import com.tom.cpl.command.ArgType;
import com.tom.cpl.command.CommandCtx;
import com.tom.cpl.command.CommandHandler;
import com.tom.cpl.command.LiteralCommandBuilder;
import com.tom.cpl.command.RequiredCommandBuilder;
import com.tom.cpl.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;

public abstract class StringCommandHandler<S, CS, CE extends Exception>
implements CommandHandler<CS> {
    private final Consumer<CommandImpl> register;

    public StringCommandHandler(Consumer<CommandImpl> register) {
        this.register = register;
        this.register();
    }

    @Override
    public void register(LiteralCommandBuilder builder) {
        this.register.accept(new CommandImpl(builder));
    }

    public abstract CE generic(String var1, Object ... var2);

    public abstract CE wrongUsage(String var1, Object ... var2);

    public abstract Object getPlayerObj(S var1, CS var2, String var3) throws CE;

    public abstract CE checkExc(Exception var1);

    public abstract List<String> getOnlinePlayers(S var1);

    public static List<String> getListOfStringsMatchingLastWord(String[] inputArgs, Collection<?> possibleCompletions) {
        String s = inputArgs[inputArgs.length - 1];
        ArrayList list = Lists.newArrayList();
        if (!possibleCompletions.isEmpty()) {
            for (String s1 : Iterables.transform(possibleCompletions, (Function)Functions.toStringFunction())) {
                if (!StringCommandHandler.doesStringStartWith(s, s1)) continue;
                list.add(s1);
            }
        }
        return list;
    }

    public static boolean doesStringStartWith(String original, String region) {
        return region.regionMatches(true, 0, original, 0, original.length());
    }

    public class CommandImpl {
        private final LiteralCommandBuilder root;

        public CommandImpl(LiteralCommandBuilder root) {
            this.root = root;
        }

        public String getName() {
            return this.root.getName();
        }

        public void execute(S server, CS sender, String[] args) throws Exception {
            CommandCtx ctx = new CommandCtx(sender, StringCommandHandler.this);
            AbstractCommandBuilder e = this.root;
            LiteralCommandBuilder prev = null;
            Object lastExc = null;
            block13: for (int i = 0; i < args.length; ++i) {
                String arg = args[i];
                if (e == prev) {
                    throw StringCommandHandler.this.wrongUsage("commands.generic.parameter.invalid", arg);
                }
                prev = e;
                for (AbstractCommandBuilder<?> next : e.getNext()) {
                    if (next instanceof LiteralCommandBuilder) {
                        LiteralCommandBuilder l = (LiteralCommandBuilder)next;
                        if (!arg.equals(l.getName())) continue;
                        e = next;
                        continue block13;
                    }
                    if (!(next instanceof RequiredCommandBuilder)) continue;
                    RequiredCommandBuilder r = (RequiredCommandBuilder)next;
                    switch (r.getType()) {
                        case PLAYER: {
                            try {
                                Object pl = StringCommandHandler.this.getPlayerObj(server, sender, arg);
                                e = next;
                                ctx.arg(r.getId(), pl);
                            }
                            catch (Exception exc) {
                                lastExc = StringCommandHandler.this.checkExc(exc);
                            }
                            break;
                        }
                        case BOOLEAN: {
                            if (arg.equalsIgnoreCase("true")) {
                                e = next;
                                ctx.arg(r.getId(), true);
                                break;
                            }
                            if (arg.equalsIgnoreCase("false")) {
                                e = next;
                                ctx.arg(r.getId(), false);
                                break;
                            }
                            lastExc = StringCommandHandler.this.wrongUsage("commands.generic.boolean.invalid", arg);
                            break;
                        }
                        case INT: {
                            Pair p;
                            try {
                                int v = Integer.parseInt(arg);
                                if (r.getSettings() != null) {
                                    p = (Pair)r.getSettings();
                                    if (v < (Integer)p.getKey()) {
                                        throw StringCommandHandler.this.wrongUsage("commands.generic.num.tooSmall", v);
                                    }
                                    if (v > (Integer)p.getValue()) {
                                        throw StringCommandHandler.this.wrongUsage("commands.generic.num.tooBig", v);
                                    }
                                }
                                ctx.arg(r.getId(), v);
                                e = next;
                            }
                            catch (NumberFormatException num) {
                                lastExc = StringCommandHandler.this.wrongUsage("commands.generic.num.invalid", arg);
                            }
                            break;
                        }
                        case FLOAT: {
                            Pair p;
                            try {
                                float v = Float.parseFloat(arg);
                                if (r.getSettings() != null) {
                                    p = (Pair)r.getSettings();
                                    if (v < ((Float)p.getKey()).floatValue()) {
                                        throw StringCommandHandler.this.wrongUsage("commands.generic.num.tooSmall", Float.valueOf(v));
                                    }
                                    if (v > ((Float)p.getValue()).floatValue()) {
                                        throw StringCommandHandler.this.wrongUsage("commands.generic.num.tooBig", Float.valueOf(v));
                                    }
                                }
                                ctx.arg(r.getId(), Float.valueOf(v));
                                e = next;
                            }
                            catch (NumberFormatException num) {
                                lastExc = StringCommandHandler.this.wrongUsage("commands.generic.num.invalid", arg);
                            }
                            break;
                        }
                        case STRING: {
                            boolean greedyString;
                            boolean bl = greedyString = r.getSettings() == null || (Boolean)r.getSettings() == false;
                            if (greedyString) {
                                StringBuilder b = new StringBuilder(arg);
                                ++i;
                                while (i < args.length) {
                                    b.append(' ');
                                    b.append(args[i]);
                                    ++i;
                                }
                                e = next;
                                ctx.arg(r.getId(), b.toString());
                                break;
                            }
                            e = next;
                            ctx.arg(r.getId(), arg);
                            break;
                        }
                        default: {
                            e = next;
                            ctx.arg(r.getId(), arg);
                        }
                    }
                    if (e != next) continue;
                    continue block13;
                }
            }
            if (e.getFunc() == null) {
                if (lastExc != null) {
                    throw lastExc;
                }
                throw StringCommandHandler.this.wrongUsage("commands." + this.getName() + ".usage", new Object[0]);
            }
            e.getFunc().accept(ctx);
        }

        public List<String> getTabCompletions(S server, CS sender, String[] args) {
            AbstractCommandBuilder e = this.root;
            LiteralCommandBuilder prev = null;
            block0: for (int i = 0; i < args.length; ++i) {
                String arg = args[i];
                prev = e;
                for (AbstractCommandBuilder<?> next : e.getNext()) {
                    if (next instanceof LiteralCommandBuilder) {
                        LiteralCommandBuilder l = (LiteralCommandBuilder)next;
                        if (!arg.equals(l.getName())) continue;
                        e = next;
                        continue block0;
                    }
                    if (!(next instanceof RequiredCommandBuilder)) continue;
                    e = next;
                    continue block0;
                }
            }
            ArrayList<String> compl = new ArrayList<String>();
            for (AbstractCommandBuilder<?> next : prev.getNext()) {
                if (next instanceof LiteralCommandBuilder) {
                    compl.add(((LiteralCommandBuilder)next).getName());
                    continue;
                }
                if (!(next instanceof RequiredCommandBuilder)) continue;
                RequiredCommandBuilder r = (RequiredCommandBuilder)next;
                if (r.getPossibleValues() != null) {
                    compl.addAll((Collection)r.getPossibleValues().get());
                    break;
                }
                if (r.getType() == ArgType.PLAYER) {
                    compl.addAll(StringCommandHandler.this.getOnlinePlayers(server));
                    break;
                }
                if (r.getType() != ArgType.BOOLEAN) break;
                compl.add("true");
                compl.add("false");
                break;
            }
            return StringCommandHandler.getListOfStringsMatchingLastWord(args, compl);
        }
    }
}

