/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.datafixers.DataFixer;
import it.unimi.dsi.fastutil.longs.LongIterator;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.net.Proxy;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.KeyPair;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import net.minecraft.obfuscate.DontObfuscate;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class MinecraftServer
extends aqz<xm>
implements asj,
dk,
AutoCloseable {
    static final Logger p = LogManager.getLogger();
    private static final float q = 0.8f;
    private static final int r = 100;
    public static final int b = 50;
    private static final int s = 6000;
    private static final int t = 2000;
    private static final int u = 15000;
    public static final String c = "level";
    public static final String d = "level://";
    private static final long v = 5000000000L;
    private static final int w = 12;
    public static final String e = "resources.zip";
    public static final File f = new File("usercache.json");
    public static final int g = 11;
    private static final int x = 441;
    private static final int y = 6000;
    private static final int z = 3;
    public static final int h = 29999984;
    public static final bwu i = new bwu("Demo World", bwn.a, false, ary.c, false, new bwm(), bwd.a);
    private static final long A = 50L;
    protected final dib.a j;
    protected final dif k;
    private final asi B = new asi("server", this, ad.b());
    private final List<Runnable> C = Lists.newArrayList();
    private aqh D = aqg.a;
    private apv E = this.D.e();
    private Consumer<apu> F = apu2 -> this.aR();
    private Consumer<Path> G = path -> {};
    private boolean H;
    @Nullable
    private a I;
    private boolean J;
    private final aci K;
    private final acb L;
    private final wa M = new wa();
    private final Random N = new Random();
    private final DataFixer O;
    private String P;
    private int Q = -1;
    protected final gx.b l;
    private final Map<wv<bwq>, abr> R = Maps.newLinkedHashMap();
    private aeh S;
    private volatile boolean T = true;
    private boolean U;
    private int V;
    protected final Proxy m;
    private boolean W;
    private boolean X;
    private boolean Y;
    private boolean Z;
    @Nullable
    private String aa;
    private int ab;
    public final long[] n = new long[100];
    @Nullable
    private KeyPair ac;
    @Nullable
    private String ad;
    private boolean ae;
    private String af = "";
    private String ag = "";
    private volatile boolean ah;
    private long ai;
    private final MinecraftSessionService aj;
    @Nullable
    private final GameProfileRepository ak;
    @Nullable
    private final aed al;
    private long am;
    private final Thread an;
    private long ao = ad.b();
    private long ap;
    private boolean aq;
    private final adi ar;
    private final xl as = new xl(this);
    @Nullable
    private dhv at;
    private final xo au = new xo();
    private final xi av;
    private final agu aw = new agu();
    private boolean ax;
    private float ay;
    private final Executor az;
    @Nullable
    private String aA;
    private xk aB;
    private final dcq aC;
    protected final dii o;

    public static <S extends MinecraftServer> S a(Function<Thread, S> function) {
        AtomicReference<MinecraftServer> atomicReference = new AtomicReference<MinecraftServer>();
        Thread \u00e2\u02dc\u01922 = new Thread(() -> ((MinecraftServer)atomicReference.get()).x(), "Server thread");
        \u00e2\u02dc\u01922.setUncaughtExceptionHandler((thread, throwable) -> p.error((Object)throwable));
        MinecraftServer \u00e2\u02dc\u01923 = (MinecraftServer)function.apply(\u00e2\u02dc\u01922);
        atomicReference.set(\u00e2\u02dc\u01923);
        \u00e2\u02dc\u01922.start();
        return (S)\u00e2\u02dc\u01923;
    }

    public MinecraftServer(Thread thread, gx.b b2, dib.a a2, dii dii2, adi adi2, Proxy proxy, DataFixer dataFixer, xk xk2, @Nullable MinecraftSessionService minecraftSessionService, @Nullable GameProfileRepository gameProfileRepository, @Nullable aed aed2, acb acb2) {
        super("Server");
        this.l = b2;
        this.o = dii2;
        this.m = proxy;
        this.ar = adi2;
        this.aB = xk2;
        this.aj = minecraftSessionService;
        this.ak = gameProfileRepository;
        this.al = aed2;
        if (aed2 != null) {
            aed2.a(this);
        }
        this.K = new aci(this);
        this.L = acb2;
        this.j = a2;
        this.k = a2.b();
        this.O = dataFixer;
        this.av = new xi(this, xk2.a());
        this.aC = new dcq(xk2.i(), a2, dataFixer);
        this.an = thread;
        this.az = ad.f();
    }

    @Override
    private void a(dhx dhx2) {
        dhx2.a(this.aF()::a, this.aF()::b, "scoreboard");
    }

    protected abstract boolean e() throws IOException;

    public static void a(dib.a a2) {
        if (a2.c()) {
            p.info("Converting map!");
            a2.a(new ahd(){
                private long a = ad.b();

                @Override
                public void a(os os2) {
                }

                @Override
                public void b(os os2) {
                }

                @Override
                public void a(int n2) {
                    if (ad.b() - this.a >= 1000L) {
                        this.a = ad.b();
                        p.info("Converting... {}%", (Object)n2);
                    }
                }

                @Override
                public void a() {
                }

                @Override
                public void c(os os2) {
                }
            });
        }
    }

    protected void e_() {
        this.f_();
        this.o.a(this.getServerModName(), this.p().isPresent());
        aca aca2 = this.L.create(11);
        this.a(aca2);
        this.r();
        this.b(aca2);
    }

    protected void r() {
    }

    @Override
    protected void a(aca aca2) {
        cmo \u00e2\u02dc\u01929;
        dih dih2 = this.o.H();
        cql \u00e2\u02dc\u01922 = this.o.A();
        boolean \u00e2\u02dc\u01923 = \u00e2\u02dc\u01922.g();
        long \u00e2\u02dc\u01924 = \u00e2\u02dc\u01922.a();
        long \u00e2\u02dc\u01925 = bxr.a(\u00e2\u02dc\u01924);
        ImmutableList \u00e2\u02dc\u01926 = ImmutableList.of((Object)new cqf(), (Object)new cqe(), (Object)new bjn(), (Object)new bdl(), (Object)new bjy(dih2));
        gr<cnw> \u00e2\u02dc\u01927 = \u00e2\u02dc\u01922.d();
        cnw \u00e2\u02dc\u01928 = \u00e2\u02dc\u01927.a(cnw.b);
        if (\u00e2\u02dc\u01928 == null) {
            cnv cnv2 = this.l.d(gw.P).d(cnv.k);
            \u00e2\u02dc\u01929 = cql.a(this.l.d(gw.aO), this.l.d(gw.aH), new Random().nextLong());
        } else {
            cnv2 = \u00e2\u02dc\u01928.b();
            \u00e2\u02dc\u01929 = \u00e2\u02dc\u01928.c();
        }
        abr abr2 = new abr(this, this.az, this.j, dih2, bwq.f, cnv2, aca2, \u00e2\u02dc\u01929, \u00e2\u02dc\u01923, \u00e2\u02dc\u01925, (List<bwc>)\u00e2\u02dc\u01926, true);
        this.R.put(bwq.f, abr2);
        dhx \u00e2\u02dc\u019210 = abr2.u();
        this.a(\u00e2\u02dc\u019210);
        this.at = new dhv(\u00e2\u02dc\u019210);
        cmj \u00e2\u02dc\u019211 = abr2.o_();
        \u00e2\u02dc\u019211.a(dih2.r());
        if (!dih2.p()) {
            try {
                MinecraftServer.a(abr2, dih2, \u00e2\u02dc\u01922.c(), \u00e2\u02dc\u01923);
                dih2.c(true);
                if (\u00e2\u02dc\u01923) {
                    this.a(this.o);
                }
            }
            catch (Throwable throwable) {
                q q2 = q.a(throwable, "Exception initializing level");
                try {
                    abr2.a(q2);
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                throw new z(q2);
            }
            dih2.c(true);
        }
        this.ad().a(abr2);
        if (this.o.E() != null) {
            this.aL().a(this.o.E());
        }
        for (Map.Entry<wv<cnw>, cnw> entry : \u00e2\u02dc\u01927.d()) {
            wv<cnw> wv2 = entry.getKey();
            if (wv2 == cnw.b) continue;
            wv<bwq> \u00e2\u02dc\u019212 = wv.a(gw.Q, wv2.a());
            cnv \u00e2\u02dc\u019213 = entry.getValue().b();
            cmo \u00e2\u02dc\u019214 = entry.getValue().c();
            dhw \u00e2\u02dc\u019215 = new dhw(this.o, dih2);
            abr \u00e2\u02dc\u019216 = new abr(this, this.az, this.j, \u00e2\u02dc\u019215, \u00e2\u02dc\u019212, \u00e2\u02dc\u019213, aca2, \u00e2\u02dc\u019214, \u00e2\u02dc\u01923, \u00e2\u02dc\u01925, (List<bwc>)ImmutableList.of(), false);
            \u00e2\u02dc\u019211.a(new cmh.a(\u00e2\u02dc\u019216.o_()));
            this.R.put(\u00e2\u02dc\u019212, \u00e2\u02dc\u019216);
        }
    }

    private static void a(abr abr2, dih dih22, boolean bl22, boolean bl3) {
        boolean bl22;
        dih dih22;
        int \u00e2\u02dc\u01926;
        if (bl3) {
            dih22.a(gg.b.b(80), 0.0f);
            return;
        }
        cmo cmo2 = abr2.k().g();
        bxs \u00e2\u02dc\u01922 = cmo2.c();
        Random \u00e2\u02dc\u01923 = new Random(abr2.E());
        gg \u00e2\u02dc\u01924 = \u00e2\u02dc\u01922.a(0, abr2.l_(), 0, 256, bxp2 -> bxp2.b().b(), \u00e2\u02dc\u01923);
        bvv bvv2 = \u00e2\u02dc\u0192 = \u00e2\u02dc\u01924 == null ? new bvv(0, 0) : new bvv(\u00e2\u02dc\u01924);
        if (\u00e2\u02dc\u01924 == null) {
            p.warn("Unable to find spawn biome");
        }
        boolean \u00e2\u02dc\u01925 = false;
        for (Object object : afr.ae.b()) {
            if (!\u00e2\u02dc\u01922.c().contains(((bzp)object).n())) continue;
            \u00e2\u02dc\u01925 = true;
            break;
        }
        if ((\u00e2\u02dc\u01926 = cmo2.a(abr2)) < abr2.s_()) {
            Object object;
            object = \u00e2\u02dc\u0192.l();
            \u00e2\u02dc\u01926 = abr2.a(cpt.a.b, ((hb)object).u() + 8, ((hb)object).w() + 8);
        }
        dih22.a(\u00e2\u02dc\u0192.l().b(8, \u00e2\u02dc\u01926, 8), 0.0f);
        int \u00e2\u02dc\u01927 = 0;
        int \u00e2\u02dc\u01928 = 0;
        int \u00e2\u02dc\u01929 = 0;
        int \u00e2\u02dc\u019210 = -1;
        int \u00e2\u02dc\u019211 = 32;
        for (int i2 = 0; i2 < 1024; ++i2) {
            if (\u00e2\u02dc\u01927 > -16 && \u00e2\u02dc\u01927 <= 16 && \u00e2\u02dc\u01928 > -16 && \u00e2\u02dc\u01928 <= 16 && (\u00e2\u02dc\u0192 = abm.a(abr2, new bvv(\u00e2\u02dc\u0192.b + \u00e2\u02dc\u01927, \u00e2\u02dc\u0192.c + \u00e2\u02dc\u01928), \u00e2\u02dc\u01925)) != null) {
                dih22.a(\u00e2\u02dc\u0192, 0.0f);
                break;
            }
            if (\u00e2\u02dc\u01927 == \u00e2\u02dc\u01928 || \u00e2\u02dc\u01927 < 0 && \u00e2\u02dc\u01927 == -\u00e2\u02dc\u01928 || \u00e2\u02dc\u01927 > 0 && \u00e2\u02dc\u01927 == 1 - \u00e2\u02dc\u01928) {
                \u00e2\u02dc\u0192 = \u00e2\u02dc\u01929;
                \u00e2\u02dc\u01929 = -\u00e2\u02dc\u019210;
                \u00e2\u02dc\u019210 = \u00e2\u02dc\u0192;
            }
            \u00e2\u02dc\u01927 += \u00e2\u02dc\u01929;
            \u00e2\u02dc\u01928 += \u00e2\u02dc\u019210;
        }
        if (bl22) {
            cro<?, ?> cro2 = la.V;
            cro2.a(abr2, cmo2, abr2.w, new gg(dih22.a(), dih22.b(), dih22.c()));
        }
    }

    @Override
    private void a(dii dii2) {
        dii2.a(ary.a);
        dii2.d(true);
        dih dih2 = dii2.H();
        dih2.b(false);
        dih2.a(false);
        dih2.a(1000000000);
        dih2.b(6000L);
        dih2.a(bwn.d);
    }

    private void b(aca aca2) {
        abr abr2 = this.E();
        p.info("Preparing start region for dimension {}", (Object)abr2.aa().a());
        gg \u00e2\u02dc\u01922 = abr2.w();
        aca2.a(new bvv(\u00e2\u02dc\u01922));
        abp \u00e2\u02dc\u01923 = abr2.k();
        \u00e2\u02dc\u01923.a().a(500);
        this.ao = ad.b();
        \u00e2\u02dc\u01923.a(abw.a, new bvv(\u00e2\u02dc\u01922), 11, ahn.a);
        while (\u00e2\u02dc\u01923.b() != 441) {
            this.ao = ad.b() + 10L;
            this.y();
        }
        this.ao = ad.b() + 10L;
        this.y();
        for (abr abr3 : this.R.values()) {
            bwl bwl2 = abr3.u().a(bwl::b, "chunks");
            if (bwl2 == null) continue;
            LongIterator \u00e2\u02dc\u01924 = bwl2.a().iterator();
            while (\u00e2\u02dc\u01924.hasNext()) {
                long l2 = \u00e2\u02dc\u01924.nextLong();
                bvv \u00e2\u02dc\u01925 = new bvv(l2);
                abr3.k().a(\u00e2\u02dc\u01925, true);
            }
        }
        this.ao = ad.b() + 10L;
        this.y();
        aca2.b();
        \u00e2\u02dc\u01923.a().a(5);
        this.bg();
    }

    protected void f_() {
        File file = this.j.a(dhz.h).toFile();
        if (file.isFile()) {
            String string = this.j.a();
            try {
                this.a(d + URLEncoder.encode(string, StandardCharsets.UTF_8.toString()) + "/resources.zip", "");
            }
            catch (UnsupportedEncodingException \u00e2\u02dc\u01922) {
                p.warn("Something went wrong url encoding {}", (Object)string);
            }
        }
    }

    public bwn g_() {
        return this.o.m();
    }

    public boolean g() {
        return this.o.n();
    }

    public abstract int h();

    public abstract int i();

    public abstract boolean j();

    public boolean a(boolean bl2, boolean bl3, boolean bl4) {
        boolean bl5 = false;
        for (abr abr2 : this.G()) {
            if (!bl2) {
                p.info("Saving chunks for level '{}'/{}", (Object)abr2, (Object)abr2.aa().a());
            }
            abr2.a(null, bl3, abr2.b && !bl4);
            bl5 = true;
        }
        abr abr2 = this.E();
        dih dih2 = this.o.H();
        dih2.a(abr2.o_().t());
        this.o.b(this.aL().c());
        this.j.a(this.l, this.o, this.ad().q());
        if (bl3) {
            for (abr abr3 : this.G()) {
                p.info("ThreadedAnvilChunkStorage ({}): All chunks are saved", (Object)abr3.k().a.i());
            }
            p.info("ThreadedAnvilChunkStorage: All dimensions are saved");
        }
        return bl5;
    }

    @Override
    public void close() {
        this.u();
    }

    public void u() {
        p.info("Stopping server");
        if (this.ae() != null) {
            this.ae().b();
        }
        if (this.S != null) {
            p.info("Saving players");
            this.S.h();
            this.S.r();
        }
        p.info("Saving worlds");
        for (abr abr2 : this.G()) {
            if (abr2 == null) continue;
            abr2.b = false;
        }
        this.a(false, true, false);
        for (abr abr2 : this.G()) {
            if (abr2 == null) continue;
            try {
                abr2.close();
            }
            catch (IOException iOException) {
                p.error("Exception closing the level", (Throwable)iOException);
            }
        }
        if (this.B.d()) {
            this.B.e();
        }
        this.aB.close();
        try {
            this.j.close();
        }
        catch (IOException iOException) {
            p.error("Failed to unlock level {}", (Object)this.j.a(), (Object)iOException);
        }
    }

    public String v() {
        return this.P;
    }

    public void a_(String string) {
        this.P = string;
    }

    public boolean w() {
        return this.T;
    }

    @Override
    public void a(boolean bl2) {
        this.T = false;
        if (bl2) {
            try {
                this.an.join();
            }
            catch (InterruptedException interruptedException) {
                p.error("Error while shutting down", (Throwable)interruptedException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void x() {
        try {
            if (this.e()) {
                this.ao = ad.b();
                this.M.a(new pf(this.aa));
                this.M.a(new wa.c(ab.b().getName(), ab.b().getProtocolVersion()));
                this.a(this.M);
                while (this.T) {
                    long l2 = ad.b() - this.ao;
                    if (l2 > 2000L && this.ao - this.ai >= 15000L) {
                        \u00e2\u02dc\u0192 = l2 / 50L;
                        p.warn("Can't keep up! Is the server overloaded? Running {}ms or {} ticks behind", (Object)l2, (Object)\u00e2\u02dc\u0192);
                        this.ao += \u00e2\u02dc\u0192 * 50L;
                        this.ai = this.ao;
                    }
                    if (this.J) {
                        this.J = false;
                        this.I = new a(ad.c(), this.V);
                    }
                    this.ao += 50L;
                    this.bh();
                    this.E.a("tick");
                    this.a(this::be);
                    this.E.b("nextTickWait");
                    this.aq = true;
                    this.ap = Math.max(ad.b() + 50L, this.ao);
                    this.y();
                    this.E.c();
                    this.bi();
                    this.ah = true;
                }
            } else {
                this.a((q)null);
            }
        }
        catch (Throwable throwable) {
            p.error("Encountered an unexpected exception", throwable);
            q q2 = throwable instanceof z ? ((z)throwable).a() : new q("Exception in server tick loop", throwable);
            this.b(q2.g());
            File \u00e2\u02dc\u01922 = new File(new File(this.B(), "crash-reports"), "crash-" + new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date()) + "-server.txt");
            if (q2.a(\u00e2\u02dc\u01922)) {
                p.error("This crash report has been saved to: {}", (Object)\u00e2\u02dc\u01922.getAbsolutePath());
            } else {
                p.error("We were unable to save this crash report to disk.");
            }
            this.a(q2);
        }
        finally {
            try {
                this.U = true;
                this.u();
            }
            catch (Throwable \u00e2\u02dc\u01923) {
                p.error("Exception stopping the server", \u00e2\u02dc\u01923);
            }
            finally {
                this.f();
            }
        }
    }

    private boolean be() {
        return this.br() || ad.b() < (this.aq ? this.ap : this.ao);
    }

    protected void y() {
        this.bp();
        this.c(() -> !this.be());
    }

    protected xm a(Runnable runnable) {
        return new xm(this.V, runnable);
    }

    protected boolean a(xm xm2) {
        return xm2.a() + 3 < this.V || this.be();
    }

    @Override
    public boolean z() {
        boolean bl2;
        this.aq = bl2 = this.bf();
        return bl2;
    }

    private boolean bf() {
        if (super.z()) {
            return true;
        }
        if (this.be()) {
            for (abr abr2 : this.G()) {
                if (!abr2.k().d()) continue;
                return true;
            }
        }
        return false;
    }

    protected void b(xm xm2) {
        this.aP().c("runTask");
        super.c(xm2);
    }

    @Override
    private void a(wa wa2) {
        Optional<File> optional = Optional.of(this.c("server-icon.png")).filter(File::isFile);
        if (!optional.isPresent()) {
            optional = this.j.f().map(Path::toFile).filter(File::isFile);
        }
        optional.ifPresent(file -> {
            try {
                BufferedImage bufferedImage = ImageIO.read(file);
                Validate.validState((bufferedImage.getWidth() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels wide", (Object[])new Object[0]);
                Validate.validState((bufferedImage.getHeight() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels high", (Object[])new Object[0]);
                ByteArrayOutputStream \u00e2\u02dc\u01922 = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)bufferedImage, "PNG", \u00e2\u02dc\u01922);
                byte[] \u00e2\u02dc\u01923 = Base64.getEncoder().encode(\u00e2\u02dc\u01922.toByteArray());
                wa2.a("data:image/png;base64," + new String(\u00e2\u02dc\u01923, StandardCharsets.UTF_8));
            }
            catch (Exception exception) {
                p.error("Couldn't load server icon", (Throwable)exception);
            }
        });
    }

    public Optional<Path> A() {
        return this.j.f();
    }

    public File B() {
        return new File(".");
    }

    @Override
    protected void a(q q2) {
    }

    public void f() {
    }

    @Override
    public void a(BooleanSupplier booleanSupplier) {
        long l2 = ad.c();
        ++this.V;
        this.b(booleanSupplier);
        if (l2 - this.am >= 5000000000L) {
            this.am = l2;
            this.M.a(new wa.a(this.J(), this.I()));
            GameProfile[] gameProfileArray = new GameProfile[Math.min(this.I(), 12)];
            int \u00e2\u02dc\u01922 = ahb.a(this.N, 0, this.I() - gameProfileArray.length);
            for (int i2 = 0; i2 < gameProfileArray.length; ++i2) {
                gameProfileArray[i2] = this.S.s().get(\u00e2\u02dc\u01922 + i2).fj();
            }
            Collections.shuffle(Arrays.asList(gameProfileArray));
            this.M.b().a(gameProfileArray);
        }
        if (this.V % 6000 == 0) {
            p.debug("Autosave started");
            this.E.a("save");
            this.S.h();
            this.a(true, false, false);
            this.E.c();
            p.debug("Autosave finished");
        }
        this.E.a("snooper");
        if (!this.B.d() && this.V > 100) {
            this.B.a();
        }
        if (this.V % 6000 == 0) {
            this.B.b();
        }
        this.E.c();
        this.E.a("tallying");
        long l3 = ad.c() - l2;
        this.n[this.V % 100] = l3;
        \u00e2\u02dc\u0192 = l3;
        this.ay = this.ay * 0.8f + (float)\u00e2\u02dc\u0192 / 1000000.0f * 0.19999999f;
        \u00e2\u02dc\u0192 = ad.c();
        this.aw.a(\u00e2\u02dc\u0192 - l2);
        this.E.c();
    }

    public void b(BooleanSupplier booleanSupplier) {
        this.E.a("commandFunctions");
        this.az().c();
        this.E.b("levels");
        for (abr abr2 : this.G()) {
            this.E.a(() -> abr2 + " " + abr2.aa().a());
            if (this.V % 20 == 0) {
                this.E.a("timeSync");
                this.S.a(new sw(abr2.V(), abr2.W(), abr2.X().b(bwm.k)), abr2.aa());
                this.E.c();
            }
            this.E.a("tick");
            try {
                abr2.a(booleanSupplier);
            }
            catch (Throwable throwable) {
                q q2 = q.a(throwable, "Exception ticking world");
                abr2.a(q2);
                throw new z(q2);
            }
            this.E.c();
            this.E.c();
        }
        this.E.b("connection");
        this.ae().c();
        this.E.b("players");
        this.S.d();
        if (ab.aF) {
            mg.a.b();
        }
        this.E.b("server gui refresh");
        for (int i2 = 0; i2 < this.C.size(); ++i2) {
            this.C.get(i2).run();
        }
        this.E.c();
    }

    public boolean C() {
        return true;
    }

    public void b(Runnable runnable) {
        this.C.add(runnable);
    }

    protected void b(String string) {
        this.aA = string;
    }

    public boolean D() {
        return !this.an.isAlive();
    }

    public File c(String string) {
        return new File(this.B(), string);
    }

    public final abr E() {
        return this.R.get(bwq.f);
    }

    @Nullable
    public abr a(wv<bwq> wv2) {
        return this.R.get(wv2);
    }

    public Set<wv<bwq>> F() {
        return this.R.keySet();
    }

    public Iterable<abr> G() {
        return this.R.values();
    }

    public String H() {
        return ab.b().getName();
    }

    public int I() {
        return this.S.m();
    }

    public int J() {
        return this.S.n();
    }

    public String[] K() {
        return this.S.e();
    }

    @DontObfuscate
    public String getServerModName() {
        return "vanilla";
    }

    public ac b(ac ac2) {
        if (this.S != null) {
            ac2.a("Player Count", () -> this.S.m() + " / " + this.S.n() + "; " + this.S.s());
        }
        ac2.a("Data Packs", () -> {
            StringBuilder stringBuilder = new StringBuilder();
            for (adg adg2 : this.ar.e()) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(adg2.e());
                if (adg2.c().a()) continue;
                stringBuilder.append(" (incompatible)");
            }
            return stringBuilder.toString();
        });
        if (this.aA != null) {
            ac2.a("Server Id", () -> this.aA);
        }
        return this.a(ac2);
    }

    public abstract ac a(ac var1);

    public abstract Optional<String> p();

    @Override
    public void a(os os2, UUID uUID) {
        p.info(os2.getString());
    }

    public KeyPair L() {
        return this.ac;
    }

    public int M() {
        return this.Q;
    }

    @Override
    public void a(int n2) {
        this.Q = n2;
    }

    public String N() {
        return this.ad;
    }

    public void d(String string) {
        this.ad = string;
    }

    public boolean O() {
        return this.ad != null;
    }

    protected void P() {
        p.info("Generating keypair");
        try {
            this.ac = agj.b();
        }
        catch (agk agk2) {
            throw new IllegalStateException("Failed to generate key pair", agk2);
        }
    }

    public void a(ary ary2, boolean bl2) {
        if (!bl2 && this.o.t()) {
            return;
        }
        this.o.a(this.o.n() ? ary.d : ary2);
        this.bg();
        this.ad().s().forEach(this::c);
    }

    public int b(int n2) {
        return n2;
    }

    private void bg() {
        for (abr abr2 : this.G()) {
            abr2.b(this.Q(), this.X());
        }
    }

    public void b(boolean bl2) {
        this.o.d(bl2);
        this.ad().s().forEach(this::c);
    }

    @Override
    private void c(abs abs2) {
        dhy dhy2 = abs2.u().m_();
        abs2.b.a(new qc(dhy2.s(), dhy2.t()));
    }

    public boolean Q() {
        return this.o.s() != ary.a;
    }

    public boolean R() {
        return this.ae;
    }

    @Override
    public void c(boolean bl2) {
        this.ae = bl2;
    }

    public String S() {
        return this.af;
    }

    public String T() {
        return this.ag;
    }

    public void a(String string, String string2) {
        this.af = string;
        this.ag = string2;
    }

    @Override
    public void a(asi asi22) {
        asi asi22;
        asi22.a("whitelist_enabled", false);
        asi22.a("whitelist_count", 0);
        if (this.S != null) {
            asi22.a("players_current", this.I());
            asi22.a("players_max", this.J());
            asi22.a("players_seen", this.k.a().length);
        }
        asi22.a("uses_auth", this.W);
        asi22.a("gui_state", (Object)(this.ag() ? "enabled" : "disabled"));
        asi22.a("run_time", (ad.b() - asi22.g()) / 60L * 1000L);
        asi22.a("avg_tick_ms", (int)(ahb.a(this.n) * 1.0E-6));
        int n2 = 0;
        for (abr abr2 : this.G()) {
            if (abr2 == null) continue;
            asi22.a("world[" + n2 + "][dimension]", abr2.aa().a());
            asi22.a("world[" + n2 + "][mode]", (Object)this.o.m());
            asi22.a("world[" + n2 + "][difficulty]", (Object)abr2.af());
            asi22.a("world[" + n2 + "][hardcore]", this.o.n());
            asi22.a("world[" + n2 + "][height]", abr2.ag());
            asi22.a("world[" + n2 + "][chunks_loaded]", abr2.k().h());
            ++n2;
        }
        asi22.a("worlds", n2);
    }

    @Override
    public void b(asi asi2) {
        asi2.b("singleplayer", this.O());
        asi2.b("server_brand", this.getServerModName());
        asi2.b("gui_supported", GraphicsEnvironment.isHeadless() ? "headless" : "supported");
        asi2.b("dedicated", this.k());
    }

    @Override
    public boolean U() {
        return true;
    }

    public abstract boolean k();

    public abstract int l();

    public boolean V() {
        return this.W;
    }

    public void d(boolean bl2) {
        this.W = bl2;
    }

    public boolean W() {
        return this.X;
    }

    public void e(boolean bl2) {
        this.X = bl2;
    }

    public boolean X() {
        return true;
    }

    public boolean Y() {
        return true;
    }

    public abstract boolean m();

    public boolean Z() {
        return this.Y;
    }

    public void f(boolean bl2) {
        this.Y = bl2;
    }

    public boolean aa() {
        return this.Z;
    }

    public void g(boolean bl2) {
        this.Z = bl2;
    }

    public abstract boolean n();

    public String ab() {
        return this.aa;
    }

    public void e(String string) {
        this.aa = string;
    }

    public boolean ac() {
        return this.U;
    }

    public aeh ad() {
        return this.S;
    }

    @Override
    public void a(aeh aeh2) {
        this.S = aeh2;
    }

    public abstract boolean o();

    @Override
    public void a(bwn bwn2) {
        this.o.a(bwn2);
    }

    @Nullable
    public aci ae() {
        return this.K;
    }

    public boolean af() {
        return this.ah;
    }

    public boolean ag() {
        return false;
    }

    public boolean a(@Nullable bwn bwn2, boolean bl2, int n2) {
        return false;
    }

    public int ah() {
        return this.V;
    }

    public asi ai() {
        return this.B;
    }

    public int aj() {
        return 16;
    }

    public boolean a(abr abr2, gg gg2, bke bke2) {
        return false;
    }

    public boolean ak() {
        return true;
    }

    public Proxy al() {
        return this.m;
    }

    public int am() {
        return this.ab;
    }

    @Override
    public void c(int n2) {
        this.ab = n2;
    }

    public MinecraftSessionService an() {
        return this.aj;
    }

    public GameProfileRepository ao() {
        return this.ak;
    }

    public aed ap() {
        return this.al;
    }

    public wa aq() {
        return this.M;
    }

    public void ar() {
        this.am = 0L;
    }

    public int as() {
        return 29999984;
    }

    @Override
    public boolean at() {
        return super.at() && !this.ac();
    }

    @Override
    public Thread au() {
        return this.an;
    }

    public int av() {
        return 256;
    }

    public long aw() {
        return this.ao;
    }

    public DataFixer ax() {
        return this.O;
    }

    public int a(@Nullable abr abr2) {
        if (abr2 != null) {
            return abr2.X().c(bwm.r);
        }
        return 10;
    }

    public xg ay() {
        return this.aB.h();
    }

    public xi az() {
        return this.av;
    }

    @Override
    public CompletableFuture<Void> a(Collection<String> collection) {
        CompletionStage completionStage = ((CompletableFuture)CompletableFuture.supplyAsync(() -> (ImmutableList)collection.stream().map(this.ar::a).filter(Objects::nonNull).map(adg::d).collect(ImmutableList.toImmutableList()), this).thenCompose(immutableList -> xk.a((List<acv>)immutableList, this.l, this.k() ? dm.a.b : dm.a.c, this.i(), this.az, this))).thenAcceptAsync(xk2 -> {
            this.aB.close();
            this.aB = xk2;
            this.ar.a(collection);
            this.o.a(MinecraftServer.a(this.ar));
            xk2.j();
            this.ad().h();
            this.ad().t();
            this.av.a(this.aB.a());
            this.aC.a(this.aB.i());
        }, (Executor)this);
        if (this.bl()) {
            this.c(((CompletableFuture)completionStage)::isDone);
        }
        return completionStage;
    }

    public static bwd a(adi adi22, bwd bwd2, boolean bl2) {
        adi22.a();
        if (bl2) {
            adi22.a(Collections.singleton("vanilla"));
            return new bwd((List<String>)ImmutableList.of((Object)"vanilla"), (List<String>)ImmutableList.of());
        }
        LinkedHashSet linkedHashSet = Sets.newLinkedHashSet();
        for (String string : bwd2.a()) {
            if (adi22.b(string)) {
                linkedHashSet.add(string);
                continue;
            }
            p.warn("Missing data pack {}", (Object)string);
        }
        for (adg adg2 : adi22.c()) {
            String string = adg2.e();
            if (bwd2.b().contains(string) || linkedHashSet.contains(string)) continue;
            p.info("Found new data pack {}, loading it automatically", (Object)string);
            linkedHashSet.add(string);
        }
        if (linkedHashSet.isEmpty()) {
            p.info("No datapacks selected, forcing vanilla");
            linkedHashSet.add("vanilla");
        }
        adi22.a(linkedHashSet);
        return MinecraftServer.a(adi22);
    }

    private static bwd a(adi adi2) {
        Collection<String> collection = adi2.d();
        ImmutableList \u00e2\u02dc\u01922 = ImmutableList.copyOf(collection);
        List \u00e2\u02dc\u01923 = (List)adi2.b().stream().filter(string -> !collection.contains(string)).collect(ImmutableList.toImmutableList());
        return new bwd((List<String>)\u00e2\u02dc\u01922, \u00e2\u02dc\u01923);
    }

    @Override
    public void a(dl dl2) {
        if (!this.aM()) {
            return;
        }
        aeh aeh2 = dl2.j().ad();
        aep \u00e2\u02dc\u01922 = aeh2.i();
        ArrayList \u00e2\u02dc\u01923 = Lists.newArrayList(aeh2.s());
        for (abs abs2 : \u00e2\u02dc\u01923) {
            if (\u00e2\u02dc\u01922.a(abs2.fj())) continue;
            abs2.b.b(new pg("multiplayer.disconnect.not_whitelisted"));
        }
    }

    public adi aA() {
        return this.ar;
    }

    public dm aB() {
        return this.aB.g();
    }

    public dl aC() {
        abr abr2 = this.E();
        return new dl(this, abr2 == null ? dna.a : dna.b(abr2.w()), dmz.a, abr2, 4, "Server", new pf("Server"), this, null);
    }

    @Override
    public boolean h_() {
        return true;
    }

    @Override
    public boolean i_() {
        return true;
    }

    @Override
    public abstract boolean E_();

    public btj aD() {
        return this.aB.f();
    }

    public agc aE() {
        return this.aB.e();
    }

    public xl aF() {
        return this.as;
    }

    public dhv aG() {
        if (this.at == null) {
            throw new NullPointerException("Called before server init");
        }
        return this.at;
    }

    public dit aH() {
        return this.aB.c();
    }

    public diu aI() {
        return this.aB.b();
    }

    public dio aJ() {
        return this.aB.d();
    }

    public bwm aK() {
        return this.E().X();
    }

    public xo aL() {
        return this.au;
    }

    public boolean aM() {
        return this.ax;
    }

    @Override
    public void h(boolean bl2) {
        this.ax = bl2;
    }

    public float aN() {
        return this.ay;
    }

    public int b(GameProfile gameProfile) {
        if (this.ad().f(gameProfile)) {
            aej aej2 = (aej)this.ad().k().b(gameProfile);
            if (aej2 != null) {
                return aej2.a();
            }
            if (this.a(gameProfile)) {
                return 4;
            }
            if (this.O()) {
                return this.ad().u() ? 4 : 0;
            }
            return this.h();
        }
        return 0;
    }

    public agu aO() {
        return this.aw;
    }

    public apv aP() {
        return this.E;
    }

    public abstract boolean a(GameProfile var1);

    @Override
    public void a(Path path) throws IOException {
    }

    private void b(Path path) {
        \u00e2\u02dc\u0192 = path.resolve("levels");
        try {
            for (Map.Entry<wv<bwq>, abr> entry : this.R.entrySet()) {
                ww ww2 = entry.getKey().a();
                Path \u00e2\u02dc\u01922 = \u00e2\u02dc\u0192.resolve(ww2.b()).resolve(ww2.a());
                Files.createDirectories(\u00e2\u02dc\u01922, new FileAttribute[0]);
                entry.getValue().a(\u00e2\u02dc\u01922);
            }
            this.d(path.resolve("gamerules.txt"));
            this.e(path.resolve("classpath.txt"));
            this.c(path.resolve("stats.txt"));
            this.f(path.resolve("threads.txt"));
            this.a(path.resolve("server.properties.txt"));
        }
        catch (IOException iOException) {
            p.warn("Failed to save debug report", (Throwable)iOException);
        }
    }

    @Override
    private void c(Path path) throws IOException {
        try (BufferedWriter bufferedWriter = Files.newBufferedWriter(path, new OpenOption[0]);){
            bufferedWriter.write(String.format("pending_tasks: %d\n", this.bm()));
            bufferedWriter.write(String.format("average_tick_time: %f\n", Float.valueOf(this.aN())));
            bufferedWriter.write(String.format("tick_times: %s\n", Arrays.toString(this.n)));
            bufferedWriter.write(String.format("queue: %s\n", ad.f()));
        }
    }

    private void d(Path path) throws IOException {
        try (BufferedWriter bufferedWriter = Files.newBufferedWriter(path, new OpenOption[0]);){
            final ArrayList arrayList = Lists.newArrayList();
            final bwm \u00e2\u02dc\u01922 = this.aK();
            bwm.a(new bwm.c(){

                @Override
                public <T extends bwm.g<T>> void a(bwm.e<T> e2, bwm.f<T> f2) {
                    arrayList.add(String.format("%s=%s\n", e2.a(), \u00e2\u02dc\u01922.a(e2)));
                }
            });
            for (String string : arrayList) {
                bufferedWriter.write(string);
            }
        }
    }

    private void e(Path path) throws IOException {
        try (BufferedWriter bufferedWriter = Files.newBufferedWriter(path, new OpenOption[0]);){
            String string = System.getProperty("java.class.path");
            \u00e2\u02dc\u0192 = System.getProperty("path.separator");
            for (String string2 : Splitter.on((String)\u00e2\u02dc\u0192).split((CharSequence)string)) {
                bufferedWriter.write(string2);
                bufferedWriter.write("\n");
            }
        }
    }

    private void f(Path path) throws IOException {
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        ThreadInfo[] \u00e2\u02dc\u01922 = threadMXBean.dumpAllThreads(true, true);
        Arrays.sort(\u00e2\u02dc\u01922, Comparator.comparing(ThreadInfo::getThreadName));
        try (BufferedWriter \u00e2\u02dc\u01923 = Files.newBufferedWriter(path, new OpenOption[0]);){
            for (ThreadInfo threadInfo : \u00e2\u02dc\u01922) {
                \u00e2\u02dc\u01923.write(threadInfo.toString());
                ((Writer)\u00e2\u02dc\u01923).write(10);
            }
        }
    }

    private void bh() {
        if (this.H) {
            this.D = aqf.a(new aqj(ad.a, this.k()), ad.a, ad.g(), new aql("server"), this.F, path -> {
                this.g(() -> this.b(path.resolve("server")));
                this.G.accept((Path)path);
            });
            this.H = false;
        }
        this.E = apy.a(this.D.e(), apy.a("Server"));
        this.D.b();
        this.E.a();
    }

    private void bi() {
        this.E.b();
        this.D.c();
    }

    public boolean aQ() {
        return this.D.d();
    }

    public void a(Consumer<apu> consumer, Consumer<Path> consumer2) {
        this.F = apu2 -> {
            this.aR();
            consumer.accept((apu)apu2);
        };
        this.G = consumer2;
        this.H = true;
    }

    public void aR() {
        this.D = aqg.a;
    }

    public void aS() {
        this.D.a();
    }

    public Path a(dhz dhz2) {
        return this.j.a(dhz2);
    }

    public boolean aT() {
        return true;
    }

    public dcq aU() {
        return this.aC;
    }

    public dii aV() {
        return this.o;
    }

    public gx aW() {
        return this.l;
    }

    public aco a(abs abs2) {
        return aco.a;
    }

    public boolean aX() {
        return false;
    }

    public abt b(abs abs2) {
        return this.R() ? new abj(abs2) : new abt(abs2);
    }

    @Nullable
    public bwn aY() {
        return null;
    }

    public adt aZ() {
        return this.aB.i();
    }

    @Nullable
    public os ba() {
        return null;
    }

    public boolean bb() {
        return this.J || this.I != null;
    }

    public void bc() {
        this.J = true;
    }

    public apu bd() {
        if (this.I == null) {
            return apq.a;
        }
        apu apu2 = this.I.a(ad.c(), this.V);
        this.I = null;
        return apu2;
    }

    @Override
    public /* synthetic */ void c(Runnable runnable) {
        this.b((xm)runnable);
    }

    @Override
    public /* synthetic */ boolean d(Runnable runnable) {
        return this.a((xm)runnable);
    }

    @Override
    public /* synthetic */ Runnable e(Runnable runnable) {
        return this.a(runnable);
    }

    static class a {
        final long a;
        final int b;

        a(long l2, int n2) {
            this.a = l2;
            this.b = n2;
        }

        apu a(final long l2, final int n2) {
            return new apu(){

                @Override
                public List<apx> a(String string) {
                    return Collections.emptyList();
                }

                @Override
                public boolean a(Path path) {
                    return false;
                }

                @Override
                public long a() {
                    return a;
                }

                @Override
                public int b() {
                    return b;
                }

                @Override
                public long c() {
                    return l2;
                }

                @Override
                public int d() {
                    return n2;
                }

                @Override
                public String e() {
                    return "";
                }
            };
        }
    }
}

