/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.google.common.collect.ImmutableSet;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import com.mojang.datafixers.DataFixer;
import com.mojang.serialization.Lifecycle;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.OutputStream;
import java.net.Proxy;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.BooleanSupplier;
import joptsimple.AbstractOptionSpec;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.NonOptionArgumentSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import net.minecraft.obfuscate.DontObfuscate;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Main {
    private static final Logger a = LogManager.getLogger();

    @DontObfuscate
    public static void main(String[] stringArray) {
        ab.a();
        OptionParser optionParser = new OptionParser();
        OptionSpecBuilder \u00e2\u02dc\u01922 = optionParser.accepts("nogui");
        OptionSpecBuilder \u00e2\u02dc\u01923 = optionParser.accepts("initSettings", "Initializes 'server.properties' and 'eula.txt', then quits");
        OptionSpecBuilder \u00e2\u02dc\u01924 = optionParser.accepts("demo");
        OptionSpecBuilder \u00e2\u02dc\u01925 = optionParser.accepts("bonusChest");
        OptionSpecBuilder \u00e2\u02dc\u01926 = optionParser.accepts("forceUpgrade");
        OptionSpecBuilder \u00e2\u02dc\u01927 = optionParser.accepts("eraseCache");
        OptionSpecBuilder \u00e2\u02dc\u01928 = optionParser.accepts("safeMode", "Loads level with vanilla datapack only");
        AbstractOptionSpec \u00e2\u02dc\u01929 = optionParser.accepts("help").forHelp();
        ArgumentAcceptingOptionSpec \u00e2\u02dc\u019210 = optionParser.accepts("singleplayer").withRequiredArg();
        ArgumentAcceptingOptionSpec \u00e2\u02dc\u019211 = optionParser.accepts("universe").withRequiredArg().defaultsTo((Object)".", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec \u00e2\u02dc\u019212 = optionParser.accepts("world").withRequiredArg();
        ArgumentAcceptingOptionSpec \u00e2\u02dc\u019213 = optionParser.accepts("port").withRequiredArg().ofType(Integer.class).defaultsTo((Object)-1, (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec \u00e2\u02dc\u019214 = optionParser.accepts("serverId").withRequiredArg();
        NonOptionArgumentSpec \u00e2\u02dc\u019215 = optionParser.nonOptions();
        try {
            Object object;
            OptionSet optionSet = optionParser.parse(stringArray);
            if (optionSet.has((OptionSpec)\u00e2\u02dc\u01929)) {
                optionParser.printHelpOn((OutputStream)System.err);
                return;
            }
            q.h();
            wy.a();
            wy.c();
            ad.l();
            gx.b \u00e2\u02dc\u019216 = gx.a();
            Path \u00e2\u02dc\u019217 = Paths.get("server.properties", new String[0]);
            aau \u00e2\u02dc\u019218 = new aau(\u00e2\u02dc\u019217);
            \u00e2\u02dc\u019218.b();
            Path \u00e2\u02dc\u019219 = Paths.get("eula.txt", new String[0]);
            xc \u00e2\u02dc\u019220 = new xc(\u00e2\u02dc\u019219);
            if (optionSet.has((OptionSpec)\u00e2\u02dc\u01923)) {
                a.info("Initialized '{}' and '{}'", (Object)\u00e2\u02dc\u019217.toAbsolutePath(), (Object)\u00e2\u02dc\u019219.toAbsolutePath());
                return;
            }
            if (!\u00e2\u02dc\u019220.a()) {
                a.info("You need to agree to the EULA in order to run the server. Go to eula.txt for more info.");
                return;
            }
            File \u00e2\u02dc\u019221 = new File((String)optionSet.valueOf((OptionSpec)\u00e2\u02dc\u019211));
            YggdrasilAuthenticationService \u00e2\u02dc\u019222 = new YggdrasilAuthenticationService(Proxy.NO_PROXY);
            MinecraftSessionService \u00e2\u02dc\u019223 = \u00e2\u02dc\u019222.createMinecraftSessionService();
            GameProfileRepository \u00e2\u02dc\u019224 = \u00e2\u02dc\u019222.createProfileRepository();
            aed \u00e2\u02dc\u019225 = new aed(\u00e2\u02dc\u019224, new File(\u00e2\u02dc\u019221, MinecraftServer.f.getName()));
            String \u00e2\u02dc\u019226 = Optional.ofNullable((String)optionSet.valueOf((OptionSpec)\u00e2\u02dc\u019212)).orElse(\u00e2\u02dc\u019218.a().p);
            dib \u00e2\u02dc\u019227 = dib.a(\u00e2\u02dc\u019221.toPath());
            dib.a \u00e2\u02dc\u019228 = \u00e2\u02dc\u019227.c(\u00e2\u02dc\u019226);
            MinecraftServer.a(\u00e2\u02dc\u019228);
            dic \u00e2\u02dc\u019229 = \u00e2\u02dc\u019228.d();
            if (\u00e2\u02dc\u019229 != null && \u00e2\u02dc\u019229.p()) {
                a.info("Loading of worlds with extended height is disabled.");
                return;
            }
            bwd \u00e2\u02dc\u019230 = \u00e2\u02dc\u019228.e();
            boolean \u00e2\u02dc\u019231 = optionSet.has((OptionSpec)\u00e2\u02dc\u01928);
            if (\u00e2\u02dc\u019231) {
                a.warn("Safe mode active, only vanilla datapack will be loaded");
            }
            adi \u00e2\u02dc\u019232 = new adi(acw.b, new adl(), new adf(\u00e2\u02dc\u019228.a(dhz.g).toFile(), adj.c));
            bwd \u00e2\u02dc\u019233 = MinecraftServer.a(\u00e2\u02dc\u019232, \u00e2\u02dc\u019230 == null ? bwd.a : \u00e2\u02dc\u019230, \u00e2\u02dc\u019231);
            CompletableFuture<xk> \u00e2\u02dc\u019234 = xk.a(\u00e2\u02dc\u019232.f(), \u00e2\u02dc\u019216, dm.a.b, \u00e2\u02dc\u019218.a().H, ad.f(), Runnable::run);
            try {
                xk xk2 = \u00e2\u02dc\u019234.get();
            }
            catch (Exception exception) {
                a.warn("Failed to load datapacks, can't proceed with server load. You can either fix your datapacks or reset to vanilla with --safeMode", (Throwable)exception);
                \u00e2\u02dc\u019232.close();
                return;
            }
            xk2.j();
            wt<ns> wt2 = wt.a(nl.a, xk2.i(), (gx)\u00e2\u02dc\u019216);
            \u00e2\u02dc\u019218.a().a(\u00e2\u02dc\u019216);
            dii \u00e2\u02dc\u019235 = \u00e2\u02dc\u019228.a(wt2, \u00e2\u02dc\u019233);
            if (\u00e2\u02dc\u019235 == null) {
                if (optionSet.has((OptionSpec)\u00e2\u02dc\u01924)) {
                    object = MinecraftServer.i;
                    \u00e2\u02dc\u0192 = cql.a(\u00e2\u02dc\u019216);
                } else {
                    Object object2 = \u00e2\u02dc\u019218.a();
                    object = new bwu(((aat)object2).p, ((aat)object2).o, ((aat)object2).z, ((aat)object2).n, false, new bwm(), \u00e2\u02dc\u019233);
                    \u00e2\u02dc\u0192 = optionSet.has((OptionSpec)\u00e2\u02dc\u01925) ? ((aat)object2).a(\u00e2\u02dc\u019216).j() : ((aat)object2).a(\u00e2\u02dc\u019216);
                }
                \u00e2\u02dc\u019235 = new dig((bwu)object, (cql)\u00e2\u02dc\u0192, Lifecycle.stable());
            }
            if (optionSet.has((OptionSpec)\u00e2\u02dc\u01926)) {
                Main.a(\u00e2\u02dc\u019228, ahr.a(), optionSet.has((OptionSpec)\u00e2\u02dc\u01927), () -> true, \u00e2\u02dc\u019235.A().f());
            }
            \u00e2\u02dc\u019228.a(\u00e2\u02dc\u019216, \u00e2\u02dc\u019235);
            object = \u00e2\u02dc\u019235;
            \u00e2\u02dc\u0192 = MinecraftServer.a(arg_0 -> Main.a(\u00e2\u02dc\u019216, \u00e2\u02dc\u019228, \u00e2\u02dc\u019232, xk2, (dii)object, \u00e2\u02dc\u019218, \u00e2\u02dc\u019223, \u00e2\u02dc\u019224, \u00e2\u02dc\u019225, optionSet, (OptionSpec)\u00e2\u02dc\u019210, (OptionSpec)\u00e2\u02dc\u019213, (OptionSpec)\u00e2\u02dc\u01924, (OptionSpec)\u00e2\u02dc\u019214, (OptionSpec)\u00e2\u02dc\u01922, (OptionSpec)\u00e2\u02dc\u019215, arg_0));
            object2 = new Thread("Server Shutdown Thread", (aas)\u00e2\u02dc\u0192){
                final /* synthetic */ aas a;
                {
                    this.a = aas2;
                    super(string);
                }

                @Override
                public void run() {
                    this.a.a(true);
                }
            };
            ((Thread)object2).setUncaughtExceptionHandler(new t(a));
            Runtime.getRuntime().addShutdownHook((Thread)object2);
        }
        catch (Exception exception) {
            a.fatal("Failed to start the minecraft server", (Throwable)exception);
        }
    }

    private static void a(dib.a a2, DataFixer dataFixer, boolean bl2, BooleanSupplier booleanSupplier2, ImmutableSet<wv<bwq>> immutableSet) {
        a.info("Forcing world upgrade!");
        arp arp2 = new arp(a2, dataFixer, immutableSet, bl2);
        os \u00e2\u02dc\u01922 = null;
        while (!arp2.b()) {
            BooleanSupplier booleanSupplier2;
            os os2 = arp2.h();
            if (\u00e2\u02dc\u01922 != os2) {
                \u00e2\u02dc\u01922 = os2;
                a.info(arp2.h().getString());
            }
            if ((\u00e2\u02dc\u0192 = arp2.e()) > 0) {
                int n2 = arp2.f() + arp2.g();
                a.info("{}% completed ({} / {} chunks)...", (Object)ahb.d((float)n2 / (float)\u00e2\u02dc\u0192 * 100.0f), (Object)n2, (Object)\u00e2\u02dc\u0192);
            }
            if (!booleanSupplier2.getAsBoolean()) {
                arp2.a();
                continue;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private static /* synthetic */ aas a(gx.b b2, dib.a a2, adi adi2, xk xk2, dii dii2, aau aau2, MinecraftSessionService minecraftSessionService, GameProfileRepository gameProfileRepository, aed aed2, OptionSet optionSet, OptionSpec optionSpec, OptionSpec optionSpec2, OptionSpec optionSpec3, OptionSpec optionSpec4, OptionSpec optionSpec5, OptionSpec optionSpec6, Thread thread) {
        aas aas2 = new aas(thread, b2, a2, adi2, xk2, dii2, aau2, ahr.a(), minecraftSessionService, gameProfileRepository, aed2, acc::new);
        aas2.d((String)optionSet.valueOf(optionSpec));
        aas2.a((Integer)optionSet.valueOf(optionSpec2));
        aas2.c(optionSet.has(optionSpec3));
        aas2.b((String)optionSet.valueOf(optionSpec4));
        boolean bl2 = \u00e2\u02dc\u0192 = !optionSet.has(optionSpec5) && !optionSet.valuesOf(optionSpec6).contains("nogui");
        if (\u00e2\u02dc\u0192 && !GraphicsEnvironment.isHeadless()) {
            aas2.bh();
        }
        return aas2;
    }
}

