/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.blaze3d.systems;

import com.google.common.collect.Queues;
import com.mojang.blaze3d.platform.GLX;
import com.mojang.blaze3d.platform.GlStateManager;
import it.unimi.dsi.fastutil.ints.IntConsumer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Consumer;
import java.util.function.IntSupplier;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWErrorCallbackI;

@dof
public class RenderSystem {
    static final Logger LOGGER = LogManager.getLogger();
    private static final ConcurrentLinkedQueue<dow> recordingQueue = Queues.newConcurrentLinkedQueue();
    private static final dqn RENDER_THREAD_TESSELATOR = new dqn();
    private static final int MINIMUM_ATLAS_TEXTURE_SIZE = 1024;
    private static boolean isReplayingQueue;
    @Nullable
    private static Thread gameThread;
    @Nullable
    private static Thread renderThread;
    private static int MAX_SUPPORTED_TEXTURE_SIZE;
    private static boolean isInInit;
    private static double lastDrawTime;
    private static final a sharedSequential;
    private static final a sharedSequentialQuad;
    private static final a sharedSequentialLines;
    private static d projectionMatrix;
    private static d savedProjectionMatrix;
    private static dql modelViewStack;
    private static d modelViewMatrix;
    private static d textureMatrix;
    private static final int[] shaderTextures;
    private static final float[] shaderColor;
    private static float shaderFogStart;
    private static float shaderFogEnd;
    private static final float[] shaderFogColor;
    private static final k[] shaderLightDirections;
    private static float shaderGameTime;
    private static float shaderLineWidth;
    @Nullable
    private static ent shader;

    public static void initRenderThread() {
        if (renderThread != null || gameThread == Thread.currentThread()) {
            throw new IllegalStateException("Could not initialize render thread");
        }
        renderThread = Thread.currentThread();
    }

    public static boolean isOnRenderThread() {
        return Thread.currentThread() == renderThread;
    }

    public static boolean isOnRenderThreadOrInit() {
        return isInInit || RenderSystem.isOnRenderThread();
    }

    public static void initGameThread(boolean bl2) {
        boolean bl3 = \u00e2\u02dc\u0192 = renderThread == Thread.currentThread();
        if (gameThread != null || renderThread == null || \u00e2\u02dc\u0192 == bl2) {
            throw new IllegalStateException("Could not initialize tick thread");
        }
        gameThread = Thread.currentThread();
    }

    public static boolean isOnGameThread() {
        return true;
    }

    public static boolean isOnGameThreadOrInit() {
        return isInInit || RenderSystem.isOnGameThread();
    }

    public static void assertThread(Supplier<Boolean> supplier) {
        if (!supplier.get().booleanValue()) {
            throw new IllegalStateException("Rendersystem called from wrong thread");
        }
    }

    public static boolean isInInitPhase() {
        return true;
    }

    public static void recordRenderCall(dow dow2) {
        recordingQueue.add(dow2);
    }

    public static void flipFrame(long l2) {
        GLFW.glfwPollEvents();
        RenderSystem.replayQueue();
        dqn.a().c().f();
        GLFW.glfwSwapBuffers((long)l2);
        GLFW.glfwPollEvents();
    }

    public static void replayQueue() {
        isReplayingQueue = true;
        while (!recordingQueue.isEmpty()) {
            dow dow2 = recordingQueue.poll();
            dow2.execute();
        }
        isReplayingQueue = false;
    }

    public static void limitDisplayFPS(int n2) {
        double d2 = lastDrawTime + 1.0 / (double)n2;
        \u00e2\u02dc\u0192 = GLFW.glfwGetTime();
        while (\u00e2\u02dc\u0192 < d2) {
            GLFW.glfwWaitEventsTimeout((double)(d2 - \u00e2\u02dc\u0192));
            \u00e2\u02dc\u0192 = GLFW.glfwGetTime();
        }
        lastDrawTime = \u00e2\u02dc\u0192;
    }

    public static void disableDepthTest() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager._disableDepthTest();
    }

    public static void enableDepthTest() {
        RenderSystem.assertThread(RenderSystem::isOnGameThreadOrInit);
        GlStateManager._enableDepthTest();
    }

    public static void enableScissor(int n2, int n3, int n4, int n5) {
        RenderSystem.assertThread(RenderSystem::isOnGameThreadOrInit);
        GlStateManager._enableScissorTest();
        GlStateManager._scissorBox(n2, n3, n4, n5);
    }

    public static void disableScissor() {
        RenderSystem.assertThread(RenderSystem::isOnGameThreadOrInit);
        GlStateManager._disableScissorTest();
    }

    public static void depthFunc(int n2) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager._depthFunc(n2);
    }

    public static void depthMask(boolean bl2) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager._depthMask(bl2);
    }

    public static void enableBlend() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager._enableBlend();
    }

    public static void disableBlend() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager._disableBlend();
    }

    public static void blendFunc(GlStateManager.SourceFactor sourceFactor, GlStateManager.DestFactor destFactor) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager._blendFunc(sourceFactor.value, destFactor.value);
    }

    public static void blendFunc(int n2, int n3) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager._blendFunc(n2, n3);
    }

    public static void blendFuncSeparate(GlStateManager.SourceFactor sourceFactor, GlStateManager.DestFactor destFactor, GlStateManager.SourceFactor sourceFactor2, GlStateManager.DestFactor destFactor2) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager._blendFuncSeparate(sourceFactor.value, destFactor.value, sourceFactor2.value, destFactor2.value);
    }

    public static void blendFuncSeparate(int n2, int n3, int n4, int n5) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager._blendFuncSeparate(n2, n3, n4, n5);
    }

    public static void blendEquation(int n2) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager._blendEquation(n2);
    }

    public static void enableCull() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager._enableCull();
    }

    public static void disableCull() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager._disableCull();
    }

    public static void polygonMode(int n2, int n3) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager._polygonMode(n2, n3);
    }

    public static void enablePolygonOffset() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager._enablePolygonOffset();
    }

    public static void disablePolygonOffset() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager._disablePolygonOffset();
    }

    public static void polygonOffset(float f2, float f3) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager._polygonOffset(f2, f3);
    }

    public static void enableColorLogicOp() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager._enableColorLogicOp();
    }

    public static void disableColorLogicOp() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager._disableColorLogicOp();
    }

    public static void logicOp(GlStateManager.g g2) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager._logicOp(g2.q);
    }

    public static void activeTexture(int n2) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager._activeTexture(n2);
    }

    public static void enableTexture() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager._enableTexture();
    }

    public static void disableTexture() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager._disableTexture();
    }

    public static void texParameter(int n2, int n3, int n4) {
        GlStateManager._texParameter(n2, n3, n4);
    }

    public static void deleteTexture(int n2) {
        RenderSystem.assertThread(RenderSystem::isOnGameThreadOrInit);
        GlStateManager._deleteTexture(n2);
    }

    public static void bindTextureForSetup(int n2) {
        RenderSystem.bindTexture(n2);
    }

    public static void bindTexture(int n2) {
        GlStateManager._bindTexture(n2);
    }

    public static void viewport(int n2, int n3, int n4, int n5) {
        RenderSystem.assertThread(RenderSystem::isOnGameThreadOrInit);
        GlStateManager._viewport(n2, n3, n4, n5);
    }

    public static void colorMask(boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager._colorMask(bl2, bl3, bl4, bl5);
    }

    public static void stencilFunc(int n2, int n3, int n4) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager._stencilFunc(n2, n3, n4);
    }

    public static void stencilMask(int n2) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager._stencilMask(n2);
    }

    public static void stencilOp(int n2, int n3, int n4) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager._stencilOp(n2, n3, n4);
    }

    public static void clearDepth(double d2) {
        RenderSystem.assertThread(RenderSystem::isOnGameThreadOrInit);
        GlStateManager._clearDepth(d2);
    }

    public static void clearColor(float f2, float f3, float f4, float f5) {
        RenderSystem.assertThread(RenderSystem::isOnGameThreadOrInit);
        GlStateManager._clearColor(f2, f3, f4, f5);
    }

    public static void clearStencil(int n2) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager._clearStencil(n2);
    }

    public static void clear(int n2, boolean bl2) {
        RenderSystem.assertThread(RenderSystem::isOnGameThreadOrInit);
        GlStateManager._clear(n2, bl2);
    }

    public static void setShaderFogStart(float f2) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        RenderSystem._setShaderFogStart(f2);
    }

    private static void _setShaderFogStart(float f2) {
        shaderFogStart = f2;
    }

    public static float getShaderFogStart() {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        return shaderFogStart;
    }

    public static void setShaderFogEnd(float f2) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        RenderSystem._setShaderFogEnd(f2);
    }

    private static void _setShaderFogEnd(float f2) {
        shaderFogEnd = f2;
    }

    public static float getShaderFogEnd() {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        return shaderFogEnd;
    }

    public static void setShaderFogColor(float f2, float f3, float f4, float f5) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        RenderSystem._setShaderFogColor(f2, f3, f4, f5);
    }

    public static void setShaderFogColor(float f2, float f3, float f4) {
        RenderSystem.setShaderFogColor(f2, f3, f4, 1.0f);
    }

    private static void _setShaderFogColor(float f2, float f3, float f4, float f5) {
        RenderSystem.shaderFogColor[0] = f2;
        RenderSystem.shaderFogColor[1] = f3;
        RenderSystem.shaderFogColor[2] = f4;
        RenderSystem.shaderFogColor[3] = f5;
    }

    public static float[] getShaderFogColor() {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        return shaderFogColor;
    }

    public static void setShaderLights(k k2, k k3) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        RenderSystem._setShaderLights(k2, k3);
    }

    public static void _setShaderLights(k k2, k k3) {
        RenderSystem.shaderLightDirections[0] = k2;
        RenderSystem.shaderLightDirections[1] = k3;
    }

    public static void setupShaderLights(ent ent2) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        if (ent2.f != null) {
            ent2.f.a(shaderLightDirections[0]);
        }
        if (ent2.g != null) {
            ent2.g.a(shaderLightDirections[1]);
        }
    }

    public static void setShaderColor(float f2, float f3, float f4, float f5) {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> RenderSystem._setShaderColor(f2, f3, f4, f5));
        } else {
            RenderSystem._setShaderColor(f2, f3, f4, f5);
        }
    }

    private static void _setShaderColor(float f2, float f3, float f4, float f5) {
        RenderSystem.shaderColor[0] = f2;
        RenderSystem.shaderColor[1] = f3;
        RenderSystem.shaderColor[2] = f4;
        RenderSystem.shaderColor[3] = f5;
    }

    public static float[] getShaderColor() {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        return shaderColor;
    }

    public static void drawElements(int n2, int n3, int n4) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager._drawElements(n2, n3, n4, 0L);
    }

    public static void lineWidth(float f2) {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> {
                shaderLineWidth = f2;
            });
        } else {
            shaderLineWidth = f2;
        }
    }

    public static float getShaderLineWidth() {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        return shaderLineWidth;
    }

    public static void pixelStore(int n2, int n3) {
        RenderSystem.assertThread(RenderSystem::isOnGameThreadOrInit);
        GlStateManager._pixelStore(n2, n3);
    }

    public static void readPixels(int n2, int n3, int n4, int n5, int n6, int n7, ByteBuffer byteBuffer) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager._readPixels(n2, n3, n4, n5, n6, n7, byteBuffer);
    }

    public static void getString(int n2, Consumer<String> consumer) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        consumer.accept(GlStateManager._getString(n2));
    }

    public static String getBackendDescription() {
        RenderSystem.assertThread(RenderSystem::isInInitPhase);
        return String.format("LWJGL version %s", GLX._getLWJGLVersion());
    }

    public static String getApiDescription() {
        RenderSystem.assertThread(RenderSystem::isInInitPhase);
        return GLX.getOpenGLVersionString();
    }

    public static LongSupplier initBackendSystem() {
        RenderSystem.assertThread(RenderSystem::isInInitPhase);
        return GLX._initGlfw();
    }

    public static void initRenderer(int n2, boolean bl2) {
        RenderSystem.assertThread(RenderSystem::isInInitPhase);
        GLX._init(n2, bl2);
    }

    public static void setErrorCallback(GLFWErrorCallbackI gLFWErrorCallbackI) {
        RenderSystem.assertThread(RenderSystem::isInInitPhase);
        GLX._setGlfwErrorCallback(gLFWErrorCallbackI);
    }

    public static void renderCrosshair(int n2) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GLX._renderCrosshair(n2, true, true, true);
    }

    public static String getCapsString() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        return "Using framebuffer using OpenGL 3.2";
    }

    public static void setupDefaultState(int n2, int n3, int n4, int n5) {
        RenderSystem.assertThread(RenderSystem::isInInitPhase);
        GlStateManager._enableTexture();
        GlStateManager._clearDepth(1.0);
        GlStateManager._enableDepthTest();
        GlStateManager._depthFunc(515);
        projectionMatrix.b();
        savedProjectionMatrix.b();
        modelViewMatrix.b();
        textureMatrix.b();
        GlStateManager._viewport(n2, n3, n4, n5);
    }

    public static int maxSupportedTextureSize() {
        if (MAX_SUPPORTED_TEXTURE_SIZE == -1) {
            RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
            int n2 = GlStateManager._getInteger(3379);
            for (\u00e2\u02dc\u0192 = Math.max(32768, n2); \u00e2\u02dc\u0192 >= 1024; \u00e2\u02dc\u0192 >>= 1) {
                GlStateManager._texImage2D(32868, 0, 6408, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192, 0, 6408, 5121, null);
                \u00e2\u02dc\u0192 = GlStateManager._getTexLevelParameter(32868, 0, 4096);
                if (\u00e2\u02dc\u0192 == 0) continue;
                MAX_SUPPORTED_TEXTURE_SIZE = \u00e2\u02dc\u0192;
                return \u00e2\u02dc\u0192;
            }
            MAX_SUPPORTED_TEXTURE_SIZE = Math.max(n2, 1024);
            LOGGER.info("Failed to determine maximum texture size by probing, trying GL_MAX_TEXTURE_SIZE = {}", (Object)MAX_SUPPORTED_TEXTURE_SIZE);
        }
        return MAX_SUPPORTED_TEXTURE_SIZE;
    }

    public static void glBindBuffer(int n2, IntSupplier intSupplier) {
        GlStateManager._glBindBuffer(n2, intSupplier.getAsInt());
    }

    public static void glBindVertexArray(Supplier<Integer> supplier) {
        GlStateManager._glBindVertexArray(supplier.get());
    }

    public static void glBufferData(int n2, ByteBuffer byteBuffer, int n3) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        GlStateManager._glBufferData(n2, byteBuffer, n3);
    }

    public static void glDeleteBuffers(int n2) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager._glDeleteBuffers(n2);
    }

    public static void glDeleteVertexArrays(int n2) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager._glDeleteVertexArrays(n2);
    }

    public static void glUniform1i(int n2, int n3) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager._glUniform1i(n2, n3);
    }

    public static void glUniform1(int n2, IntBuffer intBuffer) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager._glUniform1(n2, intBuffer);
    }

    public static void glUniform2(int n2, IntBuffer intBuffer) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager._glUniform2(n2, intBuffer);
    }

    public static void glUniform3(int n2, IntBuffer intBuffer) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager._glUniform3(n2, intBuffer);
    }

    public static void glUniform4(int n2, IntBuffer intBuffer) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager._glUniform4(n2, intBuffer);
    }

    public static void glUniform1(int n2, FloatBuffer floatBuffer) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager._glUniform1(n2, floatBuffer);
    }

    public static void glUniform2(int n2, FloatBuffer floatBuffer) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager._glUniform2(n2, floatBuffer);
    }

    public static void glUniform3(int n2, FloatBuffer floatBuffer) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager._glUniform3(n2, floatBuffer);
    }

    public static void glUniform4(int n2, FloatBuffer floatBuffer) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager._glUniform4(n2, floatBuffer);
    }

    public static void glUniformMatrix2(int n2, boolean bl2, FloatBuffer floatBuffer) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager._glUniformMatrix2(n2, bl2, floatBuffer);
    }

    public static void glUniformMatrix3(int n2, boolean bl2, FloatBuffer floatBuffer) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager._glUniformMatrix3(n2, bl2, floatBuffer);
    }

    public static void glUniformMatrix4(int n2, boolean bl2, FloatBuffer floatBuffer) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager._glUniformMatrix4(n2, bl2, floatBuffer);
    }

    public static void setupOverlayColor(IntSupplier intSupplier, int n2) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        \u00e2\u02dc\u0192 = intSupplier.getAsInt();
        RenderSystem.setShaderTexture(1, \u00e2\u02dc\u0192);
    }

    public static void teardownOverlayColor() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        RenderSystem.setShaderTexture(1, 0);
    }

    public static void setupLevelDiffuseLighting(k k2, k k3, d d2) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.setupLevelDiffuseLighting(k2, k3, d2);
    }

    public static void setupGuiFlatDiffuseLighting(k k2, k k3) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.setupGuiFlatDiffuseLighting(k2, k3);
    }

    public static void setupGui3DDiffuseLighting(k k2, k k3) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.setupGui3DDiffuseLighting(k2, k3);
    }

    public static void beginInitialization() {
        isInInit = true;
    }

    public static void finishInitialization() {
        isInInit = false;
        if (!recordingQueue.isEmpty()) {
            RenderSystem.replayQueue();
        }
        if (!recordingQueue.isEmpty()) {
            throw new IllegalStateException("Recorded to render queue during initialization");
        }
    }

    public static void glGenBuffers(Consumer<Integer> consumer) {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> consumer.accept(GlStateManager._glGenBuffers()));
        } else {
            consumer.accept(GlStateManager._glGenBuffers());
        }
    }

    public static void glGenVertexArrays(Consumer<Integer> consumer) {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> consumer.accept(GlStateManager._glGenVertexArrays()));
        } else {
            consumer.accept(GlStateManager._glGenVertexArrays());
        }
    }

    public static dqn renderThreadTesselator() {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        return RENDER_THREAD_TESSELATOR;
    }

    public static void defaultBlendFunc() {
        RenderSystem.blendFuncSeparate(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, GlStateManager.SourceFactor.ONE, GlStateManager.DestFactor.ZERO);
    }

    @Deprecated
    public static void runAsFancy(Runnable runnable) {
        boolean bl2 = dvp.A();
        if (!bl2) {
            runnable.run();
            return;
        }
        dvt \u00e2\u02dc\u01922 = dvp.C().l;
        dvj \u00e2\u02dc\u01923 = \u00e2\u02dc\u01922.m;
        \u00e2\u02dc\u01922.m = dvj.b;
        runnable.run();
        \u00e2\u02dc\u01922.m = \u00e2\u02dc\u01923;
    }

    public static void setShader(Supplier<ent> supplier) {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> {
                shader = (ent)supplier.get();
            });
        } else {
            shader = supplier.get();
        }
    }

    @Nullable
    public static ent getShader() {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        return shader;
    }

    public static int getTextureId(int n2) {
        return GlStateManager._getTextureId(n2);
    }

    public static void setShaderTexture(int n2, ww ww2) {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> RenderSystem._setShaderTexture(n2, ww2));
        } else {
            RenderSystem._setShaderTexture(n2, ww2);
        }
    }

    public static void _setShaderTexture(int n2, ww ww2) {
        if (n2 >= 0 && n2 < shaderTextures.length) {
            exn exn2 = dvp.C().M();
            exa \u00e2\u02dc\u01922 = exn2.b(ww2);
            RenderSystem.shaderTextures[n2] = \u00e2\u02dc\u01922.b();
        }
    }

    public static void setShaderTexture(int n2, int n3) {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> RenderSystem._setShaderTexture(n2, n3));
        } else {
            RenderSystem._setShaderTexture(n2, n3);
        }
    }

    public static void _setShaderTexture(int n2, int n3) {
        if (n2 >= 0 && n2 < shaderTextures.length) {
            RenderSystem.shaderTextures[n2] = n3;
        }
    }

    public static int getShaderTexture(int n2) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        if (n2 >= 0 && n2 < shaderTextures.length) {
            return shaderTextures[n2];
        }
        return 0;
    }

    public static void setProjectionMatrix(d d2) {
        \u00e2\u02dc\u0192 = d2.h();
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> {
                projectionMatrix = \u00e2\u02dc\u0192;
            });
        } else {
            projectionMatrix = \u00e2\u02dc\u0192;
        }
    }

    public static void setTextureMatrix(d d2) {
        \u00e2\u02dc\u0192 = d2.h();
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> {
                textureMatrix = \u00e2\u02dc\u0192;
            });
        } else {
            textureMatrix = \u00e2\u02dc\u0192;
        }
    }

    public static void resetTextureMatrix() {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> textureMatrix.b());
        } else {
            textureMatrix.b();
        }
    }

    public static void applyModelViewMatrix() {
        d d2 = modelViewStack.c().a().h();
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> {
                modelViewMatrix = d2;
            });
        } else {
            modelViewMatrix = d2;
        }
    }

    public static void backupProjectionMatrix() {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> RenderSystem._backupProjectionMatrix());
        } else {
            RenderSystem._backupProjectionMatrix();
        }
    }

    private static void _backupProjectionMatrix() {
        savedProjectionMatrix = projectionMatrix;
    }

    public static void restoreProjectionMatrix() {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> RenderSystem._restoreProjectionMatrix());
        } else {
            RenderSystem._restoreProjectionMatrix();
        }
    }

    private static void _restoreProjectionMatrix() {
        projectionMatrix = savedProjectionMatrix;
    }

    public static d getProjectionMatrix() {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        return projectionMatrix;
    }

    public static d getModelViewMatrix() {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        return modelViewMatrix;
    }

    public static dql getModelViewStack() {
        return modelViewStack;
    }

    public static d getTextureMatrix() {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        return textureMatrix;
    }

    public static a getSequentialBuffer(dqq.b b2, int n2) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        a a2 = b2 == dqq.b.h ? sharedSequentialQuad : (b2 == dqq.b.a ? sharedSequentialLines : sharedSequential);
        a2.a(n2);
        return a2;
    }

    public static void setShaderGameTime(long l2, float f2) {
        \u00e2\u02dc\u0192 = ((float)(l2 % 24000L) + f2) / 24000.0f;
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> {
                shaderGameTime = \u00e2\u02dc\u0192;
            });
        } else {
            shaderGameTime = \u00e2\u02dc\u0192;
        }
    }

    public static float getShaderGameTime() {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        return shaderGameTime;
    }

    private static /* synthetic */ void lambda$setupGui3DDiffuseLighting$57(k k2, k k3) {
        GlStateManager.setupGui3DDiffuseLighting(k2, k3);
    }

    private static /* synthetic */ void lambda$setupGuiFlatDiffuseLighting$56(k k2, k k3) {
        GlStateManager.setupGuiFlatDiffuseLighting(k2, k3);
    }

    private static /* synthetic */ void lambda$setupLevelDiffuseLighting$55(k k2, k k3, d d2) {
        GlStateManager.setupLevelDiffuseLighting(k2, k3, d2);
    }

    private static /* synthetic */ void lambda$teardownOverlayColor$54() {
        RenderSystem.setShaderTexture(1, 0);
    }

    private static /* synthetic */ void lambda$setupOverlayColor$53(IntSupplier intSupplier) {
        int n2 = intSupplier.getAsInt();
        RenderSystem.setShaderTexture(1, n2);
    }

    private static /* synthetic */ void lambda$glUniformMatrix4$52(int n2, boolean bl2, FloatBuffer floatBuffer) {
        GlStateManager._glUniformMatrix4(n2, bl2, floatBuffer);
    }

    private static /* synthetic */ void lambda$glUniformMatrix3$51(int n2, boolean bl2, FloatBuffer floatBuffer) {
        GlStateManager._glUniformMatrix3(n2, bl2, floatBuffer);
    }

    private static /* synthetic */ void lambda$glUniformMatrix2$50(int n2, boolean bl2, FloatBuffer floatBuffer) {
        GlStateManager._glUniformMatrix2(n2, bl2, floatBuffer);
    }

    private static /* synthetic */ void lambda$glUniform4$49(int n2, FloatBuffer floatBuffer) {
        GlStateManager._glUniform4(n2, floatBuffer);
    }

    private static /* synthetic */ void lambda$glUniform3$48(int n2, FloatBuffer floatBuffer) {
        GlStateManager._glUniform3(n2, floatBuffer);
    }

    private static /* synthetic */ void lambda$glUniform2$47(int n2, FloatBuffer floatBuffer) {
        GlStateManager._glUniform2(n2, floatBuffer);
    }

    private static /* synthetic */ void lambda$glUniform1$46(int n2, FloatBuffer floatBuffer) {
        GlStateManager._glUniform1(n2, floatBuffer);
    }

    private static /* synthetic */ void lambda$glUniform4$45(int n2, IntBuffer intBuffer) {
        GlStateManager._glUniform4(n2, intBuffer);
    }

    private static /* synthetic */ void lambda$glUniform3$44(int n2, IntBuffer intBuffer) {
        GlStateManager._glUniform3(n2, intBuffer);
    }

    private static /* synthetic */ void lambda$glUniform2$43(int n2, IntBuffer intBuffer) {
        GlStateManager._glUniform2(n2, intBuffer);
    }

    private static /* synthetic */ void lambda$glUniform1$42(int n2, IntBuffer intBuffer) {
        GlStateManager._glUniform1(n2, intBuffer);
    }

    private static /* synthetic */ void lambda$glUniform1i$41(int n2, int n3) {
        GlStateManager._glUniform1i(n2, n3);
    }

    private static /* synthetic */ void lambda$glDeleteVertexArrays$40(int n2) {
        GlStateManager._glDeleteVertexArrays(n2);
    }

    private static /* synthetic */ void lambda$glDeleteBuffers$39(int n2) {
        GlStateManager._glDeleteBuffers(n2);
    }

    private static /* synthetic */ void lambda$glBindVertexArray$38(Supplier supplier) {
        GlStateManager._glBindVertexArray((Integer)supplier.get());
    }

    private static /* synthetic */ void lambda$glBindBuffer$37(int n2, IntSupplier intSupplier) {
        GlStateManager._glBindBuffer(n2, intSupplier.getAsInt());
    }

    private static /* synthetic */ void lambda$renderCrosshair$36(int n2) {
        GLX._renderCrosshair(n2, true, true, true);
    }

    private static /* synthetic */ void lambda$getString$35(int n2, Consumer consumer) {
        String string = GlStateManager._getString(n2);
        consumer.accept(string);
    }

    private static /* synthetic */ void lambda$readPixels$34(int n2, int n3, int n4, int n5, int n6, int n7, ByteBuffer byteBuffer) {
        GlStateManager._readPixels(n2, n3, n4, n5, n6, n7, byteBuffer);
    }

    private static /* synthetic */ void lambda$pixelStore$33(int n2, int n3) {
        GlStateManager._pixelStore(n2, n3);
    }

    private static /* synthetic */ void lambda$drawElements$31(int n2, int n3, int n4) {
        GlStateManager._drawElements(n2, n3, n4, 0L);
    }

    private static /* synthetic */ void lambda$setShaderLights$29(k k2, k k3) {
        RenderSystem._setShaderLights(k2, k3);
    }

    private static /* synthetic */ void lambda$setShaderFogColor$28(float f2, float f3, float f4, float f5) {
        RenderSystem._setShaderFogColor(f2, f3, f4, f5);
    }

    private static /* synthetic */ void lambda$setShaderFogEnd$27(float f2) {
        RenderSystem._setShaderFogEnd(f2);
    }

    private static /* synthetic */ void lambda$setShaderFogStart$26(float f2) {
        RenderSystem._setShaderFogStart(f2);
    }

    private static /* synthetic */ void lambda$clear$25(int n2, boolean bl2) {
        GlStateManager._clear(n2, bl2);
    }

    private static /* synthetic */ void lambda$clearStencil$24(int n2) {
        GlStateManager._clearStencil(n2);
    }

    private static /* synthetic */ void lambda$clearColor$23(float f2, float f3, float f4, float f5) {
        GlStateManager._clearColor(f2, f3, f4, f5);
    }

    private static /* synthetic */ void lambda$clearDepth$22(double d2) {
        GlStateManager._clearDepth(d2);
    }

    private static /* synthetic */ void lambda$stencilOp$21(int n2, int n3, int n4) {
        GlStateManager._stencilOp(n2, n3, n4);
    }

    private static /* synthetic */ void lambda$stencilMask$20(int n2) {
        GlStateManager._stencilMask(n2);
    }

    private static /* synthetic */ void lambda$stencilFunc$19(int n2, int n3, int n4) {
        GlStateManager._stencilFunc(n2, n3, n4);
    }

    private static /* synthetic */ void lambda$colorMask$18(boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        GlStateManager._colorMask(bl2, bl3, bl4, bl5);
    }

    private static /* synthetic */ void lambda$viewport$17(int n2, int n3, int n4, int n5) {
        GlStateManager._viewport(n2, n3, n4, n5);
    }

    private static /* synthetic */ void lambda$bindTexture$16(int n2) {
        GlStateManager._bindTexture(n2);
    }

    private static /* synthetic */ void lambda$deleteTexture$15(int n2) {
        GlStateManager._deleteTexture(n2);
    }

    private static /* synthetic */ void lambda$texParameter$14(int n2, int n3, int n4) {
        GlStateManager._texParameter(n2, n3, n4);
    }

    private static /* synthetic */ void lambda$activeTexture$13(int n2) {
        GlStateManager._activeTexture(n2);
    }

    private static /* synthetic */ void lambda$logicOp$12(GlStateManager.g g2) {
        GlStateManager._logicOp(g2.q);
    }

    private static /* synthetic */ void lambda$polygonOffset$11(float f2, float f3) {
        GlStateManager._polygonOffset(f2, f3);
    }

    private static /* synthetic */ void lambda$polygonMode$10(int n2, int n3) {
        GlStateManager._polygonMode(n2, n3);
    }

    private static /* synthetic */ void lambda$blendEquation$9(int n2) {
        GlStateManager._blendEquation(n2);
    }

    private static /* synthetic */ void lambda$blendFuncSeparate$8(int n2, int n3, int n4, int n5) {
        GlStateManager._blendFuncSeparate(n2, n3, n4, n5);
    }

    private static /* synthetic */ void lambda$blendFuncSeparate$7(GlStateManager.SourceFactor sourceFactor, GlStateManager.DestFactor destFactor, GlStateManager.SourceFactor sourceFactor2, GlStateManager.DestFactor destFactor2) {
        GlStateManager._blendFuncSeparate(sourceFactor.value, destFactor.value, sourceFactor2.value, destFactor2.value);
    }

    private static /* synthetic */ void lambda$blendFunc$6(int n2, int n3) {
        GlStateManager._blendFunc(n2, n3);
    }

    private static /* synthetic */ void lambda$blendFunc$5(GlStateManager.SourceFactor sourceFactor, GlStateManager.DestFactor destFactor) {
        GlStateManager._blendFunc(sourceFactor.value, destFactor.value);
    }

    private static /* synthetic */ void lambda$depthMask$4(boolean bl2) {
        GlStateManager._depthMask(bl2);
    }

    private static /* synthetic */ void lambda$depthFunc$3(int n2) {
        GlStateManager._depthFunc(n2);
    }

    private static /* synthetic */ void lambda$enableScissor$2(int n2, int n3, int n4, int n5) {
        GlStateManager._enableScissorTest();
        GlStateManager._scissorBox(n2, n3, n4, n5);
    }

    static {
        MAX_SUPPORTED_TEXTURE_SIZE = -1;
        lastDrawTime = Double.MIN_VALUE;
        sharedSequential = new a(1, 1, java.util.function.IntConsumer::accept);
        sharedSequentialQuad = new a(4, 6, (intConsumer, n2) -> {
            intConsumer.accept(n2 + 0);
            intConsumer.accept(n2 + 1);
            intConsumer.accept(n2 + 2);
            intConsumer.accept(n2 + 2);
            intConsumer.accept(n2 + 3);
            intConsumer.accept(n2 + 0);
        });
        sharedSequentialLines = new a(4, 6, (intConsumer, n2) -> {
            intConsumer.accept(n2 + 0);
            intConsumer.accept(n2 + 1);
            intConsumer.accept(n2 + 2);
            intConsumer.accept(n2 + 3);
            intConsumer.accept(n2 + 2);
            intConsumer.accept(n2 + 1);
        });
        projectionMatrix = new d();
        savedProjectionMatrix = new d();
        modelViewStack = new dql();
        modelViewMatrix = new d();
        textureMatrix = new d();
        shaderTextures = new int[12];
        shaderColor = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
        shaderFogEnd = 1.0f;
        shaderFogColor = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
        shaderLightDirections = new k[2];
        shaderLineWidth = 1.0f;
        projectionMatrix.b();
        savedProjectionMatrix.b();
        modelViewMatrix.b();
        textureMatrix.b();
    }

    public static final class com.mojang.blaze3d.systems.RenderSystem$a {
        private final int a;
        private final int b;
        private final a c;
        private int d;
        private dqq.a e = dqq.a.a;
        private int f;

        com.mojang.blaze3d.systems.RenderSystem$a(int n2, int n3, a a2) {
            this.a = n2;
            this.b = n3;
            this.c = a2;
        }

        void a(int n22) {
            int n22;
            if (n22 <= this.f) {
                return;
            }
            n22 = ahb.d(n22 * 2, this.b);
            LOGGER.debug("Growing IndexBuffer: Old limit {}, new limit {}.", (Object)this.f, (Object)n22);
            if (this.d == 0) {
                this.d = GlStateManager._glGenBuffers();
            }
            dqq.a a2 = dqq.a.a(n22);
            int \u00e2\u02dc\u01922 = ahb.d(n22 * a2.e, 4);
            GlStateManager._glBindBuffer(34963, this.d);
            GlStateManager._glBufferData(34963, \u00e2\u02dc\u01922, 35048);
            ByteBuffer \u00e2\u02dc\u01923 = GlStateManager._glMapBuffer(34963, 35001);
            if (\u00e2\u02dc\u01923 == null) {
                throw new RuntimeException("Failed to map GL buffer");
            }
            this.e = a2;
            IntConsumer \u00e2\u02dc\u01924 = this.a(\u00e2\u02dc\u01923);
            for (int i2 = 0; i2 < n22; i2 += this.b) {
                this.c.accept(\u00e2\u02dc\u01924, i2 * this.a / this.b);
            }
            GlStateManager._glUnmapBuffer(34963);
            GlStateManager._glBindBuffer(34963, 0);
            this.f = n22;
            dqh.b();
        }

        private IntConsumer a(ByteBuffer byteBuffer) {
            switch (this.e) {
                case a: {
                    return n2 -> byteBuffer.put((byte)n2);
                }
                case b: {
                    return n2 -> byteBuffer.putShort((short)n2);
                }
            }
            return byteBuffer::putInt;
        }

        public int a() {
            return this.d;
        }

        public dqq.a b() {
            return this.e;
        }

        static interface a {
            public void accept(IntConsumer var1, int var2);
        }
    }
}

