/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.blaze3d.platform;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nullable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.opengl.GL11;
import org.lwjgl.system.MemoryUtil;

@dof
public class TextureUtil {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final int MIN_MIPMAP_LEVEL = 0;
    private static final int DEFAULT_IMAGE_BUFFER_SIZE = 8192;

    public static int generateTextureId() {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        if (ab.aF) {
            int[] nArray = new int[ThreadLocalRandom.current().nextInt(15) + 1];
            GlStateManager._genTextures(nArray);
            int \u00e2\u02dc\u01922 = GlStateManager._genTexture();
            GlStateManager._deleteTextures(nArray);
            return \u00e2\u02dc\u01922;
        }
        return GlStateManager._genTexture();
    }

    public static void releaseTextureId(int n2) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        GlStateManager._deleteTexture(n2);
    }

    public static void prepareImage(int n2, int n3, int n4) {
        TextureUtil.prepareImage(dpm.b.a, n2, 0, n3, n4);
    }

    public static void prepareImage(dpm.b b2, int n2, int n3, int n4) {
        TextureUtil.prepareImage(b2, n2, 0, n3, n4);
    }

    public static void prepareImage(int n2, int n3, int n4, int n5) {
        TextureUtil.prepareImage(dpm.b.a, n2, n3, n4, n5);
    }

    public static void prepareImage(dpm.b b2, int n2, int n3, int n4, int n5) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        TextureUtil.bind(n2);
        if (n3 >= 0) {
            GlStateManager._texParameter(3553, 33085, n3);
            GlStateManager._texParameter(3553, 33082, 0);
            GlStateManager._texParameter(3553, 33083, n3);
            GlStateManager._texParameter(3553, 34049, 0.0f);
        }
        for (\u00e2\u02dc\u0192 = 0; \u00e2\u02dc\u0192 <= n3; ++\u00e2\u02dc\u0192) {
            GlStateManager._texImage2D(3553, \u00e2\u02dc\u0192, b2.a(), n4 >> \u00e2\u02dc\u0192, n5 >> \u00e2\u02dc\u0192, 0, 6408, 5121, null);
        }
    }

    private static void bind(int n2) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        GlStateManager._bindTexture(n2);
    }

    public static ByteBuffer readResource(InputStream inputStream) throws IOException {
        ByteBuffer \u00e2\u02dc\u01923;
        if (inputStream instanceof FileInputStream) {
            FileInputStream fileInputStream = (FileInputStream)inputStream;
            FileChannel \u00e2\u02dc\u01922 = fileInputStream.getChannel();
            \u00e2\u02dc\u01923 = MemoryUtil.memAlloc((int)((int)\u00e2\u02dc\u01922.size() + 1));
            while (\u00e2\u02dc\u01922.read(\u00e2\u02dc\u01923) != -1) {
            }
        } else {
            \u00e2\u02dc\u01923 = MemoryUtil.memAlloc((int)8192);
            ReadableByteChannel \u00e2\u02dc\u01924 = Channels.newChannel(inputStream);
            while (\u00e2\u02dc\u01924.read(\u00e2\u02dc\u01923) != -1) {
                if (\u00e2\u02dc\u01923.remaining() != 0) continue;
                \u00e2\u02dc\u01923 = MemoryUtil.memRealloc((ByteBuffer)\u00e2\u02dc\u01923, (int)(\u00e2\u02dc\u01923.capacity() * 2));
            }
        }
        return \u00e2\u02dc\u01923;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static String readResourceAsString(InputStream inputStream) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        ByteBuffer byteBuffer = null;
        try {
            byteBuffer = TextureUtil.readResource(inputStream);
            int n2 = byteBuffer.position();
            byteBuffer.rewind();
            String string = MemoryUtil.memASCII((ByteBuffer)byteBuffer, (int)n2);
            return string;
        }
        catch (IOException iOException) {
        }
        finally {
            if (byteBuffer != null) {
                MemoryUtil.memFree((Buffer)byteBuffer);
            }
        }
        return null;
    }

    public static void writeAsPNG(String string, int n2, int n3, int n4, int n5) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        TextureUtil.bind(n2);
        for (\u00e2\u02dc\u0192 = 0; \u00e2\u02dc\u0192 <= n3; ++\u00e2\u02dc\u0192) {
            String string2 = string + "_" + \u00e2\u02dc\u0192 + ".png";
            int \u00e2\u02dc\u01922 = n4 >> \u00e2\u02dc\u0192;
            int \u00e2\u02dc\u01923 = n5 >> \u00e2\u02dc\u0192;
            try (dpm dpm2 = new dpm(\u00e2\u02dc\u01922, \u00e2\u02dc\u01923, false);){
                dpm2.a(\u00e2\u02dc\u0192, false);
                dpm2.a(string2);
                LOGGER.debug("Exported png to: {}", (Object)new File(string2).getAbsolutePath());
                continue;
            }
            catch (IOException iOException) {
                LOGGER.debug("Unable to write: ", (Throwable)iOException);
            }
        }
    }

    public static void initTexture(IntBuffer intBuffer, int n2, int n3) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        GL11.glPixelStorei((int)3312, (int)0);
        GL11.glPixelStorei((int)3313, (int)0);
        GL11.glPixelStorei((int)3314, (int)0);
        GL11.glPixelStorei((int)3315, (int)0);
        GL11.glPixelStorei((int)3316, (int)0);
        GL11.glPixelStorei((int)3317, (int)4);
        GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)n2, (int)n3, (int)0, (int)32993, (int)33639, (IntBuffer)intBuffer);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
    }
}

