/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.blaze3d.platform;

import com.google.common.base.Charsets;
import com.mojang.blaze3d.systems.RenderSystem;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.List;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import org.lwjgl.opengl.GL14;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL20C;
import org.lwjgl.opengl.GL30;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import static d.b;

@dof
public class GlStateManager {
    public static final int TEXTURE_COUNT = 12;
    private static final a BLEND = new a();
    private static final f DEPTH = new f();
    private static final e CULL = new e();
    private static final h POLY_OFFSET = new h();
    private static final c COLOR_LOGIC = new c();
    private static final k STENCIL = new k();
    private static final i SCISSOR = new i();
    private static int activeTexture;
    private static final l[] TEXTURES;
    private static final d COLOR_MASK;

    public static void _disableScissorTest() {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        GlStateManager.SCISSOR.a.a();
    }

    public static void _enableScissorTest() {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        GlStateManager.SCISSOR.a.b();
    }

    public static void _scissorBox(int n2, int n3, int n4, int n5) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        GL20.glScissor((int)n2, (int)n3, (int)n4, (int)n5);
    }

    public static void _disableDepthTest() {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        GlStateManager.DEPTH.a.a();
    }

    public static void _enableDepthTest() {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        GlStateManager.DEPTH.a.b();
    }

    public static void _depthFunc(int n2) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        if (n2 != GlStateManager.DEPTH.c) {
            GlStateManager.DEPTH.c = n2;
            GL11.glDepthFunc((int)n2);
        }
    }

    public static void _depthMask(boolean bl2) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        if (bl2 != GlStateManager.DEPTH.b) {
            GlStateManager.DEPTH.b = bl2;
            GL11.glDepthMask((boolean)bl2);
        }
    }

    public static void _disableBlend() {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        GlStateManager.BLEND.a.a();
    }

    public static void _enableBlend() {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        GlStateManager.BLEND.a.b();
    }

    public static void _blendFunc(int n2, int n3) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        if (n2 != GlStateManager.BLEND.b || n3 != GlStateManager.BLEND.c) {
            GlStateManager.BLEND.b = n2;
            GlStateManager.BLEND.c = n3;
            GL11.glBlendFunc((int)n2, (int)n3);
        }
    }

    public static void _blendFuncSeparate(int n2, int n3, int n4, int n5) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        if (n2 != GlStateManager.BLEND.b || n3 != GlStateManager.BLEND.c || n4 != GlStateManager.BLEND.d || n5 != GlStateManager.BLEND.e) {
            GlStateManager.BLEND.b = n2;
            GlStateManager.BLEND.c = n3;
            GlStateManager.BLEND.d = n4;
            GlStateManager.BLEND.e = n5;
            GlStateManager.glBlendFuncSeparate(n2, n3, n4, n5);
        }
    }

    public static void _blendEquation(int n2) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        GL14.glBlendEquation((int)n2);
    }

    public static int glGetProgrami(int n2, int n3) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        return GL20.glGetProgrami((int)n2, (int)n3);
    }

    public static void glAttachShader(int n2, int n3) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        GL20.glAttachShader((int)n2, (int)n3);
    }

    public static void glDeleteShader(int n2) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        GL20.glDeleteShader((int)n2);
    }

    public static int glCreateShader(int n2) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        return GL20.glCreateShader((int)n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glShaderSource(int n2, List<String> list) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : list) {
            stringBuilder.append(string);
        }
        byte[] \u00e2\u02dc\u01922 = stringBuilder.toString().getBytes(Charsets.UTF_8);
        ByteBuffer byteBuffer = MemoryUtil.memAlloc((int)(\u00e2\u02dc\u01922.length + 1));
        byteBuffer.put(\u00e2\u02dc\u01922);
        byteBuffer.put((byte)0);
        byteBuffer.flip();
        try (MemoryStack memoryStack = MemoryStack.stackPush();){
            PointerBuffer pointerBuffer = memoryStack.mallocPointer(1);
            pointerBuffer.put(byteBuffer);
            GL20C.nglShaderSource((int)n2, (int)1, (long)pointerBuffer.address0(), (long)0L);
        }
        finally {
            MemoryUtil.memFree((Buffer)byteBuffer);
        }
    }

    public static void glCompileShader(int n2) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        GL20.glCompileShader((int)n2);
    }

    public static int glGetShaderi(int n2, int n3) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        return GL20.glGetShaderi((int)n2, (int)n3);
    }

    public static void _glUseProgram(int n2) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        GL20.glUseProgram((int)n2);
    }

    public static int glCreateProgram() {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        return GL20.glCreateProgram();
    }

    public static void glDeleteProgram(int n2) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        GL20.glDeleteProgram((int)n2);
    }

    public static void glLinkProgram(int n2) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        GL20.glLinkProgram((int)n2);
    }

    public static int _glGetUniformLocation(int n2, CharSequence charSequence) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        return GL20.glGetUniformLocation((int)n2, (CharSequence)charSequence);
    }

    public static void _glUniform1(int n2, IntBuffer intBuffer) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        GL20.glUniform1iv((int)n2, (IntBuffer)intBuffer);
    }

    public static void _glUniform1i(int n2, int n3) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        GL20.glUniform1i((int)n2, (int)n3);
    }

    public static void _glUniform1(int n2, FloatBuffer floatBuffer) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        GL20.glUniform1fv((int)n2, (FloatBuffer)floatBuffer);
    }

    public static void _glUniform2(int n2, IntBuffer intBuffer) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        GL20.glUniform2iv((int)n2, (IntBuffer)intBuffer);
    }

    public static void _glUniform2(int n2, FloatBuffer floatBuffer) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        GL20.glUniform2fv((int)n2, (FloatBuffer)floatBuffer);
    }

    public static void _glUniform3(int n2, IntBuffer intBuffer) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        GL20.glUniform3iv((int)n2, (IntBuffer)intBuffer);
    }

    public static void _glUniform3(int n2, FloatBuffer floatBuffer) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        GL20.glUniform3fv((int)n2, (FloatBuffer)floatBuffer);
    }

    public static void _glUniform4(int n2, IntBuffer intBuffer) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        GL20.glUniform4iv((int)n2, (IntBuffer)intBuffer);
    }

    public static void _glUniform4(int n2, FloatBuffer floatBuffer) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        GL20.glUniform4fv((int)n2, (FloatBuffer)floatBuffer);
    }

    public static void _glUniformMatrix2(int n2, boolean bl2, FloatBuffer floatBuffer) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        GL20.glUniformMatrix2fv((int)n2, (boolean)bl2, (FloatBuffer)floatBuffer);
    }

    public static void _glUniformMatrix3(int n2, boolean bl2, FloatBuffer floatBuffer) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        GL20.glUniformMatrix3fv((int)n2, (boolean)bl2, (FloatBuffer)floatBuffer);
    }

    public static void _glUniformMatrix4(int n2, boolean bl2, FloatBuffer floatBuffer) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        GL20.glUniformMatrix4fv((int)n2, (boolean)bl2, (FloatBuffer)floatBuffer);
    }

    public static int _glGetAttribLocation(int n2, CharSequence charSequence) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        return GL20.glGetAttribLocation((int)n2, (CharSequence)charSequence);
    }

    public static void _glBindAttribLocation(int n2, int n3, CharSequence charSequence) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        GL20.glBindAttribLocation((int)n2, (int)n3, (CharSequence)charSequence);
    }

    public static int _glGenBuffers() {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        return GL15.glGenBuffers();
    }

    public static int _glGenVertexArrays() {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        return GL30.glGenVertexArrays();
    }

    public static void _glBindBuffer(int n2, int n3) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        GL15.glBindBuffer((int)n2, (int)n3);
    }

    public static void _glBindVertexArray(int n2) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        GL30.glBindVertexArray((int)n2);
    }

    public static void _glBufferData(int n2, ByteBuffer byteBuffer, int n3) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        GL15.glBufferData((int)n2, (ByteBuffer)byteBuffer, (int)n3);
    }

    public static void _glBufferData(int n2, long l2, int n3) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        GL15.glBufferData((int)n2, (long)l2, (int)n3);
    }

    @Nullable
    public static ByteBuffer _glMapBuffer(int n2, int n3) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        return GL15.glMapBuffer((int)n2, (int)n3);
    }

    public static void _glUnmapBuffer(int n2) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        GL15.glUnmapBuffer((int)n2);
    }

    public static void _glDeleteBuffers(int n2) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        GL15.glDeleteBuffers((int)n2);
    }

    public static void _glCopyTexSubImage2D(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        GL20.glCopyTexSubImage2D((int)n2, (int)n3, (int)n4, (int)n5, (int)n6, (int)n7, (int)n8, (int)n9);
    }

    public static void _glDeleteVertexArrays(int n2) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        GL30.glDeleteVertexArrays((int)n2);
    }

    public static void _glBindFramebuffer(int n2, int n3) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        GL30.glBindFramebuffer((int)n2, (int)n3);
    }

    public static void _glBlitFrameBuffer(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        GL30.glBlitFramebuffer((int)n2, (int)n3, (int)n4, (int)n5, (int)n6, (int)n7, (int)n8, (int)n9, (int)n10, (int)n11);
    }

    public static void _glBindRenderbuffer(int n2, int n3) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        GL30.glBindRenderbuffer((int)n2, (int)n3);
    }

    public static void _glDeleteRenderbuffers(int n2) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        GL30.glDeleteRenderbuffers((int)n2);
    }

    public static void _glDeleteFramebuffers(int n2) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        GL30.glDeleteFramebuffers((int)n2);
    }

    public static int glGenFramebuffers() {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        return GL30.glGenFramebuffers();
    }

    public static int glGenRenderbuffers() {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        return GL30.glGenRenderbuffers();
    }

    public static void _glRenderbufferStorage(int n2, int n3, int n4, int n5) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        GL30.glRenderbufferStorage((int)n2, (int)n3, (int)n4, (int)n5);
    }

    public static void _glFramebufferRenderbuffer(int n2, int n3, int n4, int n5) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        GL30.glFramebufferRenderbuffer((int)n2, (int)n3, (int)n4, (int)n5);
    }

    public static int glCheckFramebufferStatus(int n2) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        return GL30.glCheckFramebufferStatus((int)n2);
    }

    public static void _glFramebufferTexture2D(int n2, int n3, int n4, int n5, int n6) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        GL30.glFramebufferTexture2D((int)n2, (int)n3, (int)n4, (int)n5, (int)n6);
    }

    public static int getBoundFramebuffer() {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        return GlStateManager._getInteger(36006);
    }

    public static void glActiveTexture(int n2) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        GL13.glActiveTexture((int)n2);
    }

    public static void glBlendFuncSeparate(int n2, int n3, int n4, int n5) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        GL14.glBlendFuncSeparate((int)n2, (int)n3, (int)n4, (int)n5);
    }

    public static String glGetShaderInfoLog(int n2, int n3) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        return GL20.glGetShaderInfoLog((int)n2, (int)n3);
    }

    public static String glGetProgramInfoLog(int n2, int n3) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        return GL20.glGetProgramInfoLog((int)n2, (int)n3);
    }

    public static void setupLevelDiffuseLighting(k k2, k k3, d d2) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        l l2 = new l(k2);
        l2.a(d2);
        \u00e2\u02dc\u0192 = new l(k3);
        \u00e2\u02dc\u0192.a(d2);
        RenderSystem.setShaderLights(new k(l2), new k(\u00e2\u02dc\u0192));
    }

    public static void setupGuiFlatDiffuseLighting(k k2, k k3) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        d d2 = new d();
        d2.b();
        d2.b(b(1.0f, -1.0f, 1.0f));
        d2.a(k.e.c(-22.5f));
        d2.a(k.c.c(135.0f));
        GlStateManager.setupLevelDiffuseLighting(k2, k3, d2);
    }

    public static void setupGui3DDiffuseLighting(k k2, k k3) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        d d2 = new d();
        d2.b();
        d2.a(k.e.c(62.0f));
        d2.a(k.c.c(185.5f));
        d2.a(k.e.c(-22.5f));
        d2.a(k.c.c(135.0f));
        GlStateManager.setupLevelDiffuseLighting(k2, k3, d2);
    }

    public static void _enableCull() {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        GlStateManager.CULL.a.b();
    }

    public static void _disableCull() {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        GlStateManager.CULL.a.a();
    }

    public static void _polygonMode(int n2, int n3) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        GL11.glPolygonMode((int)n2, (int)n3);
    }

    public static void _enablePolygonOffset() {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        GlStateManager.POLY_OFFSET.a.b();
    }

    public static void _disablePolygonOffset() {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        GlStateManager.POLY_OFFSET.a.a();
    }

    public static void _polygonOffset(float f2, float f3) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        if (f2 != GlStateManager.POLY_OFFSET.c || f3 != GlStateManager.POLY_OFFSET.d) {
            GlStateManager.POLY_OFFSET.c = f2;
            GlStateManager.POLY_OFFSET.d = f3;
            GL11.glPolygonOffset((float)f2, (float)f3);
        }
    }

    public static void _enableColorLogicOp() {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        GlStateManager.COLOR_LOGIC.a.b();
    }

    public static void _disableColorLogicOp() {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        GlStateManager.COLOR_LOGIC.a.a();
    }

    public static void _logicOp(int n2) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        if (n2 != GlStateManager.COLOR_LOGIC.b) {
            GlStateManager.COLOR_LOGIC.b = n2;
            GL11.glLogicOp((int)n2);
        }
    }

    public static void _activeTexture(int n2) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        if (activeTexture != n2 - 33984) {
            activeTexture = n2 - 33984;
            GlStateManager.glActiveTexture(n2);
        }
    }

    public static void _enableTexture() {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        GlStateManager.TEXTURES[GlStateManager.activeTexture].a = true;
    }

    public static void _disableTexture() {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        GlStateManager.TEXTURES[GlStateManager.activeTexture].a = false;
    }

    public static void _texParameter(int n2, int n3, float f2) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        GL11.glTexParameterf((int)n2, (int)n3, (float)f2);
    }

    public static void _texParameter(int n2, int n3, int n4) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        GL11.glTexParameteri((int)n2, (int)n3, (int)n4);
    }

    public static int _getTexLevelParameter(int n2, int n3, int n4) {
        RenderSystem.assertThread(RenderSystem::isInInitPhase);
        return GL11.glGetTexLevelParameteri((int)n2, (int)n3, (int)n4);
    }

    public static int _genTexture() {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        return GL11.glGenTextures();
    }

    public static void _genTextures(int[] nArray) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        GL11.glGenTextures((int[])nArray);
    }

    public static void _deleteTexture(int n2) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        GL11.glDeleteTextures((int)n2);
        for (l l2 : TEXTURES) {
            if (l2.b != n2) continue;
            l2.b = -1;
        }
    }

    public static void _deleteTextures(int[] nArray2) {
        int[] nArray2;
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        for (l l2 : TEXTURES) {
            for (int n2 : nArray2) {
                if (l2.b != n2) continue;
                l2.b = -1;
            }
        }
        GL11.glDeleteTextures((int[])nArray2);
    }

    public static void _bindTexture(int n2) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        if (n2 != GlStateManager.TEXTURES[GlStateManager.activeTexture].b) {
            GlStateManager.TEXTURES[GlStateManager.activeTexture].b = n2;
            GL11.glBindTexture((int)3553, (int)n2);
        }
    }

    public static int _getTextureId(int n2) {
        if (n2 >= 0 && n2 < 12 && GlStateManager.TEXTURES[n2].a) {
            return GlStateManager.TEXTURES[n2].b;
        }
        return 0;
    }

    public static int _getActiveTexture() {
        return activeTexture + 33984;
    }

    public static void _texImage2D(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, @Nullable IntBuffer intBuffer) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        GL11.glTexImage2D((int)n2, (int)n3, (int)n4, (int)n5, (int)n6, (int)n7, (int)n8, (int)n9, (IntBuffer)intBuffer);
    }

    public static void _texSubImage2D(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, long l2) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        GL11.glTexSubImage2D((int)n2, (int)n3, (int)n4, (int)n5, (int)n6, (int)n7, (int)n8, (int)n9, (long)l2);
    }

    public static void _getTexImage(int n2, int n3, int n4, int n5, long l2) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        GL11.glGetTexImage((int)n2, (int)n3, (int)n4, (int)n5, (long)l2);
    }

    public static void _viewport(int n2, int n3, int n4, int n5) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        m.a.b = n2;
        m.a.c = n3;
        m.a.d = n4;
        m.a.e = n5;
        GL11.glViewport((int)n2, (int)n3, (int)n4, (int)n5);
    }

    public static void _colorMask(boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        if (bl2 != GlStateManager.COLOR_MASK.a || bl3 != GlStateManager.COLOR_MASK.b || bl4 != GlStateManager.COLOR_MASK.c || bl5 != GlStateManager.COLOR_MASK.d) {
            GlStateManager.COLOR_MASK.a = bl2;
            GlStateManager.COLOR_MASK.b = bl3;
            GlStateManager.COLOR_MASK.c = bl4;
            GlStateManager.COLOR_MASK.d = bl5;
            GL11.glColorMask((boolean)bl2, (boolean)bl3, (boolean)bl4, (boolean)bl5);
        }
    }

    public static void _stencilFunc(int n2, int n3, int n4) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        if (n2 != GlStateManager.STENCIL.a.a || n2 != GlStateManager.STENCIL.a.b || n2 != GlStateManager.STENCIL.a.c) {
            GlStateManager.STENCIL.a.a = n2;
            GlStateManager.STENCIL.a.b = n3;
            GlStateManager.STENCIL.a.c = n4;
            GL11.glStencilFunc((int)n2, (int)n3, (int)n4);
        }
    }

    public static void _stencilMask(int n2) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        if (n2 != GlStateManager.STENCIL.b) {
            GlStateManager.STENCIL.b = n2;
            GL11.glStencilMask((int)n2);
        }
    }

    public static void _stencilOp(int n2, int n3, int n4) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        if (n2 != GlStateManager.STENCIL.c || n3 != GlStateManager.STENCIL.d || n4 != GlStateManager.STENCIL.e) {
            GlStateManager.STENCIL.c = n2;
            GlStateManager.STENCIL.d = n3;
            GlStateManager.STENCIL.e = n4;
            GL11.glStencilOp((int)n2, (int)n3, (int)n4);
        }
    }

    public static void _clearDepth(double d2) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        GL11.glClearDepth((double)d2);
    }

    public static void _clearColor(float f2, float f3, float f4, float f5) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        GL11.glClearColor((float)f2, (float)f3, (float)f4, (float)f5);
    }

    public static void _clearStencil(int n2) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        GL11.glClearStencil((int)n2);
    }

    public static void _clear(int n2, boolean bl2) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        GL11.glClear((int)n2);
        if (bl2) {
            GlStateManager._getError();
        }
    }

    public static void _glDrawPixels(int n2, int n3, int n4, int n5, long l2) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        GL11.glDrawPixels((int)n2, (int)n3, (int)n4, (int)n5, (long)l2);
    }

    public static void _vertexAttribPointer(int n2, int n3, int n4, boolean bl2, int n5, long l2) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        GL20.glVertexAttribPointer((int)n2, (int)n3, (int)n4, (boolean)bl2, (int)n5, (long)l2);
    }

    public static void _vertexAttribIPointer(int n2, int n3, int n4, int n5, long l2) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        GL30.glVertexAttribIPointer((int)n2, (int)n3, (int)n4, (int)n5, (long)l2);
    }

    public static void _enableVertexAttribArray(int n2) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        GL20.glEnableVertexAttribArray((int)n2);
    }

    public static void _disableVertexAttribArray(int n2) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        GL20.glDisableVertexAttribArray((int)n2);
    }

    public static void _drawElements(int n2, int n3, int n4, long l2) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        GL11.glDrawElements((int)n2, (int)n3, (int)n4, (long)l2);
    }

    public static void _pixelStore(int n2, int n3) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        GL11.glPixelStorei((int)n2, (int)n3);
    }

    public static void _readPixels(int n2, int n3, int n4, int n5, int n6, int n7, ByteBuffer byteBuffer) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        GL11.glReadPixels((int)n2, (int)n3, (int)n4, (int)n5, (int)n6, (int)n7, (ByteBuffer)byteBuffer);
    }

    public static void _readPixels(int n2, int n3, int n4, int n5, int n6, int n7, long l2) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        GL11.glReadPixels((int)n2, (int)n3, (int)n4, (int)n5, (int)n6, (int)n7, (long)l2);
    }

    public static int _getError() {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        return GL11.glGetError();
    }

    public static String _getString(int n2) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        return GL11.glGetString((int)n2);
    }

    public static int _getInteger(int n2) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        return GL11.glGetInteger((int)n2);
    }

    static {
        TEXTURES = (l[])IntStream.range(0, 12).mapToObj(n2 -> new l()).toArray(l[]::new);
        COLOR_MASK = new d();
    }

    static class i {
        public final b a = new b(3089);

        i() {
        }
    }

    static class b {
        private final int a;
        private boolean b;

        public b(int n2) {
            this.a = n2;
        }

        public void a() {
            this.a(false);
        }

        public void b() {
            this.a(true);
        }

        public void a(boolean bl2) {
            RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
            if (bl2 != this.b) {
                this.b = bl2;
                if (bl2) {
                    GL11.glEnable((int)this.a);
                } else {
                    GL11.glDisable((int)this.a);
                }
            }
        }
    }

    static class f {
        public final b a = new b(2929);
        public boolean b = true;
        public int c = 513;

        f() {
        }
    }

    static class a {
        public final b a = new b(3042);
        public int b = 1;
        public int c = 0;
        public int d = 1;
        public int e = 0;

        a() {
        }
    }

    static class e {
        public final b a = new b(2884);
        public int b = 1029;

        e() {
        }
    }

    static class h {
        public final b a = new b(32823);
        public final b b = new b(10754);
        public float c;
        public float d;

        h() {
        }
    }

    static class c {
        public final b a = new b(3058);
        public int b = 5379;

        c() {
        }
    }

    static class l {
        public boolean a;
        public int b;

        l() {
        }
    }

    public static final class m
    extends Enum<m> {
        public static final /* enum */ m a = new m();
        protected int b;
        protected int c;
        protected int d;
        protected int e;
        private static final /* synthetic */ m[] f;

        public static m[] values() {
            return (m[])f.clone();
        }

        public static m valueOf(String string) {
            return Enum.valueOf(m.class, string);
        }

        public static int a() {
            return m.a.b;
        }

        public static int b() {
            return m.a.c;
        }

        public static int c() {
            return m.a.d;
        }

        public static int d() {
            return m.a.e;
        }

        private static /* synthetic */ m[] e() {
            return new m[]{a};
        }

        static {
            f = m.e();
        }
    }

    static class d {
        public boolean a = true;
        public boolean b = true;
        public boolean c = true;
        public boolean d = true;

        d() {
        }
    }

    static class k {
        public final j a = new j();
        public int b = -1;
        public int c = 7680;
        public int d = 7680;
        public int e = 7680;

        k() {
        }
    }

    static class j {
        public int a = 519;
        public int b;
        public int c = -1;

        j() {
        }
    }

    @dof
    public static enum DestFactor {
        CONSTANT_ALPHA(32771),
        CONSTANT_COLOR(32769),
        DST_ALPHA(772),
        DST_COLOR(774),
        ONE(1),
        ONE_MINUS_CONSTANT_ALPHA(32772),
        ONE_MINUS_CONSTANT_COLOR(32770),
        ONE_MINUS_DST_ALPHA(773),
        ONE_MINUS_DST_COLOR(775),
        ONE_MINUS_SRC_ALPHA(771),
        ONE_MINUS_SRC_COLOR(769),
        SRC_ALPHA(770),
        SRC_COLOR(768),
        ZERO(0);

        public final int value;

        private DestFactor(int n3) {
            this.value = n3;
        }
    }

    @dof
    public static enum SourceFactor {
        CONSTANT_ALPHA(32771),
        CONSTANT_COLOR(32769),
        DST_ALPHA(772),
        DST_COLOR(774),
        ONE(1),
        ONE_MINUS_CONSTANT_ALPHA(32772),
        ONE_MINUS_CONSTANT_COLOR(32770),
        ONE_MINUS_DST_ALPHA(773),
        ONE_MINUS_DST_COLOR(775),
        ONE_MINUS_SRC_ALPHA(771),
        ONE_MINUS_SRC_COLOR(769),
        SRC_ALPHA(770),
        SRC_ALPHA_SATURATE(776),
        SRC_COLOR(768),
        ZERO(0);

        public final int value;

        private SourceFactor(int n3) {
            this.value = n3;
        }
    }

    public static final class g
    extends Enum<g> {
        public static final /* enum */ g a = new g(5377);
        public static final /* enum */ g b = new g(5380);
        public static final /* enum */ g c = new g(5378);
        public static final /* enum */ g d = new g(5376);
        public static final /* enum */ g e = new g(5379);
        public static final /* enum */ g f = new g(5388);
        public static final /* enum */ g g = new g(5385);
        public static final /* enum */ g h = new g(5386);
        public static final /* enum */ g i = new g(5390);
        public static final /* enum */ g j = new g(5381);
        public static final /* enum */ g k = new g(5384);
        public static final /* enum */ g l = new g(5383);
        public static final /* enum */ g m = new g(5389);
        public static final /* enum */ g n = new g(5387);
        public static final /* enum */ g o = new g(5391);
        public static final /* enum */ g p = new g(5382);
        public final int q;
        private static final /* synthetic */ g[] r;

        public static g[] values() {
            return (g[])r.clone();
        }

        public static g valueOf(String string) {
            return Enum.valueOf(g.class, string);
        }

        private g(int n3) {
            this.q = n3;
        }

        private static /* synthetic */ g[] a() {
            return new g[]{a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p};
        }

        static {
            r = com.mojang.blaze3d.platform.GlStateManager$g.a();
        }
    }
}

