/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.blaze3d.platform;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.function.Consumer;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.Version;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWErrorCallback;
import org.lwjgl.glfw.GLFWErrorCallbackI;
import org.lwjgl.glfw.GLFWVidMode;
import oshi.SystemInfo;
import oshi.hardware.CentralProcessor;

@dof
public class GLX {
    private static final Logger LOGGER = LogManager.getLogger();
    private static String cpuInfo;

    public static String getOpenGLVersionString() {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        if (GLFW.glfwGetCurrentContext() == 0L) {
            return "NO CONTEXT";
        }
        return GlStateManager._getString(7937) + " GL version " + GlStateManager._getString(7938) + ", " + GlStateManager._getString(7936);
    }

    public static int _getRefreshRate(dpr dpr2) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        long l2 = GLFW.glfwGetWindowMonitor((long)dpr2.i());
        if (l2 == 0L) {
            l2 = GLFW.glfwGetPrimaryMonitor();
        }
        GLFWVidMode \u00e2\u02dc\u01922 = l2 == 0L ? null : GLFW.glfwGetVideoMode((long)l2);
        return \u00e2\u02dc\u01922 == null ? 0 : \u00e2\u02dc\u01922.refreshRate();
    }

    public static String _getLWJGLVersion() {
        RenderSystem.assertThread(RenderSystem::isInInitPhase);
        return Version.getVersion();
    }

    public static LongSupplier _initGlfw() {
        LongSupplier longSupplier;
        RenderSystem.assertThread(RenderSystem::isInInitPhase);
        dpr.a((n2, string) -> {
            throw new IllegalStateException(String.format("GLFW error before init: [0x%X]%s", n2, string));
        });
        ArrayList arrayList = Lists.newArrayList();
        GLFWErrorCallback \u00e2\u02dc\u01922 = GLFW.glfwSetErrorCallback((n2, l2) -> arrayList.add(String.format("GLFW error during init: [0x%X]%s", n2, l2)));
        if (GLFW.glfwInit()) {
            longSupplier = () -> (long)(GLFW.glfwGetTime() * 1.0E9);
            for (String string2 : arrayList) {
                LOGGER.error("GLFW error collected during initialization: {}", (Object)string2);
            }
        } else {
            throw new IllegalStateException("Failed to initialize GLFW, errors: " + Joiner.on((String)",").join((Iterable)arrayList));
        }
        RenderSystem.setErrorCallback((GLFWErrorCallbackI)\u00e2\u02dc\u01922);
        return longSupplier;
    }

    public static void _setGlfwErrorCallback(GLFWErrorCallbackI gLFWErrorCallbackI) {
        RenderSystem.assertThread(RenderSystem::isInInitPhase);
        GLFWErrorCallback gLFWErrorCallback = GLFW.glfwSetErrorCallback((GLFWErrorCallbackI)gLFWErrorCallbackI);
        if (gLFWErrorCallback != null) {
            gLFWErrorCallback.free();
        }
    }

    public static boolean _shouldClose(dpr dpr2) {
        return GLFW.glfwWindowShouldClose((long)dpr2.i());
    }

    public static void _init(int n22, boolean bl2) {
        int n22;
        RenderSystem.assertThread(RenderSystem::isInInitPhase);
        try {
            CentralProcessor centralProcessor = new SystemInfo().getHardware().getProcessor();
            cpuInfo = String.format("%dx %s", centralProcessor.getLogicalProcessorCount(), centralProcessor.getProcessorIdentifier().getName()).replaceAll("\\s+", " ");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        dpe.a(n22, bl2);
    }

    public static String _getCpuInfo() {
        return cpuInfo == null ? "<unknown>" : cpuInfo;
    }

    public static void _renderCrosshair(int n2, boolean bl2, boolean bl3, boolean bl4) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        GlStateManager._disableTexture();
        GlStateManager._depthMask(false);
        GlStateManager._disableCull();
        RenderSystem.setShader(enb::ap);
        dqn dqn2 = RenderSystem.renderThreadTesselator();
        dqg \u00e2\u02dc\u01922 = dqn2.c();
        RenderSystem.lineWidth(4.0f);
        \u00e2\u02dc\u01922.a(dqq.b.a, dqj.o);
        if (bl2) {
            \u00e2\u02dc\u01922.a(0.0, 0.0, 0.0).a(0, 0, 0, 255).b(1.0f, 0.0f, 0.0f).c();
            \u00e2\u02dc\u01922.a((double)n2, 0.0, 0.0).a(0, 0, 0, 255).b(1.0f, 0.0f, 0.0f).c();
        }
        if (bl3) {
            \u00e2\u02dc\u01922.a(0.0, 0.0, 0.0).a(0, 0, 0, 255).b(0.0f, 1.0f, 0.0f).c();
            \u00e2\u02dc\u01922.a(0.0, (double)n2, 0.0).a(0, 0, 0, 255).b(0.0f, 1.0f, 0.0f).c();
        }
        if (bl4) {
            \u00e2\u02dc\u01922.a(0.0, 0.0, 0.0).a(0, 0, 0, 255).b(0.0f, 0.0f, 1.0f).c();
            \u00e2\u02dc\u01922.a(0.0, 0.0, (double)n2).a(0, 0, 0, 255).b(0.0f, 0.0f, 1.0f).c();
        }
        dqn2.b();
        RenderSystem.lineWidth(2.0f);
        \u00e2\u02dc\u01922.a(dqq.b.a, dqj.o);
        if (bl2) {
            \u00e2\u02dc\u01922.a(0.0, 0.0, 0.0).a(255, 0, 0, 255).b(1.0f, 0.0f, 0.0f).c();
            \u00e2\u02dc\u01922.a((double)n2, 0.0, 0.0).a(255, 0, 0, 255).b(1.0f, 0.0f, 0.0f).c();
        }
        if (bl3) {
            \u00e2\u02dc\u01922.a(0.0, 0.0, 0.0).a(0, 255, 0, 255).b(0.0f, 1.0f, 0.0f).c();
            \u00e2\u02dc\u01922.a(0.0, (double)n2, 0.0).a(0, 255, 0, 255).b(0.0f, 1.0f, 0.0f).c();
        }
        if (bl4) {
            \u00e2\u02dc\u01922.a(0.0, 0.0, 0.0).a(127, 127, 255, 255).b(0.0f, 0.0f, 1.0f).c();
            \u00e2\u02dc\u01922.a(0.0, 0.0, (double)n2).a(127, 127, 255, 255).b(0.0f, 0.0f, 1.0f).c();
        }
        dqn2.b();
        RenderSystem.lineWidth(1.0f);
        GlStateManager._enableCull();
        GlStateManager._depthMask(true);
        GlStateManager._enableTexture();
    }

    public static <T> T make(Supplier<T> supplier) {
        return supplier.get();
    }

    public static <T> T make(T t2, Consumer<T> consumer) {
        consumer.accept(t2);
        return t2;
    }
}

