/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader.impl.util.log;

import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayDeque;
import java.util.Queue;
import net.fabricmc.loader.impl.util.log.ConsoleLogHandler;
import net.fabricmc.loader.impl.util.log.LogCategory;
import net.fabricmc.loader.impl.util.log.LogHandler;
import net.fabricmc.loader.impl.util.log.LogLevel;

final class BuiltinLogHandler
extends ConsoleLogHandler {
    private static final String DEFAULT_LOG_FILE = "fabricloader.log";
    private final Queue<ReplayEntry> replayBuffer = new ArrayDeque<ReplayEntry>();
    private final Thread shutdownHook = new ShutdownHook();

    BuiltinLogHandler() {
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void log(long time, LogLevel level, LogCategory category, String msg, Throwable exc, boolean isReplayedBuiltin) {
        super.log(time, level, category, msg, exc, isReplayedBuiltin);
        BuiltinLogHandler builtinLogHandler = this;
        synchronized (builtinLogHandler) {
            this.replayBuffer.add(new ReplayEntry(time, level, category, msg, exc));
        }
    }

    @Override
    public void close() {
        Thread shutdownHook = this.shutdownHook;
        if (shutdownHook != null) {
            try {
                Runtime.getRuntime().removeShutdownHook(shutdownHook);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    synchronized boolean replay(LogHandler target) {
        ReplayEntry entry;
        while ((entry = this.replayBuffer.poll()) != null) {
            target.log(entry.time, entry.level, entry.category, entry.msg, entry.exc, true);
        }
        return true;
    }

    private final class ShutdownHook
    extends Thread {
        ShutdownHook() {
            super("BuiltinLogHandler shutdown hook");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            BuiltinLogHandler builtinLogHandler = BuiltinLogHandler.this;
            synchronized (builtinLogHandler) {
                if (BuiltinLogHandler.this.replayBuffer.isEmpty()) {
                    return;
                }
                String fileName = System.getProperty("fabric.log.file", BuiltinLogHandler.DEFAULT_LOG_FILE);
                if (fileName.isEmpty()) {
                    return;
                }
                try {
                    Path file = Paths.get(fileName, new String[0]).toAbsolutePath().normalize();
                    Files.createDirectories(file.getParent(), new FileAttribute[0]);
                    try (BufferedWriter writer = Files.newBufferedWriter(file, StandardOpenOption.WRITE, StandardOpenOption.APPEND, StandardOpenOption.CREATE);){
                        ReplayEntry entry;
                        while ((entry = (ReplayEntry)BuiltinLogHandler.this.replayBuffer.poll()) != null) {
                            writer.write(ConsoleLogHandler.formatLog(entry.time, entry.level, entry.category, entry.msg, entry.exc));
                        }
                    }
                }
                catch (IOException e) {
                    System.err.printf("Error saving log: %s", e);
                }
            }
        }
    }

    private static final class ReplayEntry {
        final long time;
        final LogLevel level;
        final LogCategory category;
        final String msg;
        final Throwable exc;

        ReplayEntry(long time, LogLevel level, LogCategory category, String msg, Throwable exc) {
            this.time = time;
            this.level = level;
            this.category = category;
            this.msg = msg;
            this.exc = exc;
        }
    }
}

