/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader.impl.launch.knot;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSource;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.impl.game.GameProvider;
import net.fabricmc.loader.impl.launch.knot.KnotClassDelegate;
import net.fabricmc.loader.impl.launch.knot.KnotClassLoaderInterface;

class KnotCompatibilityClassLoader
extends URLClassLoader
implements KnotClassLoaderInterface {
    private final KnotClassDelegate delegate;

    KnotCompatibilityClassLoader(boolean isDevelopment, EnvType envType, GameProvider provider) {
        super(new URL[0], KnotCompatibilityClassLoader.class.getClassLoader());
        this.delegate = new KnotClassDelegate(isDevelopment, envType, this, provider);
    }

    @Override
    public KnotClassDelegate getDelegate() {
        return this.delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isClassLoaded(String name) {
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            return this.findLoadedClass(name) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            Class<?> c = this.findLoadedClass(name);
            if (c == null && (c = this.delegate.tryLoadClass(name, false)) == null) {
                c = this.getParent().loadClass(name);
            }
            if (resolve) {
                this.resolveClass(c);
            }
            return c;
        }
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        return this.delegate.tryLoadClass(name, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Class<?> loadIntoTarget(String name) throws ClassNotFoundException {
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            Class<?> c = this.findLoadedClass(name);
            if (c == null && (c = this.delegate.tryLoadClass(name, true)) == null) {
                throw new ClassNotFoundException("can't find class " + name);
            }
            this.resolveClass(c);
            return c;
        }
    }

    @Override
    public void addURL(URL url) {
        super.addURL(url);
    }

    @Override
    public InputStream getResourceAsStream(String classFile, boolean allowFromParent) throws IOException {
        if (!allowFromParent && this.findResource(classFile) == null) {
            return null;
        }
        return super.getResourceAsStream(classFile);
    }

    @Override
    public Package getPackage(String name) {
        return super.getPackage(name);
    }

    @Override
    public Package definePackage(String name, String specTitle, String specVersion, String specVendor, String implTitle, String implVersion, String implVendor, URL sealBase) throws IllegalArgumentException {
        return super.definePackage(name, specTitle, specVersion, specVendor, implTitle, implVersion, implVendor, sealBase);
    }

    @Override
    public Class<?> defineClassFwd(String name, byte[] b, int off, int len, CodeSource cs) {
        return super.defineClass(name, b, off, len, cs);
    }

    static {
        KnotCompatibilityClassLoader.registerAsParallelCapable();
    }
}

