/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader.impl.launch.knot;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.CodeSource;
import java.security.cert.Certificate;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.Manifest;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.impl.game.GameProvider;
import net.fabricmc.loader.impl.launch.FabricLauncherBase;
import net.fabricmc.loader.impl.launch.knot.KnotClassLoaderInterface;
import net.fabricmc.loader.impl.launch.knot.MixinServiceKnot;
import net.fabricmc.loader.impl.transformer.FabricTransformer;
import net.fabricmc.loader.impl.util.FileSystemUtil;
import net.fabricmc.loader.impl.util.LoaderUtil;
import net.fabricmc.loader.impl.util.ManifestUtil;
import net.fabricmc.loader.impl.util.UrlConversionException;
import net.fabricmc.loader.impl.util.UrlUtil;
import net.fabricmc.loader.impl.util.log.Log;
import net.fabricmc.loader.impl.util.log.LogCategory;
import org.spongepowered.asm.mixin.transformer.IMixinTransformer;

final class KnotClassDelegate {
    private static final boolean LOG_TRANSFORM_ERRORS = System.getProperty("fabric.debug.logTransformErrors") != null;
    private final Map<String, Metadata> metadataCache = new ConcurrentHashMap<String, Metadata>();
    private final KnotClassLoaderInterface itf;
    private final GameProvider provider;
    private final boolean isDevelopment;
    private final EnvType envType;
    private IMixinTransformer mixinTransformer;
    private boolean transformInitialized = false;
    private final Map<URL, String[]> allowedPrefixes = new ConcurrentHashMap<URL, String[]>();
    private final Set<String> parentSourcedClasses = Collections.newSetFromMap(new ConcurrentHashMap());

    KnotClassDelegate(boolean isDevelopment, EnvType envType, KnotClassLoaderInterface itf, GameProvider provider) {
        this.isDevelopment = isDevelopment;
        this.envType = envType;
        this.itf = itf;
        this.provider = provider;
    }

    public void initializeTransformers() {
        if (this.transformInitialized) {
            throw new IllegalStateException("Cannot initialize KnotClassDelegate twice!");
        }
        this.mixinTransformer = MixinServiceKnot.getTransformer();
        if (this.mixinTransformer == null) {
            try {
                Constructor<?> ctor = Class.forName("org.spongepowered.asm.mixin.transformer.MixinTransformer").getConstructor(new Class[0]);
                ctor.setAccessible(true);
                this.mixinTransformer = (IMixinTransformer)ctor.newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                Log.debug(LogCategory.KNOT, "Can't create Mixin transformer through reflection (only applicable for 0.8-0.8.2): %s", e);
                throw new IllegalStateException("mixin transformer unavailable?");
            }
        }
        this.transformInitialized = true;
    }

    private IMixinTransformer getMixinTransformer() {
        assert (this.mixinTransformer != null);
        return this.mixinTransformer;
    }

    Class<?> tryLoadClass(String name, boolean allowFromParent) throws ClassNotFoundException {
        Metadata metadata;
        byte[] input;
        block12: {
            String pkgString;
            String[] prefixes;
            URL url;
            if (name.startsWith("java.")) {
                return null;
            }
            if (!this.allowedPrefixes.isEmpty() && (url = this.itf.getResource(LoaderUtil.getClassFileName(name))) != null && (prefixes = this.allowedPrefixes.get(url)) != null) {
                assert (prefixes.length > 0);
                boolean found = false;
                for (String prefix : prefixes) {
                    if (!name.startsWith(prefix)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    throw new ClassNotFoundException("class " + name + " is currently restricted from being loaded");
                }
            }
            if (!allowFromParent && !this.parentSourcedClasses.isEmpty()) {
                int pos = name.length();
                while ((pos = name.lastIndexOf(36, pos - 1)) > 0) {
                    if (!this.parentSourcedClasses.contains(name.substring(0, pos))) continue;
                    allowFromParent = true;
                    break;
                }
            }
            if ((input = this.getPostMixinClassByteArray(name, allowFromParent)) == null) {
                return null;
            }
            if (allowFromParent) {
                this.parentSourcedClasses.add(name);
            }
            metadata = this.getMetadata(name, this.itf.getResource(LoaderUtil.getClassFileName(name)));
            int pkgDelimiterPos = name.lastIndexOf(46);
            if (pkgDelimiterPos > 0 && this.itf.getPackage(pkgString = name.substring(0, pkgDelimiterPos)) == null) {
                try {
                    this.itf.definePackage(pkgString, null, null, null, null, null, null, null);
                }
                catch (IllegalArgumentException e) {
                    if (this.itf.getPackage(pkgString) != null) break block12;
                    throw e;
                }
            }
        }
        return this.itf.defineClassFwd(name, input, 0, input.length, metadata.codeSource);
    }

    Metadata getMetadata(String name, URL resourceURL) {
        if (resourceURL == null) {
            return Metadata.EMPTY;
        }
        URL codeSourceUrl = null;
        try {
            codeSourceUrl = UrlUtil.getSource(LoaderUtil.getClassFileName(name), resourceURL);
        }
        catch (UrlConversionException e) {
            System.err.println("Could not find code source for " + resourceURL + ": " + e.getMessage());
        }
        if (codeSourceUrl == null) {
            return Metadata.EMPTY;
        }
        return this.getMetadata(codeSourceUrl);
    }

    Metadata getMetadata(URL codeSourceUrl) {
        return this.metadataCache.computeIfAbsent(codeSourceUrl.toString(), codeSourceStr -> {
            Certificate[] certificates;
            CodeSource codeSource;
            Manifest manifest;
            block11: {
                manifest = null;
                codeSource = null;
                certificates = null;
                try {
                    Path path = UrlUtil.asPath(codeSourceUrl);
                    if (Files.isDirectory(path, new LinkOption[0])) {
                        manifest = ManifestUtil.readManifest(path);
                        break block11;
                    }
                    URLConnection connection = new URL("jar:" + codeSourceStr + "!/").openConnection();
                    if (connection instanceof JarURLConnection) {
                        manifest = ((JarURLConnection)connection).getManifest();
                        certificates = ((JarURLConnection)connection).getCertificates();
                    }
                    if (manifest != null) break block11;
                    try (FileSystemUtil.FileSystemDelegate jarFs = FileSystemUtil.getJarFileSystem(path, false);){
                        manifest = ManifestUtil.readManifest(jarFs.get().getRootDirectories().iterator().next());
                    }
                }
                catch (IOException | URISyntaxException | FileSystemNotFoundException e) {
                    if (!FabricLauncherBase.getLauncher().isDevelopment()) break block11;
                    Log.warn(LogCategory.KNOT, "Failed to load manifest", e);
                }
            }
            if (codeSource == null) {
                codeSource = new CodeSource(codeSourceUrl, certificates);
            }
            return new Metadata(manifest, codeSource);
        });
    }

    public byte[] getPostMixinClassByteArray(String name, boolean allowFromParent) {
        byte[] transformedClassArray = this.getPreMixinClassByteArray(name, allowFromParent);
        if (!this.transformInitialized || !KnotClassDelegate.canTransformClass(name)) {
            return transformedClassArray;
        }
        try {
            return this.getMixinTransformer().transformClassBytes(name, name, transformedClassArray);
        }
        catch (Throwable t) {
            String msg = String.format("Mixin transformation of %s failed", name);
            if (LOG_TRANSFORM_ERRORS) {
                Log.warn(LogCategory.KNOT, msg, t);
            }
            throw new RuntimeException(msg, t);
        }
    }

    public byte[] getPreMixinClassByteArray(String name, boolean allowFromParent) {
        name = name.replace('/', '.');
        if (!this.transformInitialized || !KnotClassDelegate.canTransformClass(name)) {
            try {
                return this.getRawClassByteArray(name, allowFromParent);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to load class file for '" + name + "'!", e);
            }
        }
        byte[] input = this.provider.getEntrypointTransformer().transform(name);
        if (input == null) {
            try {
                input = this.getRawClassByteArray(name, allowFromParent);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to load class file for '" + name + "'!", e);
            }
        }
        if (input != null) {
            return FabricTransformer.transform(this.isDevelopment, this.envType, name, input);
        }
        return null;
    }

    private static boolean canTransformClass(String name) {
        return !(name = name.replace('/', '.')).startsWith("org.apache.logging.log4j");
    }

    public byte[] getRawClassByteArray(String name, boolean allowFromParent) throws IOException {
        int len;
        InputStream inputStream = this.itf.getResourceAsStream(LoaderUtil.getClassFileName(name), allowFromParent);
        if (inputStream == null) {
            return null;
        }
        int a = inputStream.available();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(a < 32 ? 32768 : a);
        byte[] buffer = new byte[8192];
        while ((len = inputStream.read(buffer)) > 0) {
            outputStream.write(buffer, 0, len);
        }
        inputStream.close();
        return outputStream.toByteArray();
    }

    void setAllowedPrefixes(URL url, String ... prefixes) {
        if (prefixes.length == 0) {
            this.allowedPrefixes.remove(url);
        } else {
            this.allowedPrefixes.put(url, prefixes);
        }
    }

    static class Metadata {
        static final Metadata EMPTY = new Metadata(null, null);
        final Manifest manifest;
        final CodeSource codeSource;

        Metadata(Manifest manifest, CodeSource codeSource) {
            this.manifest = manifest;
            this.codeSource = codeSource;
        }
    }
}

