/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader.impl.launch.knot;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.entrypoint.PreLaunchEntrypoint;
import net.fabricmc.loader.impl.FabricLoaderImpl;
import net.fabricmc.loader.impl.FormattedException;
import net.fabricmc.loader.impl.entrypoint.EntrypointUtils;
import net.fabricmc.loader.impl.game.GameProvider;
import net.fabricmc.loader.impl.launch.FabricLauncherBase;
import net.fabricmc.loader.impl.launch.FabricMixinBootstrap;
import net.fabricmc.loader.impl.launch.knot.KnotClassLoader;
import net.fabricmc.loader.impl.launch.knot.KnotClassLoaderInterface;
import net.fabricmc.loader.impl.launch.knot.KnotCompatibilityClassLoader;
import net.fabricmc.loader.impl.util.UrlUtil;
import net.fabricmc.loader.impl.util.log.Log;
import net.fabricmc.loader.impl.util.log.LogCategory;
import org.spongepowered.asm.launch.MixinBootstrap;

public final class Knot
extends FabricLauncherBase {
    protected Map<String, Object> properties = new HashMap<String, Object>();
    private KnotClassLoaderInterface classLoader;
    private boolean isDevelopment;
    private EnvType envType;
    private final List<Path> classPath = new ArrayList<Path>();
    private GameProvider provider;
    private boolean unlocked;

    public static void launch(String[] args, EnvType type) {
        Knot.setupUncaughtExceptionHandler();
        try {
            Knot knot = new Knot(type);
            ClassLoader cl = knot.init(args);
            if (knot.provider == null) {
                throw new IllegalStateException("Game provider was not initialized! (Knot#init(String[]))");
            }
            knot.provider.launch(cl);
        }
        catch (FormattedException e) {
            Knot.handleFormattedException(e);
        }
    }

    public Knot(EnvType type) {
        this.envType = type;
    }

    protected ClassLoader init(String[] args) {
        Knot.setProperties(this.properties);
        if (this.envType == null) {
            String[] side = System.getProperty("fabric.side");
            if (side == null) {
                throw new RuntimeException("Please specify side or use a dedicated Knot!");
            }
            switch (side.toLowerCase(Locale.ROOT)) {
                case "client": {
                    this.envType = EnvType.CLIENT;
                    break;
                }
                case "server": {
                    this.envType = EnvType.SERVER;
                    break;
                }
                default: {
                    throw new RuntimeException("Invalid side provided: must be \"client\" or \"server\"!");
                }
            }
        }
        this.classPath.clear();
        for (String cpEntry : System.getProperty("java.class.path").split(File.pathSeparator)) {
            if (cpEntry.equals("*") || cpEntry.endsWith(File.separator + "*")) {
                Log.warn(LogCategory.KNOT, "Knot does not support wildcard classpath entries: %s - the game may not load properly!", cpEntry);
                continue;
            }
            Path path = Paths.get(cpEntry, new String[0]);
            if (!Files.exists(path, new LinkOption[0])) {
                Log.warn(LogCategory.KNOT, "Class path entry %s doesn't exist!", cpEntry);
                continue;
            }
            this.classPath.add(path);
        }
        this.provider = this.createGameProvider(args);
        Log.info(LogCategory.GAME_PROVIDER, "Loading %s %s with Fabric Loader %s", this.provider.getGameName(), this.provider.getRawGameVersion(), "0.13.3");
        this.isDevelopment = Boolean.parseBoolean(System.getProperty("fabric.development", "false"));
        boolean useCompatibility = this.provider.requiresUrlClassLoader() || Boolean.parseBoolean(System.getProperty("fabric.loader.useCompatibilityClassLoader", "false"));
        this.classLoader = useCompatibility ? new KnotCompatibilityClassLoader(this.isDevelopment(), this.envType, this.provider) : new KnotClassLoader(this.isDevelopment(), this.envType, this.provider);
        ClassLoader cl = (ClassLoader)((Object)this.classLoader);
        this.provider.initialize(this);
        Thread.currentThread().setContextClassLoader(cl);
        FabricLoaderImpl loader = FabricLoaderImpl.INSTANCE;
        loader.setGameProvider(this.provider);
        loader.load();
        loader.freeze();
        FabricLoaderImpl.INSTANCE.loadAccessWideners();
        MixinBootstrap.init();
        FabricMixinBootstrap.init(this.getEnvironmentType(), loader);
        FabricLauncherBase.finishMixinBootstrapping();
        this.classLoader.getDelegate().initializeTransformers();
        this.provider.unlockClassPath(this);
        this.unlocked = true;
        try {
            EntrypointUtils.invoke("preLaunch", PreLaunchEntrypoint.class, PreLaunchEntrypoint::onPreLaunch);
        }
        catch (RuntimeException e) {
            throw new FormattedException("A mod crashed on startup!", e);
        }
        return cl;
    }

    private GameProvider createGameProvider(String[] args) {
        GameProvider embeddedGameProvider = Knot.findEmbedddedGameProvider();
        if (embeddedGameProvider != null && embeddedGameProvider.isEnabled() && embeddedGameProvider.locateGame(this, args)) {
            return embeddedGameProvider;
        }
        ArrayList<GameProvider> failedProviders = new ArrayList<GameProvider>();
        for (GameProvider provider : ServiceLoader.load(GameProvider.class)) {
            if (!provider.isEnabled()) continue;
            if (provider != embeddedGameProvider && provider.locateGame(this, args)) {
                return provider;
            }
            failedProviders.add(provider);
        }
        String msg = failedProviders.isEmpty() ? "No game providers present on the class path!" : (failedProviders.size() == 1 ? String.format("%s game provider couldn't locate the game! The game may be absent from the class path, lacks some expected files, suffers from jar corruption or is of an unsupported variety/version.", ((GameProvider)failedProviders.get(0)).getGameName()) : String.format("None of the game providers (%s) were able to locate their game!", failedProviders.stream().map(GameProvider::getGameName).collect(Collectors.joining(", "))));
        Log.error(LogCategory.GAME_PROVIDER, msg);
        throw new RuntimeException(msg);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static GameProvider findEmbedddedGameProvider() {
        try {
            Path flPath = UrlUtil.asPath(Knot.class.getProtectionDomain().getCodeSource().getLocation());
            if (!flPath.getFileName().toString().endsWith(".jar")) {
                return null;
            }
            try (ZipFile zf = new ZipFile(flPath.toFile());){
                ZipEntry entry = zf.getEntry("META-INF/services/net.fabricmc.loader.impl.game.GameProvider");
                if (entry == null) {
                    GameProvider gameProvider = null;
                    return gameProvider;
                }
                try (InputStream is = zf.getInputStream(entry);){
                    int len;
                    byte[] buffer = new byte[100];
                    int offset = 0;
                    while ((len = is.read(buffer, offset, buffer.length - offset)) >= 0) {
                        if ((offset += len) != buffer.length) continue;
                        buffer = Arrays.copyOf(buffer, buffer.length * 2);
                    }
                    String content = new String(buffer, 0, offset, StandardCharsets.UTF_8).trim();
                    if (content.indexOf(10) >= 0) {
                        GameProvider gameProvider = null;
                        return gameProvider;
                    }
                    int pos = content.indexOf(35);
                    if (pos >= 0) {
                        content = content.substring(0, pos).trim();
                    }
                    if (content.isEmpty()) return null;
                    GameProvider gameProvider = (GameProvider)Class.forName(content).getConstructor(new Class[0]).newInstance(new Object[0]);
                    return gameProvider;
                }
            }
        }
        catch (IOException | ReflectiveOperationException | URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getTargetNamespace() {
        return this.isDevelopment ? "named" : "intermediary";
    }

    @Override
    public List<Path> getClassPath() {
        return this.classPath;
    }

    @Override
    public void addToClassPath(Path path, String ... allowedPrefixes) {
        Log.debug(LogCategory.KNOT, "Adding " + path + " to classpath.");
        try {
            URL url = UrlUtil.asUrl(path);
            this.classLoader.getDelegate().setAllowedPrefixes(url, allowedPrefixes);
            this.classLoader.addURL(url);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setAllowedPrefixes(Path path, String ... prefixes) {
        try {
            this.classLoader.getDelegate().setAllowedPrefixes(UrlUtil.asUrl(path), prefixes);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public EnvType getEnvironmentType() {
        return this.envType;
    }

    @Override
    public boolean isClassLoaded(String name) {
        return this.classLoader.isClassLoaded(name);
    }

    @Override
    public Class<?> loadIntoTarget(String name) throws ClassNotFoundException {
        return this.classLoader.loadIntoTarget(name);
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        try {
            return this.classLoader.getResourceAsStream(name, false);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read file '" + name + "'!", e);
        }
    }

    @Override
    public ClassLoader getTargetClassLoader() {
        return (ClassLoader)((Object)this.classLoader);
    }

    @Override
    public byte[] getClassByteArray(String name, boolean runTransformers) throws IOException {
        if (!this.unlocked) {
            throw new IllegalStateException("early getClassByteArray access");
        }
        if (runTransformers) {
            return this.classLoader.getDelegate().getPreMixinClassByteArray(name, true);
        }
        return this.classLoader.getDelegate().getRawClassByteArray(name, true);
    }

    @Override
    public Manifest getManifest(Path originPath) {
        try {
            return this.classLoader.getDelegate().getMetadata((URL)UrlUtil.asUrl((Path)originPath)).manifest;
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean isDevelopment() {
        return this.isDevelopment;
    }

    @Override
    public String getEntrypoint() {
        return this.provider.getEntrypoint();
    }

    public static void main(String[] args) {
        new Knot(null).init(args);
    }
}

