/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader.impl.gui;

import java.awt.GraphicsEnvironment;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.function.Consumer;
import net.fabricmc.loader.impl.FabricLoaderImpl;
import net.fabricmc.loader.impl.discovery.ClasspathModCandidateFinder;
import net.fabricmc.loader.impl.game.GameProvider;
import net.fabricmc.loader.impl.gui.FabricMainWindow;
import net.fabricmc.loader.impl.gui.FabricStatusTree;
import net.fabricmc.loader.impl.util.LoaderUtil;
import net.fabricmc.loader.impl.util.log.Log;
import net.fabricmc.loader.impl.util.log.LogCategory;

public final class FabricGuiEntry {
    public static void open(FabricStatusTree tree) throws Exception {
        GameProvider provider = FabricLoaderImpl.INSTANCE.tryGetGameProvider();
        if (provider == null && LoaderUtil.hasAwtSupport() || provider != null && provider.hasAwtSupport()) {
            FabricMainWindow.open(tree, true);
        } else {
            FabricGuiEntry.openForked(tree);
        }
    }

    private static void openForked(FabricStatusTree tree) throws IOException, InterruptedException {
        Path javaBinDir = Paths.get(System.getProperty("java.home"), "bin").toAbsolutePath();
        String[] executables = new String[]{"javaw.exe", "java.exe", "java"};
        Path javaPath = null;
        for (String executable : executables) {
            Path path = javaBinDir.resolve(executable);
            if (!Files.isRegularFile(path, new LinkOption[0])) continue;
            javaPath = path;
            break;
        }
        if (javaPath == null) {
            throw new RuntimeException("can't find java executable in " + javaBinDir);
        }
        Path loaderPath = ClasspathModCandidateFinder.getFabricLoaderPath();
        if (loaderPath == null) {
            throw new RuntimeException("can't determine Fabric Loader path");
        }
        Process process = new ProcessBuilder(javaPath.toString(), "-Xmx100M", "-cp", loaderPath.toString(), FabricGuiEntry.class.getName()).redirectOutput(ProcessBuilder.Redirect.INHERIT).redirectError(ProcessBuilder.Redirect.INHERIT).start();
        try (DataOutputStream os = new DataOutputStream(process.getOutputStream());){
            tree.writeTo(os);
        }
        int rVal = process.waitFor();
        if (rVal != 0) {
            throw new IOException("subprocess exited with code " + rVal);
        }
    }

    public static void main(String[] args) throws Exception {
        FabricStatusTree tree = new FabricStatusTree(new DataInputStream(System.in));
        FabricMainWindow.open(tree, true);
        System.exit(0);
    }

    public static void displayCriticalError(Throwable exception, boolean exitAfter) {
        Log.error(LogCategory.GENERAL, "A critical error occurred", exception);
        FabricGuiEntry.displayError("Failed to launch!", exception, exitAfter);
    }

    public static void displayError(String mainText, Throwable exception, boolean exitAfter) {
        FabricGuiEntry.displayError(mainText, exception, tree -> {
            StringWriter error = new StringWriter();
            error.append(mainText);
            if (exception != null) {
                error.append(System.lineSeparator());
                exception.printStackTrace(new PrintWriter(error));
            }
            tree.addButton("Copy error", FabricStatusTree.FabricBasicButtonType.CLICK_MANY).withClipboard(error.toString());
        }, exitAfter);
    }

    public static void displayError(String mainText, Throwable exception, Consumer<FabricStatusTree> treeCustomiser, boolean exitAfter) {
        GameProvider provider = FabricLoaderImpl.INSTANCE.tryGetGameProvider();
        if (!GraphicsEnvironment.isHeadless() && (provider == null || provider.canOpenErrorGui())) {
            String title = "Fabric Loader 0.13.3";
            FabricStatusTree tree = new FabricStatusTree(title, mainText);
            FabricStatusTree.FabricStatusTab crashTab = tree.addTab("Crash");
            if (exception != null) {
                crashTab.node.addCleanedException(exception);
            } else {
                crashTab.node.addMessage("No further details available", FabricStatusTree.FabricTreeWarningLevel.NONE);
            }
            tree.addButton("Exit", FabricStatusTree.FabricBasicButtonType.CLICK_ONCE).makeClose();
            treeCustomiser.accept(tree);
            try {
                FabricGuiEntry.open(tree);
            }
            catch (Exception e) {
                if (exitAfter) {
                    Log.warn(LogCategory.GENERAL, "Failed to open the error gui!", e);
                }
                throw new RuntimeException("Failed to open the error gui!", e);
            }
        }
        if (exitAfter) {
            System.exit(1);
        }
    }
}

