/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader.impl.game.minecraft;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.ObjectShare;
import net.fabricmc.loader.api.VersionParsingException;
import net.fabricmc.loader.api.metadata.ModDependency;
import net.fabricmc.loader.impl.FabricLoaderImpl;
import net.fabricmc.loader.impl.FormattedException;
import net.fabricmc.loader.impl.game.GameProvider;
import net.fabricmc.loader.impl.game.GameProviderHelper;
import net.fabricmc.loader.impl.game.minecraft.BundlerProcessor;
import net.fabricmc.loader.impl.game.minecraft.LibClassifier;
import net.fabricmc.loader.impl.game.minecraft.McVersion;
import net.fabricmc.loader.impl.game.minecraft.McVersionLookup;
import net.fabricmc.loader.impl.game.minecraft.patch.BrandingPatch;
import net.fabricmc.loader.impl.game.minecraft.patch.EntrypointPatch;
import net.fabricmc.loader.impl.game.minecraft.patch.EntrypointPatchFML125;
import net.fabricmc.loader.impl.game.patch.GameTransformer;
import net.fabricmc.loader.impl.launch.FabricLauncher;
import net.fabricmc.loader.impl.metadata.BuiltinModMetadata;
import net.fabricmc.loader.impl.metadata.ModDependencyImpl;
import net.fabricmc.loader.impl.util.Arguments;
import net.fabricmc.loader.impl.util.ExceptionUtil;
import net.fabricmc.loader.impl.util.LoaderUtil;
import net.fabricmc.loader.impl.util.log.Log;
import net.fabricmc.loader.impl.util.log.LogHandler;

public class MinecraftGameProvider
implements GameProvider {
    private static final String[] ALLOWED_EARLY_CLASS_PREFIXES = new String[]{"org.apache.logging.log4j.", "com.mojang.util."};
    private static final Set<String> SENSITIVE_ARGS = new HashSet<String>(Arrays.asList("accesstoken", "clientid", "profileproperties", "proxypass", "proxyuser", "username", "userproperties", "uuid", "xuid"));
    private EnvType envType;
    private String entrypoint;
    private Arguments arguments;
    private Path gameJar;
    private Path realmsJar;
    private final Set<Path> logJars = new HashSet<Path>();
    private boolean log4jAvailable;
    private boolean slf4jAvailable;
    private final List<Path> miscGameLibraries = new ArrayList<Path>();
    private McVersion versionData;
    private boolean useGameJarForLogging;
    private boolean hasModLoader = false;
    private static final GameTransformer TRANSFORMER = new GameTransformer(new EntrypointPatch(), new BrandingPatch(), new EntrypointPatchFML125());

    @Override
    public String getGameId() {
        return "minecraft";
    }

    @Override
    public String getGameName() {
        return "Minecraft";
    }

    @Override
    public String getRawGameVersion() {
        return this.versionData.getRaw();
    }

    @Override
    public String getNormalizedGameVersion() {
        return this.versionData.getNormalized();
    }

    @Override
    public Collection<GameProvider.BuiltinMod> getBuiltinMods() {
        BuiltinModMetadata.Builder metadata = new BuiltinModMetadata.Builder(this.getGameId(), this.getNormalizedGameVersion()).setName(this.getGameName());
        if (this.versionData.getClassVersion().isPresent()) {
            int version = this.versionData.getClassVersion().getAsInt() - 44;
            try {
                metadata.addDependency(new ModDependencyImpl(ModDependency.Kind.DEPENDS, "java", Collections.singletonList(String.format(">=%d", version))));
            }
            catch (VersionParsingException e) {
                throw new RuntimeException(e);
            }
        }
        return Collections.singletonList(new GameProvider.BuiltinMod(Collections.singletonList(this.gameJar), metadata.build()));
    }

    public Path getGameJar() {
        return this.gameJar;
    }

    @Override
    public String getEntrypoint() {
        return this.entrypoint;
    }

    @Override
    public Path getLaunchDirectory() {
        if (this.arguments == null) {
            return Paths.get(".", new String[0]);
        }
        return MinecraftGameProvider.getLaunchDirectory(this.arguments);
    }

    @Override
    public boolean isObfuscated() {
        return true;
    }

    @Override
    public boolean requiresUrlClassLoader() {
        return this.hasModLoader;
    }

    @Override
    public boolean isEnabled() {
        return System.getProperty("fabric.skipMcProvider") == null;
    }

    @Override
    public boolean locateGame(FabricLauncher launcher, String[] args) {
        String version;
        this.envType = launcher.getEnvironmentType();
        this.arguments = new Arguments();
        this.arguments.parse(args);
        try {
            List<Path> lookupPaths;
            String gameJarProperty = System.getProperty("fabric.gameJarPath");
            if (gameJarProperty != null) {
                Path path = Paths.get(gameJarProperty, new String[0]).toAbsolutePath().normalize();
                if (!Files.exists(path, new LinkOption[0])) {
                    throw new RuntimeException("Game jar " + path + " configured through " + "fabric.gameJarPath" + " system property doesn't exist");
                }
                lookupPaths = new ArrayList<Path>();
                lookupPaths.add(path);
                lookupPaths.addAll(launcher.getClassPath());
            } else {
                lookupPaths = launcher.getClassPath();
            }
            LibClassifier classifier = new LibClassifier();
            classifier.process(lookupPaths, this.envType);
            if (classifier.has(LibClassifier.Lib.MC_BUNDLER)) {
                BundlerProcessor.process(classifier);
            }
            LibClassifier.Lib gameLib = this.envType == EnvType.CLIENT ? LibClassifier.Lib.MC_CLIENT : LibClassifier.Lib.MC_SERVER;
            this.gameJar = classifier.getOrigin(gameLib);
            if (this.gameJar == null) {
                return false;
            }
            this.entrypoint = classifier.getClassName(gameLib);
            this.realmsJar = classifier.getOrigin(LibClassifier.Lib.REALMS);
            this.useGameJarForLogging = classifier.is(this.gameJar, LibClassifier.Lib.LOGGING);
            this.hasModLoader = classifier.has(LibClassifier.Lib.MODLOADER);
            this.log4jAvailable = classifier.has(LibClassifier.Lib.LOG4J_API) && classifier.has(LibClassifier.Lib.LOG4J_CORE);
            this.slf4jAvailable = classifier.has(LibClassifier.Lib.SLF4J_API) && classifier.has(LibClassifier.Lib.SLF4J_CORE);
            for (LibClassifier.Lib lib : LibClassifier.Lib.LOGGING) {
                Path path = classifier.getOrigin(lib);
                if (path == null || path.equals(this.gameJar) || lookupPaths.contains(path)) continue;
                this.logJars.add(path);
            }
            for (Path path : classifier.getUnmatchedOrigins()) {
                if (lookupPaths.contains(path)) continue;
                this.miscGameLibraries.add(path);
            }
        }
        catch (IOException e) {
            throw ExceptionUtil.wrap(e);
        }
        if (!this.useGameJarForLogging && this.logJars.isEmpty()) {
            this.setupLogHandler(launcher, false);
        }
        ObjectShare share = FabricLoaderImpl.INSTANCE.getObjectShare();
        share.put("fabric-loader:inputGameJar", this.gameJar);
        if (this.realmsJar != null) {
            share.put("fabric-loader:inputRealmsJar", this.realmsJar);
        }
        if ((version = this.arguments.remove("fabric.gameVersion")) == null) {
            version = System.getProperty("fabric.gameVersion");
        }
        this.versionData = McVersionLookup.getVersion(this.gameJar, this.entrypoint, version);
        MinecraftGameProvider.processArgumentMap(this.arguments, this.envType);
        return true;
    }

    private static void processArgumentMap(Arguments argMap, EnvType envType) {
        switch (envType) {
            case CLIENT: {
                if (!argMap.containsKey("accessToken")) {
                    argMap.put("accessToken", "FabricMC");
                }
                if (!argMap.containsKey("version")) {
                    argMap.put("version", "Fabric");
                }
                String versionType = "";
                if (argMap.containsKey("versionType") && !argMap.get("versionType").equalsIgnoreCase("release")) {
                    versionType = argMap.get("versionType") + "/";
                }
                argMap.put("versionType", versionType + "Fabric");
                if (argMap.containsKey("gameDir")) break;
                argMap.put("gameDir", MinecraftGameProvider.getLaunchDirectory(argMap).toAbsolutePath().normalize().toString());
                break;
            }
            case SERVER: {
                argMap.remove("version");
                argMap.remove("gameDir");
                argMap.remove("assetsDir");
            }
        }
    }

    private static Path getLaunchDirectory(Arguments argMap) {
        return Paths.get(argMap.getOrDefault("gameDir", "."), new String[0]);
    }

    @Override
    public void initialize(FabricLauncher launcher) {
        Map<String, Path> gameJars = new HashMap<String, Path>(2);
        String name = this.envType.name().toLowerCase(Locale.ENGLISH);
        gameJars.put(name, this.gameJar);
        if (this.realmsJar != null) {
            gameJars.put("realms", this.realmsJar);
        }
        if (this.isObfuscated()) {
            gameJars = GameProviderHelper.deobfuscate(gameJars, this.getGameId(), this.getNormalizedGameVersion(), this.getLaunchDirectory(), launcher);
            this.gameJar = gameJars.get(name);
            this.realmsJar = gameJars.get("realms");
        }
        if (this.useGameJarForLogging || !this.logJars.isEmpty()) {
            if (this.useGameJarForLogging) {
                launcher.addToClassPath(this.gameJar, ALLOWED_EARLY_CLASS_PREFIXES);
            }
            if (!this.logJars.isEmpty()) {
                for (Path jar : this.logJars) {
                    launcher.addToClassPath(jar, new String[0]);
                }
            }
            this.setupLogHandler(launcher, true);
        }
        TRANSFORMER.locateEntrypoints(launcher, this.gameJar);
    }

    private void setupLogHandler(FabricLauncher launcher, boolean useTargetCl) {
        System.setProperty("log4j2.formatMsgNoLookups", "true");
        try {
            Class<?> logHandlerCls;
            String logHandlerClsName;
            if (this.log4jAvailable) {
                logHandlerClsName = "net.fabricmc.loader.impl.game.minecraft.Log4jLogHandler";
            } else if (this.slf4jAvailable) {
                logHandlerClsName = "net.fabricmc.loader.impl.game.minecraft.Slf4jLogHandler";
            } else {
                return;
            }
            ClassLoader prevCl = Thread.currentThread().getContextClassLoader();
            if (useTargetCl) {
                Thread.currentThread().setContextClassLoader(launcher.getTargetClassLoader());
                logHandlerCls = launcher.loadIntoTarget(logHandlerClsName);
            } else {
                logHandlerCls = Class.forName(logHandlerClsName);
            }
            Log.init((LogHandler)logHandlerCls.getConstructor(new Class[0]).newInstance(new Object[0]), true);
            Thread.currentThread().setContextClassLoader(prevCl);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Arguments getArguments() {
        return this.arguments;
    }

    @Override
    public String[] getLaunchArguments(boolean sanitize) {
        if (this.arguments == null) {
            return new String[0];
        }
        String[] ret = this.arguments.toArray();
        if (!sanitize) {
            return ret;
        }
        int writeIdx = 0;
        for (int i = 0; i < ret.length; ++i) {
            String arg = ret[i];
            if (i + 1 < ret.length && arg.startsWith("--") && SENSITIVE_ARGS.contains(arg.substring(2).toLowerCase(Locale.ENGLISH))) {
                ++i;
                continue;
            }
            ret[writeIdx++] = arg;
        }
        if (writeIdx < ret.length) {
            ret = Arrays.copyOf(ret, writeIdx);
        }
        return ret;
    }

    @Override
    public GameTransformer getEntrypointTransformer() {
        return TRANSFORMER;
    }

    @Override
    public boolean canOpenErrorGui() {
        if (this.arguments == null || this.envType == EnvType.CLIENT) {
            return true;
        }
        List<String> extras = this.arguments.getExtraArgs();
        return !extras.contains("nogui") && !extras.contains("--nogui");
    }

    @Override
    public boolean hasAwtSupport() {
        return !LoaderUtil.hasMacOs();
    }

    @Override
    public void unlockClassPath(FabricLauncher launcher) {
        if (this.useGameJarForLogging) {
            launcher.setAllowedPrefixes(this.gameJar, new String[0]);
        } else {
            launcher.addToClassPath(this.gameJar, new String[0]);
        }
        if (this.realmsJar != null) {
            launcher.addToClassPath(this.realmsJar, new String[0]);
        }
        for (Path lib : this.miscGameLibraries) {
            launcher.addToClassPath(lib, new String[0]);
        }
    }

    @Override
    public void launch(ClassLoader loader) {
        String targetClass = this.entrypoint;
        if (this.envType == EnvType.CLIENT && targetClass.contains("Applet")) {
            targetClass = "net.fabricmc.loader.impl.game.minecraft.applet.AppletMain";
        }
        try {
            Class<?> c = loader.loadClass(targetClass);
            Method m = c.getMethod("main", String[].class);
            m.invoke(null, new Object[]{this.arguments.toArray()});
        }
        catch (InvocationTargetException e) {
            throw new FormattedException("Minecraft has crashed!", e.getCause());
        }
        catch (ReflectiveOperationException e) {
            throw new FormattedException("Failed to start Minecraft", e);
        }
    }
}

