/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader.impl.game.minecraft;

import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipError;
import java.util.zip.ZipFile;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.impl.util.UrlUtil;

final class LibClassifier {
    private final Map<Lib, Path> matches = new EnumMap<Lib, Path>(Lib.class);
    private final Map<Lib, String> localPaths = new EnumMap<Lib, String>(Lib.class);
    private final List<Path> unmatchedOrigins = new ArrayList<Path>();

    LibClassifier() {
    }

    public void process(URL url, EnvType env) throws IOException {
        try {
            this.process(UrlUtil.asPath(url), env);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("invalid url: " + url);
        }
    }

    public void process(Iterable<Path> paths, EnvType env) throws IOException {
        for (Path path : paths) {
            this.process(path, env);
        }
    }

    public void process(Path path, EnvType env) throws IOException {
        boolean matched = false;
        if (Files.isDirectory(path, new LinkOption[0])) {
            block7: for (Lib lib : Lib.VALUES) {
                if (!lib.isInEnv(env) || this.matches.containsKey((Object)lib)) continue;
                for (String p : lib.paths) {
                    if (!Files.exists(path.resolve(p), new LinkOption[0])) continue;
                    matched = true;
                    this.matches.put(lib, path);
                    this.localPaths.put(lib, p);
                    continue block7;
                }
            }
        } else {
            try (ZipFile zf = new ZipFile(path.toFile());){
                block9: for (Lib lib : Lib.VALUES) {
                    if (!lib.isInEnv(env) || this.matches.containsKey((Object)lib)) continue;
                    for (String p : lib.paths) {
                        ZipEntry entry = zf.getEntry(p);
                        if (entry == null) continue;
                        matched = true;
                        this.matches.put(lib, path);
                        this.localPaths.put(lib, p);
                        continue block9;
                    }
                }
            }
            catch (IOException | ZipError e) {
                throw new IOException("error reading " + path.toAbsolutePath(), e);
            }
        }
        if (!matched) {
            this.unmatchedOrigins.add(path);
        }
    }

    public boolean is(Path path, Lib ... libs) {
        for (Lib lib : libs) {
            if (!path.equals(this.matches.get((Object)lib))) continue;
            return true;
        }
        return false;
    }

    public boolean has(Lib lib) {
        return this.matches.containsKey((Object)lib);
    }

    public Path getOrigin(Lib lib) {
        return this.matches.get((Object)lib);
    }

    public String getLocalPath(Lib lib) {
        return this.localPaths.get((Object)lib);
    }

    public String getClassName(Lib lib) {
        String localPath = this.localPaths.get((Object)lib);
        if (localPath == null || !localPath.endsWith(".class")) {
            return null;
        }
        return localPath.substring(0, localPath.length() - 6).replace('/', '.');
    }

    public List<Path> getUnmatchedOrigins() {
        return this.unmatchedOrigins;
    }

    public boolean remove(Path path) {
        if (this.unmatchedOrigins.remove(path)) {
            return true;
        }
        boolean ret = false;
        Iterator<Map.Entry<Lib, Path>> it = this.matches.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Lib, Path> entry = it.next();
            if (!entry.getValue().equals(path)) continue;
            this.localPaths.remove((Object)entry.getKey());
            it.remove();
            ret = true;
        }
        return ret;
    }

    static enum Lib {
        MC_CLIENT(EnvType.CLIENT, "net/minecraft/client/main/Main.class", "net/minecraft/client/MinecraftApplet.class", "com/mojang/minecraft/MinecraftApplet.class"),
        MC_SERVER(EnvType.SERVER, "net/minecraft/server/Main.class", "net/minecraft/server/MinecraftServer.class", "com/mojang/minecraft/server/MinecraftServer.class"),
        MC_BUNDLER(EnvType.SERVER, "net/minecraft/bundler/Main.class"),
        REALMS(EnvType.CLIENT, "realmsVersion"),
        MODLOADER("ModLoader"),
        LOG4J_API("org/apache/logging/log4j/LogManager.class"),
        LOG4J_CORE("META-INF/services/org.apache.logging.log4j.spi.Provider", "META-INF/log4j-provider.properties"),
        LOG4J_CONFIG("log4j2.xml"),
        LOG4J_PLUGIN("com/mojang/util/QueueLogAppender.class"),
        SLF4J_API("org/slf4j/Logger.class"),
        SLF4J_CORE("META-INF/services/org.slf4j.spi.SLF4JServiceProvider");

        static final Lib[] VALUES;
        static final Lib[] LOGGING;
        final String[] paths;
        final EnvType env;

        private Lib(String path) {
            this((EnvType)null, path);
        }

        private Lib(String ... paths) {
            this((EnvType)null, paths);
        }

        private Lib(EnvType env, String ... paths) {
            this.paths = paths;
            this.env = env;
        }

        boolean isInEnv(EnvType env) {
            return this.env == null || this.env == env;
        }

        static {
            VALUES = Lib.values();
            LOGGING = new Lib[]{LOG4J_API, LOG4J_CORE, LOG4J_CONFIG, LOG4J_PLUGIN, SLF4J_API, SLF4J_CORE};
        }
    }
}

