/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.authlib.yggdrasil;

import com.google.common.collect.Iterables;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.mojang.authlib.AuthenticationService;
import com.mojang.authlib.Environment;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.exceptions.AuthenticationException;
import com.mojang.authlib.exceptions.AuthenticationUnavailableException;
import com.mojang.authlib.minecraft.BaseMinecraftSessionService;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import java.lang.reflect.Type;
import java.net.InetAddress;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import pro.gravit.launcher.events.request.CheckServerRequestEvent;
import pro.gravit.launcher.events.request.JoinServerRequestEvent;
import pro.gravit.launcher.events.request.ProfileByUUIDRequestEvent;
import pro.gravit.launcher.profiles.PlayerProfile;
import pro.gravit.launcher.profiles.Texture;
import pro.gravit.launcher.request.auth.CheckServerRequest;
import pro.gravit.launcher.request.auth.JoinServerRequest;
import pro.gravit.launcher.request.uuid.ProfileByUUIDRequest;
import pro.gravit.utils.helper.LogHelper;
import pro.gravit.utils.helper.SecurityHelper;

public class YggdrasilMinecraftSessionService
extends BaseMinecraftSessionService {
    public static final boolean NO_TEXTURES = Boolean.getBoolean("launcher.com.mojang.authlib.noTextures");
    private static final Type TEXTURES_TYPE_TOKEN = new TypeToken<Map<MinecraftProfileTexture.Type, MinecraftProfileTexture>>(){}.getType();
    private static final Gson GSON = new GsonBuilder().create();

    public YggdrasilMinecraftSessionService(AuthenticationService service, Environment environment) {
        super(service);
        LogHelper.debug((String)"Patched MinecraftSessionService created");
    }

    public YggdrasilMinecraftSessionService(YggdrasilAuthenticationService service, Environment environment) {
        super(service);
        LogHelper.debug((String)"Patched MinecraftSessionService created");
    }

    public static void fillTextureProperties(GameProfile profile, PlayerProfile pp) {
        boolean debug = LogHelper.isDebugEnabled();
        if (debug) {
            LogHelper.debug((String)"fillTextureProperties, Username: '%s'", (Object[])new Object[]{profile.getName()});
        }
        if (NO_TEXTURES) {
            return;
        }
        HashMap<MinecraftProfileTexture.Type, MinecraftProfileTexture> textures = new HashMap<MinecraftProfileTexture.Type, MinecraftProfileTexture>();
        try {
            if (pp.assets != null) {
                for (MinecraftProfileTexture.Type type : MinecraftProfileTexture.Type.values()) {
                    String name = type.name();
                    Texture texture = (Texture)pp.assets.get(name);
                    if (texture == null) continue;
                    textures.put(type, YggdrasilMinecraftSessionService.makeMinecraftTexture(texture));
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        String serializedData = Base64.getEncoder().encodeToString(GSON.toJson(textures).getBytes(StandardCharsets.UTF_8));
        Property textureProperty = new Property("textures", serializedData, "");
        profile.getProperties().put("textures", textureProperty);
    }

    private static MinecraftProfileTexture makeMinecraftTexture(Texture texture) {
        return new MinecraftProfileTexture(texture.url, SecurityHelper.toHex((byte[])texture.digest), texture.metadata);
    }

    public static GameProfile toGameProfile(PlayerProfile pp) {
        GameProfile profile = new GameProfile(pp.uuid, pp.username);
        try {
            if (pp.properties != null) {
                PropertyMap propertyMap = profile.getProperties();
                for (Map.Entry prop : pp.properties.entrySet()) {
                    propertyMap.put((String)prop.getKey(), new Property((String)prop.getKey(), (String)prop.getValue(), ""));
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        YggdrasilMinecraftSessionService.fillTextureProperties(profile, pp);
        return profile;
    }

    @Override
    public GameProfile fillProfileProperties(GameProfile profile, boolean requireSecure) {
        PlayerProfile pp;
        UUID uuid = profile.getId();
        boolean debug = LogHelper.isDebugEnabled();
        if (debug) {
            LogHelper.debug((String)"fillProfileProperties, UUID: %s", (Object[])new Object[]{uuid});
        }
        if (uuid == null) {
            return profile;
        }
        try {
            pp = ((ProfileByUUIDRequestEvent)new ProfileByUUIDRequest((UUID)uuid).request()).playerProfile;
        }
        catch (Exception e) {
            if (debug) {
                LogHelper.debug((String)"Couldn't fetch profile properties for '%s': %s", (Object[])new Object[]{profile, e});
            }
            return profile;
        }
        if (pp == null) {
            if (debug) {
                LogHelper.debug((String)"Couldn't fetch profile properties for '%s' as the profile does not exist", (Object[])new Object[]{profile});
            }
            return profile;
        }
        if (debug) {
            LogHelper.debug((String)"Successfully fetched profile properties for '%s'", (Object[])new Object[]{profile});
        }
        YggdrasilMinecraftSessionService.fillTextureProperties(profile, pp);
        return YggdrasilMinecraftSessionService.toGameProfile(pp);
    }

    @Override
    public Map<MinecraftProfileTexture.Type, MinecraftProfileTexture> getTextures(GameProfile profile, boolean requireSecure) {
        Property texturesProperty;
        if (LogHelper.isDebugEnabled()) {
            LogHelper.debug((String)"getTextures, Username: '%s', UUID: '%s'", (Object[])new Object[]{profile.getName(), profile.getId()});
        }
        EnumMap<MinecraftProfileTexture.Type, MinecraftProfileTexture> textures = new EnumMap<MinecraftProfileTexture.Type, MinecraftProfileTexture>(MinecraftProfileTexture.Type.class);
        if (!NO_TEXTURES && (texturesProperty = (Property)Iterables.getFirst((Iterable)profile.getProperties().get("textures"), null)) != null) {
            String serializedData = new String(Base64.getDecoder().decode(texturesProperty.getValue()), StandardCharsets.UTF_8);
            Map texturesMap = (Map)GSON.fromJson(serializedData, TEXTURES_TYPE_TOKEN);
            textures.putAll(texturesMap);
        }
        return textures;
    }

    public GameProfile hasJoinedServer(GameProfile profile, String serverID) throws AuthenticationUnavailableException {
        PlayerProfile pp;
        String username = profile.getName();
        if (LogHelper.isDebugEnabled()) {
            LogHelper.debug((String)"checkServer, Username: '%s', Server ID: %s", (Object[])new Object[]{username, serverID});
        }
        try {
            pp = ((CheckServerRequestEvent)new CheckServerRequest((String)username, (String)serverID).request()).playerProfile;
        }
        catch (Exception e) {
            LogHelper.error((Throwable)e);
            throw new AuthenticationUnavailableException(e);
        }
        return pp == null ? null : YggdrasilMinecraftSessionService.toGameProfile(pp);
    }

    @Override
    public GameProfile hasJoinedServer(GameProfile profile, String serverID, InetAddress address) throws AuthenticationUnavailableException {
        return this.hasJoinedServer(profile, serverID);
    }

    @Override
    public YggdrasilAuthenticationService getAuthenticationService() {
        return (YggdrasilAuthenticationService)super.getAuthenticationService();
    }

    @Override
    public void joinServer(GameProfile profile, String accessToken, String serverID) throws AuthenticationException {
        boolean success;
        String username = profile.getName();
        if (LogHelper.isDebugEnabled()) {
            LogHelper.debug((String)"joinServer, Username: '%s', Access token: %s, Server ID: %s", (Object[])new Object[]{username, accessToken, serverID});
        }
        try {
            success = ((JoinServerRequestEvent)new JoinServerRequest((String)username, (String)accessToken, (String)serverID).request()).allow;
        }
        catch (Exception e) {
            LogHelper.error((Throwable)e);
            throw new AuthenticationUnavailableException(e);
        }
        if (!success) {
            throw new AuthenticationException("Bad Login (Clientside)");
        }
    }
}

