/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.authlib.yggdrasil;

import com.mojang.authlib.Agent;
import com.mojang.authlib.AuthenticationService;
import com.mojang.authlib.Environment;
import com.mojang.authlib.EnvironmentParser;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.UserAuthentication;
import com.mojang.authlib.exceptions.AuthenticationException;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.yggdrasil.YggdrasilEnvironment;
import com.mojang.authlib.yggdrasil.YggdrasilGameProfileRepository;
import com.mojang.authlib.yggdrasil.YggdrasilMinecraftSessionService;
import com.mojang.authlib.yggdrasil.YggdrasilSocialInteractionsService;
import java.net.Proxy;
import pro.gravit.utils.helper.LogHelper;

public class YggdrasilAuthenticationService
implements AuthenticationService {
    private final Environment environment;

    public YggdrasilAuthenticationService(Proxy proxy) {
        this(proxy, YggdrasilAuthenticationService.determineEnvironment());
    }

    public YggdrasilAuthenticationService(Proxy proxy, Environment environment) {
        this(proxy, null, environment);
    }

    public YggdrasilAuthenticationService(Proxy proxy, String clientToken) {
        this(proxy, clientToken, YggdrasilAuthenticationService.determineEnvironment());
    }

    public YggdrasilAuthenticationService(Proxy proxy, String clientToken, Environment environment) {
        this.environment = environment;
        LogHelper.debug((String)"Patched AuthenticationService created: '%s'", (Object[])new Object[]{clientToken});
    }

    private static Environment determineEnvironment() {
        return EnvironmentParser.getEnvironmentFromProperties().orElse(YggdrasilEnvironment.PROD);
    }

    @Override
    public UserAuthentication createUserAuthentication(Agent agent) {
        throw new UnsupportedOperationException("createUserAuthentication is used only by Mojang Launcher");
    }

    @Override
    public MinecraftSessionService createMinecraftSessionService() {
        return new YggdrasilMinecraftSessionService(this, this.environment);
    }

    @Override
    public GameProfileRepository createProfileRepository() {
        return new YggdrasilGameProfileRepository(this, this.environment);
    }

    public YggdrasilSocialInteractionsService createSocialInteractionsService(String accessToken) throws AuthenticationException {
        return new YggdrasilSocialInteractionsService(this, accessToken, this.environment);
    }
}

